/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentCombining;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityScrapTrader;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.inventory.LOTRSlotAnvilOutput;
import lotr.common.inventory.OddmentCollectorNameMischief;
import lotr.common.item.AnvilNameColorProvider;
import lotr.common.item.LOTRItemBlowgun;
import lotr.common.item.LOTRItemChisel;
import lotr.common.item.LOTRItemCoin;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemEnchantment;
import lotr.common.item.LOTRItemModifierTemplate;
import lotr.common.item.LOTRItemOwnership;
import lotr.common.item.LOTRItemThrowingAxe;
import lotr.common.item.LOTRMaterial;
import lotr.common.recipe.LOTRRecipePoisonWeapon;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class LOTRContainerAnvil
extends Container {
    public IInventory invOutput;
    public IInventory invInput;
    public final EntityPlayer thePlayer;
    public final World theWorld;
    public final boolean isTrader;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    public LOTREntityNPC theNPC;
    public LOTRTradeable theTrader;
    public int materialCost;
    public int reforgeCost;
    public int engraveOwnerCost;
    private String repairedItemName;
    private long lastReforgeTime = -1L;
    public static final int maxReforgeTime = 40;
    public int clientReforgeTime;
    private boolean doneMischief;
    public boolean isSmithScrollCombine;

    private LOTRContainerAnvil(EntityPlayer entityplayer, boolean trader) {
        this.thePlayer = entityplayer;
        this.theWorld = entityplayer.field_70170_p;
        this.isTrader = trader;
        this.invOutput = new InventoryCraftResult();
        this.invInput = new InventoryBasic("Repair", true, this.isTrader ? 2 : 3){

            public void func_70296_d() {
                super.func_70296_d();
                LOTRContainerAnvil.this.func_75130_a((IInventory)this);
            }
        };
        this.func_75146_a(new Slot(this.invInput, 0, 27, 58));
        this.func_75146_a(new Slot(this.invInput, 1, 76, 47));
        if (!this.isTrader) {
            this.func_75146_a(new Slot(this.invInput, 2, 76, 70));
        }
        this.func_75146_a(new LOTRSlotAnvilOutput(this, this.invOutput, 0, 134, 58));
        for (int j1 = 0; j1 < 3; ++j1) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)entityplayer.field_71071_by, i1 + j1 * 9 + 9, 8 + i1 * 18, 116 + j1 * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)entityplayer.field_71071_by, i1, 8 + i1 * 18, 174));
        }
    }

    public LOTRContainerAnvil(EntityPlayer entityplayer, int i, int j, int k) {
        this(entityplayer, false);
        this.xCoord = i;
        this.yCoord = j;
        this.zCoord = k;
    }

    public LOTRContainerAnvil(EntityPlayer entityplayer, LOTREntityNPC npc) {
        this(entityplayer, true);
        this.theNPC = npc;
        this.theTrader = (LOTRTradeable)((Object)npc);
    }

    public void func_75130_a(IInventory inv) {
        super.func_75130_a(inv);
        if (inv == this.invInput) {
            this.updateRepairOutput();
        }
    }

    private void updateRepairOutput() {
        ItemStack inputItem = this.invInput.func_70301_a(0);
        this.materialCost = 0;
        this.reforgeCost = 0;
        this.engraveOwnerCost = 0;
        this.isSmithScrollCombine = false;
        int baseAnvilCost = 0;
        int repairCost = 0;
        int combineCost = 0;
        int renameCost = 0;
        if (inputItem == null) {
            this.invOutput.func_70299_a(0, null);
            this.materialCost = 0;
        } else {
            boolean repairing;
            int oneItemRepair;
            LOTREnchantmentCombining.CombineRecipe scrollCombine;
            boolean costRename;
            String nameToApply;
            ItemStack inputCopy = inputItem.func_77946_l();
            ItemStack combinerItem = this.invInput.func_70301_a(1);
            ItemStack materialItem = this.isTrader ? null : this.invInput.func_70301_a(2);
            Map inputEnchants = EnchantmentHelper.func_82781_a((ItemStack)inputCopy);
            boolean enchantingWithBook = false;
            List<LOTREnchantment> inputModifiers = LOTREnchantmentHelper.getEnchantList(inputCopy);
            baseAnvilCost = LOTREnchantmentHelper.getAnvilCost(inputItem) + (combinerItem == null ? 0 : LOTREnchantmentHelper.getAnvilCost(combinerItem));
            this.materialCost = 0;
            String previousDisplayName = inputCopy.func_82833_r();
            String defaultItemName = inputCopy.func_77973_b().func_77653_i(inputCopy);
            String formattedNameToApply = nameToApply = this.repairedItemName;
            ArrayList<EnumChatFormatting> colorsToApply = new ArrayList<EnumChatFormatting>();
            colorsToApply.addAll(LOTRContainerAnvil.getAppliedFormattingCodes(inputCopy.func_82833_r()));
            boolean alteringNameColor = false;
            if (LOTRContainerAnvil.costsToRename(inputItem) && combinerItem != null) {
                if (combinerItem.func_77973_b() instanceof AnvilNameColorProvider) {
                    boolean isDifferentColor;
                    AnvilNameColorProvider nameColorProvider = (AnvilNameColorProvider)combinerItem.func_77973_b();
                    EnumChatFormatting newColor = nameColorProvider.getAnvilNameColor();
                    boolean bl = isDifferentColor = !colorsToApply.contains(newColor);
                    if (isDifferentColor) {
                        for (EnumChatFormatting ecf : EnumChatFormatting.values()) {
                            if (!ecf.func_96302_c()) continue;
                            while (colorsToApply.contains(ecf)) {
                                colorsToApply.remove(ecf);
                            }
                        }
                        colorsToApply.add(newColor);
                        alteringNameColor = true;
                    }
                } else if (combinerItem.func_77973_b() == Items.field_151145_ak && !colorsToApply.isEmpty()) {
                    colorsToApply.clear();
                    alteringNameColor = true;
                }
                if (alteringNameColor) {
                    ++renameCost;
                }
            }
            if (!colorsToApply.isEmpty()) {
                if (StringUtils.isBlank((CharSequence)formattedNameToApply)) {
                    formattedNameToApply = defaultItemName;
                }
                formattedNameToApply = LOTRContainerAnvil.applyFormattingCodes(formattedNameToApply, colorsToApply);
            }
            boolean nameChange = false;
            if (formattedNameToApply != null && !formattedNameToApply.equals(previousDisplayName)) {
                if (StringUtils.isBlank((CharSequence)formattedNameToApply) || formattedNameToApply.equals(defaultItemName)) {
                    if (inputCopy.func_82837_s()) {
                        inputCopy.func_135074_t();
                        if (!LOTRContainerAnvil.stripFormattingCodes(previousDisplayName).equals(LOTRContainerAnvil.stripFormattingCodes(formattedNameToApply))) {
                            nameChange = true;
                        }
                    }
                } else {
                    inputCopy.func_151001_c(formattedNameToApply);
                    if (!LOTRContainerAnvil.stripFormattingCodes(previousDisplayName).equals(LOTRContainerAnvil.stripFormattingCodes(formattedNameToApply))) {
                        nameChange = true;
                    }
                }
            }
            if (nameChange && (costRename = LOTRContainerAnvil.costsToRename(inputItem))) {
                ++renameCost;
            }
            if (this.isTrader && (scrollCombine = LOTREnchantmentCombining.getCombinationResult(inputItem, combinerItem)) != null) {
                this.invOutput.func_70299_a(0, scrollCombine.createOutputItem());
                this.materialCost = scrollCombine.cost;
                this.reforgeCost = 0;
                this.engraveOwnerCost = 0;
                this.isSmithScrollCombine = true;
                return;
            }
            boolean combining = false;
            if (combinerItem != null) {
                boolean bl = enchantingWithBook = combinerItem.func_77973_b() == Items.field_151134_bR && Items.field_151134_bR.func_92110_g(combinerItem).func_74745_c() > 0;
                if (enchantingWithBook && !LOTRConfig.enchantingVanilla) {
                    this.invOutput.func_70299_a(0, null);
                    this.materialCost = 0;
                    return;
                }
                LOTREnchantment combinerItemEnchant = null;
                if (combinerItem.func_77973_b() instanceof LOTRItemEnchantment) {
                    combinerItemEnchant = ((LOTRItemEnchantment)combinerItem.func_77973_b()).theEnchant;
                } else if (combinerItem.func_77973_b() instanceof LOTRItemModifierTemplate) {
                    combinerItemEnchant = LOTRItemModifierTemplate.getModifier(combinerItem);
                }
                if (!enchantingWithBook && combinerItemEnchant == null) {
                    if (inputCopy.func_77984_f() && inputCopy.func_77973_b() == combinerItem.func_77973_b()) {
                        int inputUseLeft = inputItem.func_77958_k() - inputItem.func_77952_i();
                        int combinerUseLeft = combinerItem.func_77958_k() - combinerItem.func_77952_i();
                        int restoredUses = combinerUseLeft + inputCopy.func_77958_k() * 12 / 100;
                        int newUsesLeft = inputUseLeft + restoredUses;
                        int newDamage = inputCopy.func_77958_k() - newUsesLeft;
                        if ((newDamage = Math.max(newDamage, 0)) < inputCopy.func_77960_j()) {
                            inputCopy.func_77964_b(newDamage);
                            int restoredUses1 = inputCopy.func_77958_k() - inputUseLeft;
                            int restoredUses2 = inputCopy.func_77958_k() - combinerUseLeft;
                            combineCost += Math.max(0, Math.min(restoredUses1, restoredUses2) / 100);
                        }
                        combining = true;
                    } else if (!alteringNameColor) {
                        this.invOutput.func_70299_a(0, null);
                        this.materialCost = 0;
                        return;
                    }
                }
                HashMap outputEnchants = new HashMap(inputEnchants);
                if (LOTRConfig.enchantingVanilla) {
                    Map combinerEnchants = EnchantmentHelper.func_82781_a((ItemStack)combinerItem);
                    for (Object obj : combinerEnchants.keySet()) {
                        int combinerEnchLevel;
                        int combinerEnchID = (Integer)obj;
                        Enchantment combinerEnch = Enchantment.field_77331_b[combinerEnchID];
                        int inputEnchLevel = 0;
                        if (outputEnchants.containsKey(combinerEnchID)) {
                            inputEnchLevel = (Integer)outputEnchants.get(combinerEnchID);
                        }
                        int combinedEnchLevel = inputEnchLevel == (combinerEnchLevel = ((Integer)combinerEnchants.get(combinerEnchID)).intValue()) ? ++combinerEnchLevel : Math.max(combinerEnchLevel, inputEnchLevel);
                        combinerEnchLevel = combinedEnchLevel;
                        int levelsAdded = combinerEnchLevel - inputEnchLevel;
                        boolean canApply = combinerEnch.func_92089_a(inputItem);
                        if (this.thePlayer.field_71075_bZ.field_75098_d || inputItem.func_77973_b() == Items.field_151134_bR) {
                            canApply = true;
                        }
                        for (Object objIn : outputEnchants.keySet()) {
                            int inputEnchID = (Integer)objIn;
                            Enchantment inputEnch = Enchantment.field_77331_b[inputEnchID];
                            if (inputEnchID == combinerEnchID || combinerEnch.func_77326_a(inputEnch) && inputEnch.func_77326_a(combinerEnch)) continue;
                            canApply = false;
                            combineCost += levelsAdded;
                        }
                        if (!canApply) continue;
                        combinerEnchLevel = Math.min(combinerEnchLevel, combinerEnch.func_77325_b());
                        outputEnchants.put(combinerEnchID, combinerEnchLevel);
                        int costPerLevel = 0;
                        int enchWeight = combinerEnch.func_77324_c();
                        if (enchWeight == 1) {
                            costPerLevel = 8;
                        } else if (enchWeight == 2) {
                            costPerLevel = 4;
                        } else if (enchWeight == 5) {
                            costPerLevel = 2;
                        } else if (enchWeight == 10) {
                            costPerLevel = 1;
                        }
                        combineCost += costPerLevel * levelsAdded;
                    }
                } else {
                    outputEnchants.clear();
                }
                EnchantmentHelper.func_82782_a((Map)outputEnchants, (ItemStack)inputCopy);
                int maxMods = 3;
                ArrayList<LOTREnchantment> outputMods = new ArrayList<LOTREnchantment>();
                outputMods.addAll(inputModifiers);
                List<LOTREnchantment> combinerMods = LOTREnchantmentHelper.getEnchantList(combinerItem);
                if (combinerItemEnchant != null) {
                    Item item;
                    combinerMods.add(combinerItemEnchant);
                    if (combinerItemEnchant == LOTREnchantment.fire && LOTRRecipePoisonWeapon.poisonedToInput.containsKey(item = inputCopy.func_77973_b())) {
                        Item unpoisoned = LOTRRecipePoisonWeapon.poisonedToInput.get(item);
                        inputCopy.func_150996_a(unpoisoned);
                    }
                }
                for (LOTREnchantment combinerMod : combinerMods) {
                    boolean canApply = combinerMod.canApply(inputItem, false);
                    if (canApply) {
                        for (LOTREnchantment mod : outputMods) {
                            if (mod.isCompatibleWith(combinerMod) && combinerMod.isCompatibleWith(mod)) continue;
                            canApply = false;
                        }
                    }
                    int numOutputMods = 0;
                    for (LOTREnchantment mod : outputMods) {
                        if (mod.bypassAnvilLimit()) continue;
                        ++numOutputMods;
                    }
                    if (!combinerMod.bypassAnvilLimit() && numOutputMods >= maxMods) {
                        canApply = false;
                    }
                    if (!canApply) continue;
                    outputMods.add(combinerMod);
                    if (!combinerMod.isBeneficial()) continue;
                    combineCost += Math.max(1, (int)combinerMod.getValueModifier());
                }
                LOTREnchantmentHelper.setEnchantList(inputCopy, outputMods);
            }
            if (combineCost > 0) {
                combining = true;
            }
            int numEnchants = 0;
            for (Object obj : inputEnchants.keySet()) {
                int enchID = (Integer)obj;
                Enchantment ench = Enchantment.field_77331_b[enchID];
                int enchLevel = (Integer)inputEnchants.get(enchID);
                ++numEnchants;
                int costPerLevel = 0;
                int enchWeight = ench.func_77324_c();
                if (enchWeight == 1) {
                    costPerLevel = 8;
                } else if (enchWeight == 2) {
                    costPerLevel = 4;
                } else if (enchWeight == 5) {
                    costPerLevel = 2;
                } else if (enchWeight == 10) {
                    costPerLevel = 1;
                }
                baseAnvilCost += numEnchants + enchLevel * costPerLevel;
            }
            if (enchantingWithBook && !inputCopy.func_77973_b().isBookEnchantable(inputCopy, combinerItem)) {
                inputCopy = null;
            }
            for (LOTREnchantment mod : inputModifiers) {
                if (!mod.isBeneficial()) continue;
                baseAnvilCost += Math.max(1, (int)mod.getValueModifier());
            }
            if (inputCopy.func_77984_f()) {
                boolean canRepair = false;
                int availableMaterials = 0;
                if (this.isTrader) {
                    canRepair = this.getTraderMaterialPrice(inputItem) > 0.0f;
                    availableMaterials = Integer.MAX_VALUE;
                } else {
                    boolean bl = canRepair = materialItem != null && this.isRepairMaterial(inputItem, materialItem);
                    if (materialItem != null) {
                        availableMaterials = materialItem.field_77994_a - combineCost - renameCost;
                    }
                }
                oneItemRepair = Math.min(inputCopy.func_77952_i(), inputCopy.func_77958_k() / 4);
                if (canRepair && availableMaterials > 0 && oneItemRepair > 0) {
                    if ((availableMaterials -= baseAnvilCost) > 0) {
                        int usedMaterials;
                        for (usedMaterials = 0; oneItemRepair > 0 && usedMaterials < availableMaterials; ++usedMaterials) {
                            int newDamage = inputCopy.func_77952_i() - oneItemRepair;
                            inputCopy.func_77964_b(newDamage);
                            oneItemRepair = Math.min(inputCopy.func_77952_i(), inputCopy.func_77958_k() / 4);
                        }
                        repairCost += usedMaterials;
                    } else if (!nameChange && !combining) {
                        repairCost = 1;
                        int newDamage = inputCopy.func_77952_i() - oneItemRepair;
                        inputCopy.func_77964_b(newDamage);
                    }
                }
            }
            boolean bl = repairing = repairCost > 0;
            if (combining || repairing) {
                this.materialCost = baseAnvilCost;
                this.materialCost += combineCost + repairCost;
            } else {
                this.materialCost = 0;
            }
            this.materialCost += renameCost;
            if (inputCopy != null) {
                int nextAnvilCost = LOTREnchantmentHelper.getAnvilCost(inputItem);
                if (combinerItem != null) {
                    int combinerAnvilCost = LOTREnchantmentHelper.getAnvilCost(combinerItem);
                    nextAnvilCost = Math.max(nextAnvilCost, combinerAnvilCost);
                }
                if (combining) {
                    nextAnvilCost += 2;
                } else if (repairing) {
                    ++nextAnvilCost;
                }
                nextAnvilCost = Math.max(nextAnvilCost, 0);
                if (nextAnvilCost > 0) {
                    LOTREnchantmentHelper.setAnvilCost(inputCopy, nextAnvilCost);
                }
            }
            if (LOTREnchantmentHelper.isReforgeable(inputItem)) {
                ItemStack reforgeCopy;
                this.reforgeCost = 2;
                if (inputItem.func_77973_b() instanceof ItemArmor) {
                    this.reforgeCost = 3;
                }
                if (inputItem.func_77984_f() && (oneItemRepair = Math.min((reforgeCopy = inputItem.func_77946_l()).func_77952_i(), reforgeCopy.func_77958_k() / 4)) > 0) {
                    int usedMaterials = 0;
                    while (oneItemRepair > 0) {
                        int newDamage = reforgeCopy.func_77952_i() - oneItemRepair;
                        reforgeCopy.func_77964_b(newDamage);
                        oneItemRepair = Math.min(reforgeCopy.func_77952_i(), reforgeCopy.func_77958_k() / 4);
                        ++usedMaterials;
                    }
                    this.reforgeCost += usedMaterials;
                }
                this.engraveOwnerCost = 2;
            } else {
                this.reforgeCost = 0;
                this.engraveOwnerCost = 0;
            }
            if (this.isRepairMaterial(inputItem, new ItemStack(Items.field_151007_F))) {
                int stringFactor = 3;
                this.materialCost *= stringFactor;
                this.reforgeCost *= stringFactor;
                this.engraveOwnerCost *= stringFactor;
            }
            if (this.isTrader) {
                boolean isCommonRenameOnly = nameChange && this.materialCost == 0;
                float materialPrice = this.getTraderMaterialPrice(inputItem);
                if (materialPrice > 0.0f) {
                    this.materialCost = Math.round((float)this.materialCost * materialPrice);
                    this.materialCost = Math.max(this.materialCost, 1);
                    this.reforgeCost = Math.round((float)this.reforgeCost * materialPrice);
                    this.reforgeCost = Math.max(this.reforgeCost, 1);
                    this.engraveOwnerCost = Math.round((float)this.engraveOwnerCost * materialPrice);
                    this.engraveOwnerCost = Math.max(this.engraveOwnerCost, 1);
                    if (this.theTrader instanceof LOTREntityScrapTrader) {
                        this.materialCost = MathHelper.func_76123_f((float)((float)this.materialCost * 0.5f));
                        this.materialCost = Math.max(this.materialCost, 1);
                        this.reforgeCost = MathHelper.func_76123_f((float)((float)this.reforgeCost * 0.5f));
                        this.reforgeCost = Math.max(this.reforgeCost, 1);
                        this.engraveOwnerCost = MathHelper.func_76123_f((float)((float)this.engraveOwnerCost * 0.5f));
                        this.engraveOwnerCost = Math.max(this.engraveOwnerCost, 1);
                    }
                } else if (!isCommonRenameOnly) {
                    this.invOutput.func_70299_a(0, null);
                    this.materialCost = 0;
                    this.reforgeCost = 0;
                    this.engraveOwnerCost = 0;
                    return;
                }
            }
            if (combining || repairing || nameChange || alteringNameColor) {
                this.invOutput.func_70299_a(0, inputCopy);
            } else {
                this.invOutput.func_70299_a(0, null);
                this.materialCost = 0;
            }
            this.func_75142_b();
        }
    }

    private static boolean costsToRename(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemSword || item instanceof ItemTool) {
            return true;
        }
        if (item instanceof ItemArmor && ((ItemArmor)item).field_77879_b > 0) {
            return true;
        }
        return item instanceof ItemBow || item instanceof LOTRItemCrossbow || item instanceof LOTRItemThrowingAxe || item instanceof LOTRItemBlowgun;
    }

    private static List<EnumChatFormatting> getAppliedFormattingCodes(String name) {
        ArrayList<EnumChatFormatting> colors = new ArrayList<EnumChatFormatting>();
        for (EnumChatFormatting color : EnumChatFormatting.values()) {
            String formatCode = color.toString();
            if (!name.startsWith(formatCode)) continue;
            colors.add(color);
        }
        return colors;
    }

    public static String stripFormattingCodes(String name) {
        for (EnumChatFormatting color : EnumChatFormatting.values()) {
            String formatCode = color.toString();
            if (!name.startsWith(formatCode)) continue;
            name = name.substring(formatCode.length());
        }
        return name;
    }

    private static String applyFormattingCodes(String name, List<EnumChatFormatting> colors) {
        for (EnumChatFormatting color : colors) {
            name = color + name;
        }
        return name;
    }

    public List<EnumChatFormatting> getActiveItemNameFormatting() {
        ItemStack inputItem = this.invInput.func_70301_a(0);
        ItemStack resultItem = this.invOutput.func_70301_a(0);
        if (resultItem != null) {
            return LOTRContainerAnvil.getAppliedFormattingCodes(resultItem.func_82833_r());
        }
        if (inputItem != null) {
            return LOTRContainerAnvil.getAppliedFormattingCodes(inputItem.func_82833_r());
        }
        return new ArrayList<EnumChatFormatting>();
    }

    public boolean isRepairMaterial(ItemStack inputItem, ItemStack materialItem) {
        ItemArmor armor;
        ItemArmor.ArmorMaterial armorMaterial;
        if (inputItem.func_77973_b().func_82789_a(inputItem, materialItem)) {
            return true;
        }
        Item item = inputItem.func_77973_b();
        if (item == Items.field_151031_f && LOTRMod.rohanBow.func_82789_a(inputItem, materialItem)) {
            return true;
        }
        if (item instanceof ItemFishingRod && materialItem.func_77973_b() == Items.field_151007_F) {
            return true;
        }
        if (item instanceof ItemShears && materialItem.func_77973_b() == Items.field_151042_j) {
            return true;
        }
        if (item instanceof LOTRItemChisel && materialItem.func_77973_b() == Items.field_151042_j) {
            return true;
        }
        if (item instanceof ItemEnchantedBook && materialItem.func_77973_b() == Items.field_151121_aF) {
            return true;
        }
        Item.ToolMaterial material = null;
        if (item instanceof ItemTool) {
            material = Item.ToolMaterial.valueOf((String)((ItemTool)item).func_77861_e());
        } else if (item instanceof ItemSword) {
            material = Item.ToolMaterial.valueOf((String)((ItemSword)item).func_150932_j());
        }
        if (material == Item.ToolMaterial.WOOD || material == LOTRMaterial.MOREDAIN_WOOD.toToolMaterial()) {
            return LOTRMod.isOreNameEqual(materialItem, "plankWood");
        }
        if (material == LOTRMaterial.MALLORN.toToolMaterial()) {
            return materialItem.func_77973_b() == Item.func_150898_a((Block)LOTRMod.planks) && materialItem.func_77960_j() == 1;
        }
        if (material == LOTRMaterial.MALLORN_MACE.toToolMaterial()) {
            return materialItem.func_77973_b() == Item.func_150898_a((Block)LOTRMod.wood) && materialItem.func_77960_j() == 1;
        }
        if (item instanceof ItemArmor && (armorMaterial = (armor = (ItemArmor)item).func_82812_d()) == LOTRMaterial.BONE.toArmorMaterial()) {
            return LOTRMod.isOreNameEqual(materialItem, "bone");
        }
        return false;
    }

    private float getTraderMaterialPrice(ItemStack inputItem) {
        float materialPrice = 0.0f;
        LOTRTradeEntry[] sellTrades = this.theNPC.traderNPCInfo.getSellTrades();
        if (sellTrades != null) {
            for (LOTRTradeEntry trade : sellTrades) {
                ItemStack tradeItem = trade.createTradeItem();
                if (!this.isRepairMaterial(inputItem, tradeItem)) continue;
                materialPrice = (float)trade.getCost() / (float)trade.createTradeItem().field_77994_a;
                break;
            }
        }
        if (materialPrice <= 0.0f) {
            LOTRTradeEntries sellPool = this.theTrader.getSellPool();
            for (LOTRTradeEntry trade : sellPool.tradeEntries) {
                ItemStack tradeItem = trade.createTradeItem();
                if (!this.isRepairMaterial(inputItem, tradeItem)) continue;
                materialPrice = (float)trade.getCost() / (float)trade.createTradeItem().field_77994_a;
                break;
            }
        }
        if (materialPrice <= 0.0f && (this.isRepairMaterial(inputItem, new ItemStack(LOTRMod.mithril)) || this.isRepairMaterial(inputItem, new ItemStack(LOTRMod.mithrilMail))) && this.theTrader instanceof LOTREntityDwarf) {
            materialPrice = 200.0f;
        }
        return materialPrice;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting crafting = (ICrafting)this.field_75149_d.get(i);
            crafting.func_71112_a((Container)this, 0, this.materialCost);
            crafting.func_71112_a((Container)this, 1, this.reforgeCost);
            crafting.func_71112_a((Container)this, 3, this.engraveOwnerCost);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (i == 0) {
            this.materialCost = j;
        }
        if (i == 1) {
            this.reforgeCost = j;
        }
        if (i == 2) {
            this.clientReforgeTime = 40;
        }
        if (i == 3) {
            this.engraveOwnerCost = j;
        }
    }

    public boolean hasMaterialOrCoinAmount(int cost) {
        if (this.isTrader) {
            return LOTRItemCoin.getInventoryValue(this.thePlayer, false) >= cost;
        }
        ItemStack inputItem = this.invInput.func_70301_a(0);
        ItemStack materialItem = this.invInput.func_70301_a(2);
        if (materialItem != null) {
            return this.isRepairMaterial(inputItem, materialItem) && materialItem.field_77994_a >= cost;
        }
        return false;
    }

    public void takeMaterialOrCoinAmount(int cost) {
        if (this.isTrader) {
            if (!this.theWorld.field_72995_K) {
                LOTRItemCoin.takeCoins(cost, this.thePlayer);
                this.func_75142_b();
                this.theNPC.playTradeSound();
            }
        } else {
            ItemStack materialItem = this.invInput.func_70301_a(2);
            if (materialItem != null) {
                materialItem.field_77994_a -= cost;
                if (materialItem.field_77994_a <= 0) {
                    this.invInput.func_70299_a(2, null);
                } else {
                    this.invInput.func_70299_a(2, materialItem);
                }
            }
        }
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        if (!this.theWorld.field_72995_K) {
            for (int i = 0; i < this.invInput.func_70302_i_(); ++i) {
                ItemStack itemstack = this.invInput.func_70304_b(i);
                if (itemstack == null) continue;
                entityplayer.func_71019_a(itemstack, false);
            }
            if (this.doneMischief && this.isTrader && this.theNPC instanceof LOTREntityScrapTrader) {
                this.theNPC.sendSpeechBank(entityplayer, ((LOTREntityScrapTrader)this.theNPC).getSmithSpeechBank());
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.isTrader) {
            return this.theNPC != null && (double)entityplayer.func_70032_d((Entity)this.theNPC) <= 12.0 && this.theNPC.func_70089_S() && this.theNPC.func_70638_az() == null && this.theTrader.canTradeWith(entityplayer);
        }
        return this.theWorld.func_147439_a(this.xCoord, this.yCoord, this.zCoord) == Blocks.field_150467_bQ && entityplayer.func_70092_e((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public ItemStack func_75144_a(int slotNo, int j, int k, EntityPlayer entityplayer) {
        ItemStack resultCopy;
        ItemStack resultItem = this.invOutput.func_70301_a(0);
        resultItem = ItemStack.func_77944_b((ItemStack)resultItem);
        boolean changed = false;
        if (resultItem != null && slotNo == this.func_75147_a((IInventory)this.invOutput, (int)0).field_75222_d && !this.theWorld.field_72995_K && this.isTrader && this.theNPC instanceof LOTREntityScrapTrader && (changed = this.applyMischief(resultCopy = resultItem.func_77946_l()))) {
            this.invOutput.func_70299_a(0, resultCopy);
        }
        ItemStack slotClickResult = super.func_75144_a(slotNo, j, k, entityplayer);
        if (changed) {
            this.doneMischief = true;
            if (this.invOutput.func_70301_a(0) != null) {
                this.invOutput.func_70299_a(0, resultItem.func_77946_l());
            }
        }
        return slotClickResult;
    }

    public ItemStack func_82846_b(EntityPlayer entityplayer, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int inputSize = this.invInput.func_70302_i_();
            if (i == inputSize) {
                if (!this.func_75135_a(itemstack1, inputSize + 1, inputSize + 37, true)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (i >= inputSize + 1 ? i >= inputSize + 1 && i < inputSize + 37 && !this.func_75135_a(itemstack1, 0, inputSize, false) : !this.func_75135_a(itemstack1, inputSize + 1, inputSize + 37, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityplayer, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String name) {
        List<EnumChatFormatting> colors = LOTRContainerAnvil.getAppliedFormattingCodes(name);
        name = LOTRContainerAnvil.stripFormattingCodes(name);
        this.repairedItemName = name = ChatAllowedCharacters.func_71565_a((String)name);
        ItemStack itemstack = this.invOutput.func_70301_a(0);
        if (itemstack != null) {
            if (StringUtils.isBlank((CharSequence)this.repairedItemName)) {
                itemstack.func_135074_t();
            } else {
                itemstack.func_151001_c(this.repairedItemName);
            }
            if (!colors.isEmpty()) {
                itemstack.func_151001_c(LOTRContainerAnvil.applyFormattingCodes(itemstack.func_82833_r(), colors));
            }
        }
        this.updateRepairOutput();
    }

    public void reforgeItem() {
        ItemStack inputItem;
        long curTime = System.currentTimeMillis();
        if ((this.lastReforgeTime < 0L || curTime - this.lastReforgeTime >= 2000L) && (inputItem = this.invInput.func_70301_a(0)) != null && this.reforgeCost > 0 && this.hasMaterialOrCoinAmount(this.reforgeCost)) {
            boolean changed;
            int cost = this.reforgeCost;
            if (inputItem.func_77984_f()) {
                inputItem.func_77964_b(0);
            }
            LOTREnchantmentHelper.applyRandomEnchantments(inputItem, this.theWorld.field_73012_v, true, true);
            LOTREnchantmentHelper.setAnvilCost(inputItem, 0);
            if (this.isTrader && this.theNPC instanceof LOTREntityScrapTrader && (changed = this.applyMischief(inputItem))) {
                this.doneMischief = true;
            }
            this.invInput.func_70299_a(0, inputItem);
            this.takeMaterialOrCoinAmount(cost);
            this.playAnvilSound();
            this.lastReforgeTime = curTime;
            ((EntityPlayerMP)this.thePlayer).func_71112_a((Container)this, 2, 0);
            if (!this.isTrader) {
                LOTRLevelData.getData(this.thePlayer).addAchievement(LOTRAchievement.reforge);
            }
        }
    }

    public boolean canEngraveNewOwner(ItemStack itemstack, EntityPlayer entityplayer) {
        String currentOwner = LOTRItemOwnership.getCurrentOwner(itemstack);
        if (currentOwner == null) {
            return true;
        }
        return !currentOwner.equals(entityplayer.func_70005_c_());
    }

    public void engraveOwnership() {
        ItemStack inputItem = this.invInput.func_70301_a(0);
        if (inputItem != null && this.engraveOwnerCost > 0 && this.hasMaterialOrCoinAmount(this.engraveOwnerCost)) {
            boolean changed;
            int cost = this.engraveOwnerCost;
            LOTRItemOwnership.setCurrentOwner(inputItem, this.thePlayer.func_70005_c_());
            if (this.isTrader && this.theNPC instanceof LOTREntityScrapTrader && (changed = this.applyMischief(inputItem))) {
                this.doneMischief = true;
            }
            this.invInput.func_70299_a(0, inputItem);
            this.takeMaterialOrCoinAmount(cost);
            this.playAnvilSound();
            LOTRLevelData.getData(this.thePlayer).addAchievement(LOTRAchievement.engraveOwnership);
        }
    }

    private boolean applyMischief(ItemStack itemstack) {
        boolean changed = false;
        Random rand = this.theWorld.field_73012_v;
        if (rand.nextFloat() < 0.8f) {
            String name = itemstack.func_82833_r();
            if ((name = OddmentCollectorNameMischief.garbleName(name, rand)).equals(itemstack.func_77973_b().func_77653_i(itemstack))) {
                itemstack.func_135074_t();
            } else {
                itemstack.func_151001_c(name);
            }
            changed = true;
        }
        if (rand.nextFloat() < 0.2f) {
            LOTREnchantmentHelper.applyRandomEnchantments(itemstack, rand, false, true);
            changed = true;
        }
        return changed;
    }

    public void playAnvilSound() {
        if (!this.theWorld.field_72995_K) {
            int k;
            int j;
            int i;
            if (this.isTrader) {
                i = MathHelper.func_76128_c((double)this.theNPC.field_70165_t);
                j = MathHelper.func_76128_c((double)this.theNPC.field_70163_u);
                k = MathHelper.func_76128_c((double)this.theNPC.field_70161_v);
            } else {
                i = this.xCoord;
                j = this.yCoord;
                k = this.zCoord;
            }
            this.theWorld.func_72926_e(1021, i, j, k, 0);
        }
    }
}

