/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lotr.common.entity.item.LOTREntityBarrel;
import lotr.common.tileentity.LOTRTileEntityBarrel;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LOTRItemBarrel
extends ItemBlock {
    public LOTRItemBarrel(Block block) {
        super(block);
    }

    public static void setBarrelData(ItemStack itemstack, NBTTagCompound nbt) {
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74782_a("LOTRBarrelData", (NBTBase)nbt);
    }

    public static NBTTagCompound getBarrelData(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("LOTRBarrelData")) {
            NBTTagCompound barrelData = itemstack.func_77978_p().func_74775_l("LOTRBarrelData");
            return barrelData;
        }
        return null;
    }

    public static void setBarrelDataFromTE(ItemStack itemstack, LOTRTileEntityBarrel barrel) {
        NBTTagCompound nbt = new NBTTagCompound();
        barrel.writeBarrelToNBT(nbt);
        LOTRItemBarrel.setBarrelData(itemstack, nbt);
    }

    public static void loadBarrelDataToTE(ItemStack itemstack, LOTRTileEntityBarrel barrel) {
        NBTTagCompound nbt = LOTRItemBarrel.getBarrelData(itemstack);
        if (nbt != null) {
            barrel.readBarrelFromNBT(nbt);
        }
    }

    public int getItemStackLimit(ItemStack itemstack) {
        NBTTagCompound nbt = LOTRItemBarrel.getBarrelData(itemstack);
        if (nbt != null) {
            return 1;
        }
        return super.getItemStackLimit(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        NBTTagCompound barrelData = LOTRItemBarrel.getBarrelData(itemstack);
        if (barrelData != null) {
            LOTRTileEntityBarrel tileEntity = new LOTRTileEntityBarrel();
            tileEntity.readBarrelFromNBT(barrelData);
            list.add(tileEntity.getInvSubtitle());
        }
    }

    public boolean placeBlockAt(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float f, float f1, float f2, int metadata) {
        if (super.placeBlockAt(itemstack, entityplayer, world, i, j, k, side, f, f1, f2, metadata)) {
            TileEntity tileentity = world.func_147438_o(i, j, k);
            if (tileentity instanceof LOTRTileEntityBarrel) {
                LOTRTileEntityBarrel barrel = (LOTRTileEntityBarrel)tileentity;
                LOTRItemBarrel.loadBarrelDataToTE(itemstack, barrel);
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MovingObjectPosition m = this.func_77621_a(world, entityplayer, true);
        if (m == null) {
            return itemstack;
        }
        if (m.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = m.field_72311_b;
            int j = m.field_72312_c;
            int k = m.field_72309_d;
            if (world.func_147439_a(i, j, k).func_149688_o() != Material.field_151586_h || world.func_72805_g(i, j, k) != 0) {
                return itemstack;
            }
            LOTREntityBarrel barrel = new LOTREntityBarrel(world, (float)i + 0.5f, (float)j + 1.0f, (float)k + 0.5f);
            barrel.field_70177_z = (float)((MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) - 1) * 90.0f;
            if (!world.func_72945_a((Entity)barrel, barrel.field_70121_D.func_72314_b(-0.1, -0.1, -0.1)).isEmpty()) {
                return itemstack;
            }
            if (!world.field_72995_K) {
                NBTTagCompound barrelData;
                barrel.barrelItemData = barrelData = LOTRItemBarrel.getBarrelData(itemstack);
                world.func_72838_d((Entity)barrel);
            }
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
        }
        return itemstack;
    }
}

