/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.projectile.LOTREntityDart;
import lotr.common.item.LOTRItemDart;
import lotr.common.item.LOTRMaterial;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTRItemBlowgun
extends Item {
    public LOTRItemBlowgun(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemBlowgun(Item.ToolMaterial material) {
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.func_77637_a(LOTRCreativeTabs.tabCombat);
        this.func_77664_n();
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        ItemStack dartItem = null;
        int dartSlot = -1;
        for (int l = 0; l < entityplayer.field_71071_by.field_70462_a.length; ++l) {
            ItemStack invItem = entityplayer.field_71071_by.field_70462_a[l];
            if (invItem == null || !(invItem.func_77973_b() instanceof LOTRItemDart)) continue;
            dartItem = invItem;
            dartSlot = l;
            break;
        }
        if (dartItem == null && entityplayer.field_71075_bZ.field_75098_d) {
            dartItem = new ItemStack(LOTRMod.tauredainDart);
        }
        if (dartItem != null) {
            int useTick = this.func_77626_a(itemstack) - i;
            float charge = (float)useTick / (float)this.getMaxDrawTime();
            if (charge < 0.65f) {
                return;
            }
            charge = (charge * charge + charge * 2.0f) / 3.0f;
            charge = Math.min(charge, 1.0f);
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            if (!entityplayer.field_71075_bZ.field_75098_d && dartSlot >= 0) {
                --dartItem.field_77994_a;
                if (dartItem.field_77994_a <= 0) {
                    entityplayer.field_71071_by.field_70462_a[dartSlot] = null;
                }
            }
            world.func_72956_a((Entity)entityplayer, "lotr:item.dart", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
            if (!world.field_72995_K) {
                ItemStack shotDart = dartItem.func_77946_l();
                shotDart.field_77994_a = 1;
                LOTREntityDart dart = ((LOTRItemDart)shotDart.func_77973_b()).createDart(world, (EntityLivingBase)entityplayer, shotDart, charge * 2.0f * LOTRItemBlowgun.getBlowgunLaunchSpeedFactor(itemstack));
                if (dart.dartDamageFactor < 1.0f) {
                    dart.dartDamageFactor = 1.0f;
                }
                if (charge >= 1.0f) {
                    dart.setIsCritical(true);
                }
                LOTRItemBlowgun.applyBlowgunModifiers(dart, itemstack);
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    dart.canBePickedUp = 2;
                }
                world.func_72838_d((Entity)dart);
            }
        }
    }

    public static float getBlowgunLaunchSpeedFactor(ItemStack itemstack) {
        float f = 1.0f;
        if (itemstack != null) {
            f *= LOTREnchantmentHelper.calcRangedDamageFactor(itemstack);
        }
        return f;
    }

    public static void applyBlowgunModifiers(LOTREntityDart dart, ItemStack itemstack) {
        int fireAspect;
        int punch = LOTREnchantmentHelper.calcRangedKnockback(itemstack);
        if (punch > 0) {
            dart.knockbackStrength = punch;
        }
        if ((fireAspect = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) + LOTREnchantmentHelper.calcFireAspect(itemstack)) > 0) {
            dart.func_70015_d(100);
        }
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.applyToProjectile() || !LOTREnchantmentHelper.hasEnchant(itemstack, ench)) continue;
            LOTREnchantmentHelper.setProjectileEnchantment(dart, ench);
        }
    }

    public int getMaxDrawTime() {
        return 5;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        boolean anyDart = false;
        for (ItemStack invItem : entityplayer.field_71071_by.field_70462_a) {
            if (invItem == null || !(invItem.func_77973_b() instanceof LOTRItemDart)) continue;
            anyDart = true;
            break;
        }
        if (anyDart || entityplayer.field_71075_bZ.field_75098_d) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public boolean func_82789_a(ItemStack itemstack, ItemStack repairItem) {
        return repairItem.func_77973_b() == Item.func_150898_a((Block)LOTRMod.reeds);
    }
}

