/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import lotr.common.dispenser.LOTRDispenseSpear;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRMaterial;
import net.minecraft.block.BlockDispenser;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTRItemSpear
extends LOTRItemSword {
    public LOTRItemSpear(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemSpear(Item.ToolMaterial material) {
        super(material);
        this.lotrWeaponDamage -= 1.0f;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new LOTRDispenseSpear());
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        int fireAspect;
        if (entityplayer.func_70694_bm() != itemstack) {
            return;
        }
        int useTick = this.func_77626_a(itemstack) - i;
        float charge = (float)useTick / (float)this.getMaxDrawTime();
        if (charge < 0.1f) {
            return;
        }
        charge = (charge * charge + charge * 2.0f) / 3.0f;
        charge = Math.min(charge, 1.0f);
        LOTREntitySpear spear = new LOTREntitySpear(world, (EntityLivingBase)entityplayer, itemstack.func_77946_l(), charge * 2.0f);
        if (charge >= 1.0f) {
            spear.setIsCritical(true);
        }
        if ((fireAspect = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) + LOTREnchantmentHelper.calcFireAspect(itemstack)) > 0) {
            spear.func_70015_d(100);
        }
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.applyToProjectile() || !LOTREnchantmentHelper.hasEnchant(itemstack, ench)) continue;
            LOTREnchantmentHelper.setProjectileEnchantment(spear, ench);
        }
        if (entityplayer.field_71075_bZ.field_75098_d) {
            spear.canBePickedUp = 2;
        }
        world.func_72956_a((Entity)entityplayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)spear);
        }
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
        }
    }

    public int getMaxDrawTime() {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public float getRangedDamageMultiplier(ItemStack itemstack, Entity shooter, Entity hit) {
        float damage = this.getLOTRWeaponDamage();
        damage = shooter instanceof EntityLivingBase && hit instanceof EntityLivingBase ? (damage += EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)shooter), (EntityLivingBase)((EntityLivingBase)hit))) : (damage += EnchantmentHelper.func_152377_a((ItemStack)itemstack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED));
        return damage * 0.7f;
    }
}

