/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.fellowship.LOTRFellowship;
import lotr.common.fellowship.LOTRFellowshipClient;
import lotr.common.network.LOTRPacketFellowshipAcceptInviteResult;
import lotr.common.network.LOTRPacketFellowshipDo;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class LOTRPacketFellowshipRespondInvite
extends LOTRPacketFellowshipDo {
    private boolean accept;

    public LOTRPacketFellowshipRespondInvite() {
    }

    public LOTRPacketFellowshipRespondInvite(LOTRFellowshipClient fs, boolean accept) {
        super(fs);
        this.accept = accept;
    }

    @Override
    public void toBytes(ByteBuf data) {
        super.toBytes(data);
        data.writeBoolean(this.accept);
    }

    @Override
    public void fromBytes(ByteBuf data) {
        super.fromBytes(data);
        this.accept = data.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<LOTRPacketFellowshipRespondInvite, IMessage> {
        public IMessage onMessage(LOTRPacketFellowshipRespondInvite packet, MessageContext context) {
            EntityPlayerMP entityplayer = context.getServerHandler().field_147369_b;
            LOTRPlayerData playerData = LOTRLevelData.getData((EntityPlayer)entityplayer);
            LOTRFellowship fellowship = packet.getActiveOrDisbandedFellowship();
            if (fellowship != null) {
                if (packet.accept) {
                    playerData.acceptFellowshipInvite(fellowship, true);
                } else {
                    playerData.rejectFellowshipInvite(fellowship);
                }
            } else {
                LOTRPacketFellowshipAcceptInviteResult resultPacket = new LOTRPacketFellowshipAcceptInviteResult(LOTRPacketFellowshipAcceptInviteResult.AcceptInviteResult.NONEXISTENT);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)resultPacket, entityplayer);
            }
            return null;
        }
    }
}

