/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRShields;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class LOTRPacketSelectShield
implements IMessage {
    private LOTRShields shield;

    public LOTRPacketSelectShield() {
    }

    public LOTRPacketSelectShield(LOTRShields s) {
        this.shield = s;
    }

    public void toBytes(ByteBuf data) {
        if (this.shield == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(this.shield.shieldID);
            data.writeByte(this.shield.shieldType.ordinal());
        }
    }

    public void fromBytes(ByteBuf data) {
        byte shieldID = data.readByte();
        if (shieldID == -1) {
            this.shield = null;
        } else {
            byte shieldTypeID = data.readByte();
            if (shieldTypeID < 0 || shieldTypeID >= LOTRShields.ShieldType.values().length) {
                FMLLog.severe((String)("Failed to update LOTR shield on server side: There is no shieldtype with ID " + shieldTypeID), (Object[])new Object[0]);
            } else {
                LOTRShields.ShieldType shieldType = LOTRShields.ShieldType.values()[shieldTypeID];
                if (shieldID < 0 || shieldID >= shieldType.list.size()) {
                    FMLLog.severe((String)("Failed to update LOTR shield on server side: There is no shield with ID " + shieldID + " for shieldtype " + shieldTypeID), (Object[])new Object[0]);
                } else {
                    this.shield = shieldType.list.get(shieldID);
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<LOTRPacketSelectShield, IMessage> {
        public IMessage onMessage(LOTRPacketSelectShield packet, MessageContext context) {
            EntityPlayerMP entityplayer = context.getServerHandler().field_147369_b;
            LOTRShields shield = packet.shield;
            if (shield == null || shield.canPlayerWear((EntityPlayer)entityplayer)) {
                LOTRLevelData.getData((EntityPlayer)entityplayer).setShield(shield);
                LOTRLevelData.sendShieldToAllPlayersInWorld((EntityPlayer)entityplayer, entityplayer.field_70170_p);
            } else {
                FMLLog.severe((String)("Failed to update LOTR shield on server side: Player " + entityplayer.func_70005_c_() + " cannot wear shield " + shield.name()), (Object[])new Object[0]);
            }
            return null;
        }
    }
}

