/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.fac.LOTRFactionBounties;
import lotr.common.quest.LOTRMiniQuest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class LOTRMiniQuestBounty
extends LOTRMiniQuest {
    private static final int KILL_THRESHOLD = 25;
    private static final float MIN_ALIGNMENT_LOWERING = 100.0f;
    public UUID targetID;
    public String targetName;
    public boolean killed;
    public float alignmentBonus;
    public int coinBonus;
    private boolean bountyClaimedByOther;
    private boolean killedByBounty;

    public LOTRMiniQuestBounty(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.targetID != null) {
            nbt.func_74778_a("TargetID", this.targetID.toString());
        }
        if (this.targetName != null) {
            nbt.func_74778_a("TargetName", this.targetName);
        }
        nbt.func_74757_a("Killed", this.killed);
        nbt.func_74776_a("AlignF", this.alignmentBonus);
        nbt.func_74768_a("Coins", this.coinBonus);
        nbt.func_74757_a("BountyClaimed", this.bountyClaimedByOther);
        nbt.func_74757_a("KilledBy", this.killedByBounty);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("TargetID")) {
            String s = nbt.func_74779_i("TargetID");
            this.targetID = UUID.fromString(s);
        }
        if (nbt.func_74764_b("TargetName")) {
            this.targetName = nbt.func_74779_i("TargetName");
        }
        this.killed = nbt.func_74767_n("Killed");
        this.alignmentBonus = nbt.func_74764_b("Alignment") ? (float)nbt.func_74762_e("Alignment") : nbt.func_74760_g("AlignF");
        this.coinBonus = nbt.func_74762_e("Coins");
        this.bountyClaimedByOther = nbt.func_74767_n("BountyClaimed");
        this.killedByBounty = nbt.func_74767_n("KilledBy");
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.targetID != null;
    }

    @Override
    public boolean canPlayerAccept(EntityPlayer entityplayer) {
        if (super.canPlayerAccept(entityplayer) && !this.targetID.equals(entityplayer.func_110124_au()) && LOTRLevelData.getData(entityplayer).getAlignment(this.entityFaction) >= 100.0f) {
            LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
            List<LOTRMiniQuest> active = pd.getActiveMiniQuests();
            for (LOTRMiniQuest quest : active) {
                if (!(quest instanceof LOTRMiniQuestBounty) || !((LOTRMiniQuestBounty)quest).targetID.equals(this.targetID)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getQuestObjective() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.bounty", (Object[])new Object[]{this.targetName});
    }

    @Override
    public String getObjectiveInSpeech() {
        return this.targetName;
    }

    @Override
    public String getProgressedObjectiveInSpeech() {
        return this.targetName;
    }

    @Override
    public String getQuestProgress() {
        if (this.killed) {
            return StatCollector.func_74838_a((String)"lotr.miniquest.bounty.progress.slain");
        }
        return StatCollector.func_74838_a((String)"lotr.miniquest.bounty.progress.notSlain");
    }

    @Override
    public String getQuestProgressShorthand() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.progressShort", (Object[])new Object[]{this.killed ? 1 : 0, 1});
    }

    @Override
    public float getCompletionFactor() {
        return this.killed ? 1.0f : 0.0f;
    }

    @Override
    public ItemStack getQuestIcon() {
        return new ItemStack(Items.field_151040_l);
    }

    @Override
    public void onInteract(EntityPlayer entityplayer, LOTREntityNPC npc) {
        if (this.killed) {
            this.complete(entityplayer, npc);
        } else {
            this.sendProgressSpeechbank(entityplayer, npc);
        }
    }

    @Override
    public void onKill(EntityPlayer entityplayer, EntityLivingBase entity) {
        if (!this.killed && !this.isFailed() && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_110124_au().equals(this.targetID)) {
            EntityPlayer slainPlayer = (EntityPlayer)entity;
            LOTRPlayerData slainPlayerData = LOTRLevelData.getData(slainPlayer);
            this.killed = true;
            LOTRFactionBounties.forFaction(this.entityFaction).forPlayer(slainPlayer).recordBountyKilled();
            this.updateQuest();
            LOTRFaction highestFaction = this.getPledgeOrHighestAlignmentFaction(slainPlayer, 100.0f);
            if (highestFaction != null) {
                float alignmentLoss;
                float curAlignment = slainPlayerData.getAlignment(highestFaction);
                if (curAlignment + (alignmentLoss = this.getKilledAlignmentPenalty()) < 100.0f) {
                    alignmentLoss = -(curAlignment - 100.0f);
                }
                LOTRAlignmentValues.AlignmentBonus source = new LOTRAlignmentValues.AlignmentBonus(alignmentLoss, "lotr.alignment.bountyKilled");
                slainPlayerData.addAlignment(slainPlayer, source, highestFaction, (Entity)entityplayer);
                ChatComponentTranslation slainMsg1 = new ChatComponentTranslation("chat.lotr.bountyKilled1", new Object[]{entityplayer.func_70005_c_(), this.entityFaction.factionName()});
                ChatComponentTranslation slainMsg2 = new ChatComponentTranslation("chat.lotr.bountyKilled2", new Object[]{highestFaction.factionName()});
                slainMsg1.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                slainMsg2.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                slainPlayer.func_145747_a((IChatComponent)slainMsg1);
                slainPlayer.func_145747_a((IChatComponent)slainMsg2);
            }
            ChatComponentTranslation announceMsg = new ChatComponentTranslation("chat.lotr.bountyKill", new Object[]{entityplayer.func_70005_c_(), slainPlayer.func_70005_c_(), this.entityFaction.factionName()});
            announceMsg.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                EntityPlayer otherPlayer = (EntityPlayer)obj;
                if (otherPlayer == slainPlayer) continue;
                otherPlayer.func_145747_a((IChatComponent)announceMsg);
            }
        }
    }

    @Override
    public void onKilledByPlayer(EntityPlayer entityplayer, EntityPlayer killer) {
        if (!this.killed && !this.isFailed() && killer.func_110124_au().equals(this.targetID)) {
            LOTRPlayerData pd;
            float curAlignment;
            LOTRPlayerData killerData = LOTRLevelData.getData(killer);
            LOTRFaction killerHighestFaction = this.getPledgeOrHighestAlignmentFaction(killer, 0.0f);
            if (killerHighestFaction != null) {
                float killerBonus = this.getAlignmentBonus();
                LOTRAlignmentValues.AlignmentBonus source = new LOTRAlignmentValues.AlignmentBonus(killerBonus, "lotr.alignment.killedHunter");
                killerData.addAlignment(killer, source, killerHighestFaction, (Entity)entityplayer);
            }
            if ((curAlignment = (pd = this.getPlayerData()).getAlignment(this.entityFaction)) > 100.0f) {
                float alignmentLoss = this.getKilledAlignmentPenalty();
                if (curAlignment + alignmentLoss < 100.0f) {
                    alignmentLoss = -(curAlignment - 100.0f);
                }
                LOTRAlignmentValues.AlignmentBonus source = new LOTRAlignmentValues.AlignmentBonus(alignmentLoss, "lotr.alignment.killedByBounty");
                pd.addAlignment(entityplayer, source, this.entityFaction, (Entity)killer);
                ChatComponentTranslation slainMsg1 = new ChatComponentTranslation("chat.lotr.killedByBounty1", new Object[]{killer.func_70005_c_()});
                ChatComponentTranslation slainMsg2 = new ChatComponentTranslation("chat.lotr.killedByBounty2", new Object[]{this.entityFaction.factionName()});
                slainMsg1.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                slainMsg2.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
                entityplayer.func_145747_a((IChatComponent)slainMsg1);
                entityplayer.func_145747_a((IChatComponent)slainMsg2);
            }
            this.killedByBounty = true;
            this.updateQuest();
            killerData.addAchievement(LOTRAchievement.killHuntingPlayer);
            ChatComponentTranslation announceMsg = new ChatComponentTranslation("chat.lotr.killedByBounty", new Object[]{entityplayer.func_70005_c_(), killer.func_70005_c_()});
            announceMsg.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                EntityPlayer otherPlayer = (EntityPlayer)obj;
                if (otherPlayer == entityplayer) continue;
                otherPlayer.func_145747_a((IChatComponent)announceMsg);
            }
        }
    }

    private LOTRFaction getPledgeOrHighestAlignmentFaction(EntityPlayer entityplayer, float min) {
        LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
        if (pd.getPledgeFaction() != null) {
            return pd.getPledgeFaction();
        }
        ArrayList<LOTRFaction> highestFactions = new ArrayList<LOTRFaction>();
        float highestAlignment = min;
        for (LOTRFaction f : LOTRFaction.getPlayableAlignmentFactions()) {
            float alignment = pd.getAlignment(f);
            if (!(alignment > min)) continue;
            if (alignment > highestAlignment) {
                highestFactions.clear();
                highestFactions.add(f);
                highestAlignment = alignment;
                continue;
            }
            if (alignment != highestAlignment) continue;
            highestFactions.add(f);
        }
        if (!highestFactions.isEmpty()) {
            Random rand = entityplayer.func_70681_au();
            LOTRFaction highestFaction = (LOTRFaction)((Object)highestFactions.get(rand.nextInt(highestFactions.size())));
            return highestFaction;
        }
        return null;
    }

    @Override
    public void onPlayerTick(EntityPlayer entityplayer) {
        super.onPlayerTick(entityplayer);
        if (this.isActive() && !this.killed && !this.bountyClaimedByOther && LOTRFactionBounties.forFaction(this.entityFaction).forPlayer(this.targetID).recentlyBountyKilled()) {
            this.bountyClaimedByOther = true;
            this.updateQuest();
        }
    }

    @Override
    public boolean isFailed() {
        return super.isFailed() || this.bountyClaimedByOther || this.killedByBounty;
    }

    @Override
    public String getQuestFailure() {
        if (this.killedByBounty) {
            return StatCollector.func_74837_a((String)"lotr.miniquest.bounty.killedBy", (Object[])new Object[]{this.targetName});
        }
        if (this.bountyClaimedByOther) {
            return StatCollector.func_74837_a((String)"lotr.miniquest.bounty.claimed", (Object[])new Object[]{this.targetName});
        }
        return super.getQuestFailure();
    }

    @Override
    public String getQuestFailureShorthand() {
        if (this.killedByBounty) {
            return StatCollector.func_74838_a((String)"lotr.miniquest.bounty.killedBy.short");
        }
        if (this.bountyClaimedByOther) {
            return StatCollector.func_74838_a((String)"lotr.miniquest.bounty.claimed.short");
        }
        return super.getQuestFailureShorthand();
    }

    @Override
    public void start(EntityPlayer entityplayer, LOTREntityNPC npc) {
        super.start(entityplayer, npc);
        LOTRLevelData.getData(this.targetID).placeBountyFor(npc.getFaction());
    }

    @Override
    protected void complete(EntityPlayer entityplayer, LOTREntityNPC npc) {
        boolean specialReward;
        LOTRPlayerData pd = this.getPlayerData();
        pd.addCompletedBountyQuest();
        int bComplete = pd.getCompletedBountyQuests();
        boolean bl = specialReward = bComplete > 0 && bComplete % 5 == 0;
        if (specialReward) {
            ItemStack trophy = new ItemStack(LOTRMod.bountyTrophy);
            this.rewardItemTable.add(trophy);
        }
        super.complete(entityplayer, npc);
        pd.addAchievement(LOTRAchievement.doMiniquestHunter);
        if (specialReward) {
            pd.addAchievement(LOTRAchievement.doMiniquestHunter5);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return this.alignmentBonus;
    }

    public float getKilledAlignmentPenalty() {
        return -this.getAlignmentBonus() * 2.0f;
    }

    @Override
    public int getCoinBonus() {
        return this.coinBonus;
    }

    @Override
    protected boolean shouldRandomiseCoinReward() {
        return false;
    }

    public static enum BountyHelp {
        BIOME("biome"),
        WAYPOINT("wp");

        public final String speechName;

        private BountyHelp(String s) {
            this.speechName = s;
        }

        public static BountyHelp getRandomHelpType(Random random) {
            return BountyHelp.values()[random.nextInt(BountyHelp.values().length)];
        }
    }

    public static class QFBounty<Q extends LOTRMiniQuestBounty>
    extends LOTRMiniQuest.QuestFactoryBase<Q> {
        public QFBounty(String name) {
            super(name);
        }

        @Override
        public Class getQuestClass() {
            return LOTRMiniQuestBounty.class;
        }

        @Override
        public Q createQuest(LOTREntityNPC npc, Random rand) {
            if (!LOTRConfig.allowBountyQuests) {
                return null;
            }
            LOTRMiniQuestBounty quest = (LOTRMiniQuestBounty)super.createQuest(npc, rand);
            LOTRFaction faction = npc.getFaction();
            LOTRFactionBounties bounties = LOTRFactionBounties.forFaction(faction);
            List<LOTRFactionBounties.PlayerData> players = bounties.findBountyTargets(25);
            if (players.isEmpty()) {
                return null;
            }
            LOTRFactionBounties.PlayerData targetData = players.get(rand.nextInt(players.size()));
            int kills = targetData.getNumKills();
            float f = kills;
            int alignment = (int)f;
            alignment = MathHelper.func_76125_a((int)alignment, (int)1, (int)50);
            int coins = (int)(f * 10.0f * MathHelper.func_151240_a((Random)rand, (float)0.75f, (float)1.25f));
            coins = MathHelper.func_76125_a((int)coins, (int)1, (int)1000);
            quest.targetID = targetData.playerID;
            String username = targetData.findUsername();
            if (StringUtils.isBlank((CharSequence)username)) {
                username = quest.targetID.toString();
            }
            quest.targetName = username;
            quest.alignmentBonus = alignment;
            quest.coinBonus = coins;
            return (Q)quest;
        }
    }
}

