/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.quest;

import java.util.Random;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemMug;
import lotr.common.quest.IPickpocketable;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestCollectBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;

public class LOTRMiniQuestCollect
extends LOTRMiniQuestCollectBase {
    public ItemStack collectItem;

    public LOTRMiniQuestCollect(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.collectItem != null) {
            NBTTagCompound itemData = new NBTTagCompound();
            this.collectItem.func_77955_b(itemData);
            nbt.func_74782_a("Item", (NBTBase)itemData);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("Item")) {
            NBTTagCompound itemData = nbt.func_74775_l("Item");
            this.collectItem = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
    }

    @Override
    public boolean isValidQuest() {
        return super.isValidQuest() && this.collectItem != null;
    }

    @Override
    public String getQuestObjective() {
        return StatCollector.func_74837_a((String)"lotr.miniquest.collect", (Object[])new Object[]{this.collectTarget, this.collectItem.func_82833_r()});
    }

    @Override
    public String getObjectiveInSpeech() {
        return this.collectTarget + " " + this.collectItem.func_82833_r();
    }

    @Override
    public String getProgressedObjectiveInSpeech() {
        return this.collectTarget - this.amountGiven + " " + this.collectItem.func_82833_r();
    }

    @Override
    public ItemStack getQuestIcon() {
        return this.collectItem;
    }

    @Override
    protected boolean isQuestItem(ItemStack itemstack) {
        if (IPickpocketable.Helper.isPickpocketed(itemstack)) {
            return false;
        }
        if (LOTRItemMug.isItemFullDrink(this.collectItem)) {
            ItemStack collectDrink = LOTRItemMug.getEquivalentDrink(this.collectItem);
            ItemStack offerDrink = LOTRItemMug.getEquivalentDrink(itemstack);
            return collectDrink.func_77973_b() == offerDrink.func_77973_b();
        }
        return itemstack.func_77973_b() == this.collectItem.func_77973_b() && (this.collectItem.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == this.collectItem.func_77960_j());
    }

    public static class QFCollect<Q extends LOTRMiniQuestCollect>
    extends LOTRMiniQuest.QuestFactoryBase<Q> {
        private ItemStack collectItem;
        private int minTarget;
        private int maxTarget;

        public QFCollect(String name) {
            super(name);
        }

        public QFCollect setCollectItem(ItemStack itemstack, int min, int max) {
            this.collectItem = itemstack;
            if (this.collectItem.func_77984_f()) {
                this.collectItem.func_77964_b(Short.MAX_VALUE);
            }
            this.minTarget = min;
            this.maxTarget = max;
            return this;
        }

        @Override
        public Class getQuestClass() {
            return LOTRMiniQuestCollect.class;
        }

        @Override
        public Q createQuest(LOTREntityNPC npc, Random rand) {
            LOTRMiniQuestCollect quest = (LOTRMiniQuestCollect)super.createQuest(npc, rand);
            quest.collectItem = this.collectItem.func_77946_l();
            quest.collectTarget = MathHelper.func_76136_a((Random)rand, (int)this.minTarget, (int)this.maxTarget);
            return (Q)quest;
        }
    }
}

