/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityGemsbok;
import lotr.common.entity.animal.LOTREntityRhino;
import lotr.common.world.biome.LOTRBiomeGenFarHarad;
import lotr.common.world.biome.LOTRMusicRegion;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.feature.LOTRTreeType;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenSkullPile;
import lotr.common.world.map.LOTRWaypoint;
import lotr.common.world.spawning.LOTRBiomeSpawnList;
import lotr.common.world.spawning.LOTREventSpawner;
import lotr.common.world.spawning.LOTRInvasions;
import lotr.common.world.spawning.LOTRSpawnList;
import lotr.common.world.structure2.LOTRWorldGenStoneRuin;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenHalfTrollForest
extends LOTRBiomeGenFarHarad {
    private WorldGenerator deadMoundGen = new LOTRWorldGenBoulder(LOTRMod.wasteBlock, 0, 1, 2);

    public LOTRBiomeGenHalfTrollForest(int i, boolean major) {
        super(i, major);
        this.field_76762_K.clear();
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityRhino.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityGemsbok.class, 4, 4, 4));
        this.spawnableLOTRAmbientList.clear();
        this.npcSpawnList.clear();
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray = new LOTRBiomeSpawnList.SpawnListContainer[1];
        spawnListContainerArray[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.HALF_TROLLS, 10).setSpawnChance(1000);
        this.npcSpawnList.newFactionList(100, 0.0f).add(spawnListContainerArray);
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray2 = new LOTRBiomeSpawnList.SpawnListContainer[1];
        spawnListContainerArray2[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.HALF_TROLLS, 10);
        this.npcSpawnList.newFactionList(0).add(spawnListContainerArray2);
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray3 = new LOTRBiomeSpawnList.SpawnListContainer[2];
        spawnListContainerArray3[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.MORDOR_ORCS, 10);
        spawnListContainerArray3[1] = LOTRBiomeSpawnList.entry(LOTRSpawnList.BLACK_URUKS, 2).setConquestThreshold(50.0f);
        this.npcSpawnList.newFactionList(0).add(spawnListContainerArray3);
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray4 = new LOTRBiomeSpawnList.SpawnListContainer[1];
        spawnListContainerArray4[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.GULF_WARRIORS, 10);
        this.npcSpawnList.newFactionList(0).add(spawnListContainerArray4);
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray5 = new LOTRBiomeSpawnList.SpawnListContainer[2];
        spawnListContainerArray5[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.MORWAITH_WARRIORS, 10);
        spawnListContainerArray5[1] = LOTRBiomeSpawnList.entry(LOTRSpawnList.MORWAITH, 5);
        this.npcSpawnList.newFactionList(0).add(spawnListContainerArray5);
        LOTRBiomeSpawnList.SpawnListContainer[] spawnListContainerArray6 = new LOTRBiomeSpawnList.SpawnListContainer[1];
        spawnListContainerArray6[0] = LOTRBiomeSpawnList.entry(LOTRSpawnList.TAURETHRIM_WARRIORS, 10);
        this.npcSpawnList.newFactionList(0).add(spawnListContainerArray6);
        this.clearBiomeVariants();
        this.variantChance = 0.7f;
        this.addBiomeVariant(LOTRBiomeVariant.FLOWERS);
        this.addBiomeVariant(LOTRBiomeVariant.FOREST_LIGHT);
        this.addBiomeVariant(LOTRBiomeVariant.HILLS);
        this.addBiomeVariant(LOTRBiomeVariant.HILLS_FOREST);
        this.addBiomeVariant(LOTRBiomeVariant.CLEARING);
        this.addBiomeVariant(LOTRBiomeVariant.WASTELAND);
        this.decorator.treesPerChunk = 3;
        this.decorator.vinesPerChunk = 4;
        this.decorator.logsPerChunk = 2;
        this.decorator.grassPerChunk = 10;
        this.decorator.doubleGrassPerChunk = 10;
        this.decorator.flowersPerChunk = 1;
        this.decorator.doubleFlowersPerChunk = 1;
        this.decorator.clearTrees();
        this.decorator.addTree(LOTRTreeType.ACACIA, 600);
        this.decorator.addTree(LOTRTreeType.OAK_DESERT, 200);
        this.decorator.addTree(LOTRTreeType.BAOBAB, 20);
        this.decorator.addTree(LOTRTreeType.ACACIA_DEAD, 300);
        this.decorator.addTree(LOTRTreeType.OAK_DEAD, 100);
        this.decorator.addRandomStructure(new LOTRWorldGenStoneRuin.TAUREDAIN(1, 2), 500);
        this.biomeColors.setSky(0xC1C1AC);
        this.biomeColors.setClouds(0xE2E2E0);
        this.biomeColors.setFog(8885125);
        this.biomeColors.setFoggy(true);
        this.biomeColors.setWater(10923394);
        this.setBanditChance(LOTREventSpawner.EventChance.NEVER);
        this.invasionSpawns.addInvasion(LOTRInvasions.HALF_TROLL, LOTREventSpawner.EventChance.UNCOMMON);
        this.invasionSpawns.addInvasion(LOTRInvasions.TAUREDAIN, LOTREventSpawner.EventChance.RARE);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterHalfTrollForest;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.PERTOROGWAITH_FOREST;
    }

    @Override
    public LOTRMusicRegion.Sub getBiomeMusic() {
        return LOTRMusicRegion.PERDOROGWAITH.getSubregion("pertorogwaith");
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(40) == 0) {
            for (int l = 0; l < 3; ++l) {
                int i1 = i + random.nextInt(16) + 8;
                int k1 = k + random.nextInt(16) + 8;
                int j1 = world.func_72976_f(i1, k1);
                this.deadMoundGen.func_76484_a(world, random, i1, j1, k1);
                new LOTRWorldGenSkullPile().func_76484_a(world, random, i1, j1, k1);
            }
        }
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.5f;
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.05f;
    }

    @Override
    public boolean canSpawnHostilesInDay() {
        return true;
    }
}

