/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import lotr.common.world.map.LOTRWaypoint;

public enum LOTRMountains {
    BAG_HILL(LOTRWaypoint.HOBBITON.getX(), LOTRWaypoint.HOBBITON.getY() - 4.0, 1.0f, 70),
    AMON_EREB(LOTRWaypoint.AMON_EREB.getX(), LOTRWaypoint.AMON_EREB.getY(), 2.0f, 120),
    BELEGOST(LOTRWaypoint.BELEGOST.getX() - 2.0, LOTRWaypoint.BELEGOST.getY() - 2.0, 5.0f, 300),
    NOGROD(LOTRWaypoint.NOGROD.getX(), LOTRWaypoint.NOGROD.getY() + 2.0, 5.0f, 300),
    MOUNT_RERIR(LOTRWaypoint.MOUNT_RERIR.getX(), LOTRWaypoint.MOUNT_RERIR.getY(), 3.0f, 200),
    MOUNT_DOLMED(LOTRWaypoint.MOUNT_DOLMED.getX(), LOTRWaypoint.MOUNT_DOLMED.getY(), 4.0f, 300),
    BREE(LOTRWaypoint.BREE.getX() + 5.0, LOTRWaypoint.BREE.getY(), 2.0f, 500),
    WEATHERTOP(LOTRWaypoint.WEATHERTOP.getX(), LOTRWaypoint.WEATHERTOP.getY() - 1.0, 2.5f, 65),
    CARN_DUM(LOTRWaypoint.CARN_DUM.getX(), LOTRWaypoint.CARN_DUM.getY() - 1.0, 2.5f, 150),
    MOUNT_GRAM(LOTRWaypoint.MOUNT_GRAM.getX(), LOTRWaypoint.MOUNT_GRAM.getY(), 2.5f, 250),
    MOUNT_GUNDABAD(LOTRWaypoint.MOUNT_GUNDABAD.getX(), LOTRWaypoint.MOUNT_GUNDABAD.getY(), 2.5f, 250),
    MOUNT_CELEBDIL(LOTRWaypoint.MOUNT_CELEBDIL.getX(), LOTRWaypoint.MOUNT_CELEBDIL.getY(), 2.5f, 250),
    MOUNT_CARADHRAS(LOTRWaypoint.MOUNT_CARADHRAS.getX(), LOTRWaypoint.MOUNT_CARADHRAS.getY(), 3.0f, 250),
    MOUNT_FANUIDHOL(LOTRWaypoint.MOUNT_FANUIDHOL.getX(), LOTRWaypoint.MOUNT_FANUIDHOL.getY(), 2.5f, 250),
    MOUNT_METHEDRAS(LOTRWaypoint.MOUNT_METHEDRAS.getX(), LOTRWaypoint.MOUNT_METHEDRAS.getY(), 2.5f, 250),
    EAGLES_EYRIE(LOTRWaypoint.EAGLES_EYRIE.getX(), LOTRWaypoint.EAGLES_EYRIE.getY(), 3.5f, 100),
    EREBOR(LOTRWaypoint.EREBOR.getX() - 1.0, LOTRWaypoint.EREBOR.getY() - 4.0, 5.0f, 300),
    WEST_PEAK(LOTRWaypoint.WEST_PEAK.getX() - 1.0, LOTRWaypoint.WEST_PEAK.getY() - 1.0, 4.0f, 250),
    EAST_PEAK(LOTRWaypoint.EAST_PEAK.getX() + 1.0, LOTRWaypoint.EAST_PEAK.getY() - 1.0, 4.0f, 250),
    CERIN_AMROTH(LOTRWaypoint.CERIN_AMROTH.getX(), LOTRWaypoint.CERIN_AMROTH.getY(), 1.0f, 80),
    CARAS_GALADHON(LOTRWaypoint.CARAS_GALADHON.getX(), LOTRWaypoint.CARAS_GALADHON.getY(), 1.5f, 150),
    DOL_GULDUR(LOTRWaypoint.DOL_GULDUR.getX(), LOTRWaypoint.DOL_GULDUR.getY(), 1.5f, 100),
    TREEBEARD_HILL(LOTRWaypoint.TREEBEARD_HILL.getX(), LOTRWaypoint.TREEBEARD_HILL.getY(), 1.0f, 80),
    AMON_HEN(LOTRWaypoint.AMON_HEN.getX(), LOTRWaypoint.AMON_HEN.getY(), 1.5f, 100),
    AMON_LHAW(LOTRWaypoint.AMON_LHAW.getX(), LOTRWaypoint.AMON_LHAW.getY(), 1.5f, 100),
    EDORAS(LOTRWaypoint.EDORAS.getX() + 1.0, LOTRWaypoint.EDORAS.getY() - 1.0, 1.5f, 140),
    ALDBURG(LOTRWaypoint.ALDBURG.getX() + 1.0, LOTRWaypoint.ALDBURG.getY() - 1.0, 1.5f, 120),
    HALIFIRIEN(LOTRWaypoint.HALIFIRIEN.getX(), LOTRWaypoint.HALIFIRIEN.getY() + 1.0, 2.5f, 170),
    CALENHAD(LOTRWaypoint.CALENHAD.getX(), LOTRWaypoint.CALENHAD.getY() + 1.0, 2.0f, 100),
    MINRIMMON(LOTRWaypoint.MINRIMMON.getX(), LOTRWaypoint.MINRIMMON.getY() + 1.0, 2.0f, 120),
    ERELAS(LOTRWaypoint.ERELAS.getX(), LOTRWaypoint.ERELAS.getY() + 1.0, 1.5f, 100),
    NARDOL(LOTRWaypoint.NARDOL.getX(), LOTRWaypoint.NARDOL.getY() + 1.0, 1.5f, 150),
    EILENACH(LOTRWaypoint.EILENACH.getX(), LOTRWaypoint.EILENACH.getY() + 1.0, 2.0f, 130),
    AMON_DIN(LOTRWaypoint.AMON_DIN.getX() + 1.0, LOTRWaypoint.AMON_DIN.getY(), 2.0f, 120),
    MINDOLLUIN(LOTRWaypoint.MINAS_TIRITH.getX() - 4.0, LOTRWaypoint.MINAS_TIRITH.getY(), 1.0f, 200),
    TIRITH_HILL(LOTRWaypoint.MINAS_TIRITH.getX() - 2.5, LOTRWaypoint.MINAS_TIRITH.getY(), 3.5f, 170),
    DOL_AMROTH(LOTRWaypoint.DOL_AMROTH.getX() - 2.0, LOTRWaypoint.DOL_AMROTH.getY(), 2.2f, 250),
    ERECH(LOTRWaypoint.ERECH.getX(), LOTRWaypoint.ERECH.getY(), 2.5f, 150),
    MOUNT_DOOM(LOTRWaypoint.MOUNT_DOOM.getX() + 1.0, LOTRWaypoint.MOUNT_DOOM.getY() + 2.0, 5.0f, 250, 25);

    private int xCoord;
    private int zCoord;
    private float height;
    private int range;
    private int lavaRange;

    private LOTRMountains(double x, double z, float h, int r) {
        this(x, z, h, r, 0);
    }

    private LOTRMountains(double x, double z, float h, int r, int l) {
        this.xCoord = LOTRWaypoint.mapToWorldX(x);
        this.zCoord = LOTRWaypoint.mapToWorldZ(z);
        this.height = h;
        this.range = r;
        this.lavaRange = l;
    }

    private float getLavaCraterHeight() {
        return (1.0f - (float)this.lavaRange / (float)this.range) * this.height * 0.4f;
    }

    public float getHeightBoost(int x, int z) {
        double dx = x - this.xCoord;
        double dz = z - this.zCoord;
        double distSq = dx * dx + dz * dz;
        double rangeSq = this.range * this.range;
        if (distSq < rangeSq) {
            double lavaRangeSq;
            if (this.lavaRange > 0 && distSq < (lavaRangeSq = (double)(this.lavaRange * this.lavaRange))) {
                return this.getLavaCraterHeight();
            }
            double dist = Math.sqrt(distSq);
            float f = (float)(dist / (double)this.range);
            return (1.0f - f) * this.height;
        }
        return 0.0f;
    }

    public static float getTotalHeightBoost(int x, int z) {
        float f = 0.0f;
        for (LOTRMountains m : LOTRMountains.values()) {
            f += m.getHeightBoost(x, z);
        }
        return f;
    }

    public static boolean mountainAt(int x, int z) {
        return LOTRMountains.getTotalHeightBoost(x, z) > 0.005f;
    }

    public static boolean mountainNear(int x, int z, int range) {
        for (LOTRMountains m : LOTRMountains.values()) {
            double dx = x - m.xCoord;
            double dz = z - m.zCoord;
            double distSq = dx * dx + dz * dz;
            double mtnRange = range + m.range;
            double rangeSq = mtnRange * mtnRange;
            if (!(distSq <= rangeSq)) continue;
            return true;
        }
        return false;
    }

    public static int getLavaHeight(int x, int z) {
        for (LOTRMountains m : LOTRMountains.values()) {
            double lavaRangeSq;
            double dz;
            double dx;
            double distSq;
            if (m.lavaRange <= 0 || !((distSq = (dx = (double)(x - m.xCoord)) * dx + (dz = (double)(z - m.zCoord)) * dz) < (lavaRangeSq = (double)((m.lavaRange + 6) * (m.lavaRange + 6))))) continue;
            return Math.round(m.getLavaCraterHeight() * 110.0f);
        }
        return 0;
    }
}

