/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRTravellingTraderSpawner {
    private static Random rand = new Random();
    private Class theEntityClass;
    public String entityClassName;
    private int timeUntilTrader;

    public LOTRTravellingTraderSpawner(Class<? extends LOTREntityNPC> entityClass) {
        this.theEntityClass = entityClass;
        this.entityClassName = LOTREntities.getStringFromClass(this.theEntityClass);
    }

    private static int getRandomTraderTime() {
        float minHours = 0.8f;
        float maxHours = 10.0f;
        return MathHelper.func_76136_a((Random)rand, (int)((int)(minHours * 3600.0f) * 20), (int)((int)(maxHours * 3600.0f) * 20));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TraderTime", this.timeUntilTrader);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.timeUntilTrader = nbt.func_74764_b("TraderTime") ? nbt.func_74762_e("TraderTime") : LOTRTravellingTraderSpawner.getRandomTraderTime();
    }

    public void performSpawning(World world) {
        if (this.timeUntilTrader > 0) {
            --this.timeUntilTrader;
        } else if (world.field_73012_v.nextInt(1000) == 0) {
            boolean spawned = false;
            LOTREntityNPC entityTrader = (LOTREntityNPC)EntityList.func_75620_a((String)LOTREntities.getStringFromClass(this.theEntityClass), (World)world);
            LOTRTravellingTrader trader = (LOTRTravellingTrader)((Object)entityTrader);
            block0: for (int players = 0; players < world.field_73010_i.size(); ++players) {
                EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(players);
                if (!(LOTRLevelData.getData(entityplayer).getAlignment(entityTrader.getFaction()) >= 0.0f)) continue;
                for (int attempts = 0; attempts < 16; ++attempts) {
                    int k;
                    float angle = world.field_73012_v.nextFloat() * 360.0f;
                    int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + MathHelper.func_76128_c((double)(MathHelper.func_76126_a((float)angle) * (float)(48 + world.field_73012_v.nextInt(33))));
                    BiomeGenBase biome = world.func_72807_a(i, k = MathHelper.func_76128_c((double)entityplayer.field_70161_v) + MathHelper.func_76128_c((double)(MathHelper.func_76134_b((float)angle) * (float)(48 + world.field_73012_v.nextInt(33)))));
                    if (!(biome instanceof LOTRBiome) || !((LOTRBiome)biome).canSpawnTravellingTrader(this.theEntityClass)) continue;
                    int j = world.func_72976_f(i, k);
                    Block block = world.func_147439_a(i, j - 1, k);
                    if (j <= 62 || block != biome.field_76752_A && block != biome.field_76753_B || world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j + 1, k).func_149721_r()) continue;
                    entityTrader.func_70012_b((double)i + 0.5, j, (double)k + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    entityTrader.liftSpawnRestrictions = true;
                    Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityTrader, (World)world, (float)((float)entityTrader.field_70165_t), (float)((float)entityTrader.field_70163_u), (float)((float)entityTrader.field_70161_v));
                    if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entityTrader.func_70601_bi())) continue;
                    entityTrader.liftSpawnRestrictions = false;
                    entityTrader.spawnRidingHorse = false;
                    world.func_72838_d((Entity)entityTrader);
                    entityTrader.func_110161_a(null);
                    entityTrader.isNPCPersistent = true;
                    entityTrader.setShouldTraderRespawn(false);
                    trader.startTraderVisiting(entityplayer);
                    spawned = true;
                    this.timeUntilTrader = LOTRTravellingTraderSpawner.getRandomTraderTime();
                    LOTRLevelData.markDirty();
                    break block0;
                }
            }
            if (!spawned) {
                this.timeUntilTrader = 200 + world.field_73012_v.nextInt(400);
            }
        }
    }
}

