/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import com.google.common.math.IntMath;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityDolAmrothCaptain;
import lotr.common.item.LOTRItemBanner;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LOTRWorldGenDolAmrothStables
extends LOTRWorldGenStructureBase2 {
    private Block brickBlock = LOTRMod.brick3;
    private int brickMeta = 9;
    private Block slabBlock = LOTRMod.slabSingle6;
    private int slabMeta = 7;
    private Block stairBlock = LOTRMod.stairsDolAmrothBrick;
    private Block wallBlock = LOTRMod.wall2;
    private int wallMeta = 14;
    private Block rockSlabBlock = LOTRMod.slabSingle;
    private Block doubleRockSlabBlock = LOTRMod.slabDouble;
    private int rockSlabMeta = 2;
    private Block pillarBlock = LOTRMod.pillar;
    private int pillarMeta = 6;
    private Block logBlock = Blocks.field_150364_r;
    private int logMeta = 0;
    private Block plankBlock = Blocks.field_150344_f;
    private int plankMeta = 0;
    private Block plankSlabBlock = Blocks.field_150376_bx;
    private int plankSlabMeta = 0;
    private Block fenceBlock = Blocks.field_150422_aJ;
    private int fenceMeta = 0;
    private Block gateBlock;
    private Block woodBeamBlock = LOTRMod.woodBeamV1;
    private int woodBeamMeta = 0;
    private Block roofBlock;
    private int roofMeta = 11;
    private Block roofSlabBlock;
    private int roofSlabMeta = 3;
    private Block roofStairBlock;
    private Block leafBlock;
    private int leafMeta = 6;

    public LOTRWorldGenDolAmrothStables(boolean flag) {
        super(flag);
        this.gateBlock = Blocks.field_150396_be;
        this.roofBlock = LOTRMod.clayTileDyed;
        this.roofSlabBlock = LOTRMod.slabClayTileDyedSingle2;
        this.roofStairBlock = LOTRMod.stairsClayTileDyedBlue;
        this.leafBlock = LOTRMod.leaves4;
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int i1;
        int i12;
        int n;
        int i13;
        int k1;
        int k12;
        int k13;
        int k142;
        int i14;
        int k15;
        int j1;
        int i15;
        int j12;
        int i22;
        int i16;
        int i172;
        int j13;
        int k162;
        int i18;
        this.setOriginAndRotation(world, i, j, k, rotation, 2);
        if (this.restrictions) {
            int minHeight = 0;
            int maxHeight = 0;
            for (i18 = -9; i18 <= 9; ++i18) {
                for (k162 = -1; k162 <= 19; ++k162) {
                    j13 = this.getTopBlock(world, i18, k162);
                    Block block = this.getBlock(world, i18, j13 - 1, k162);
                    if (block != Blocks.field_150349_c) {
                        return false;
                    }
                    if (j13 < minHeight) {
                        minHeight = j13;
                    }
                    if (j13 > maxHeight) {
                        maxHeight = j13;
                    }
                    if (maxHeight - minHeight <= 7) continue;
                    return false;
                }
            }
        }
        for (int segment = 0; segment <= 2; ++segment) {
            int k17;
            int i19;
            int kz = segment * 4;
            for (i18 = -8; i18 <= 8; ++i18) {
                for (k162 = kz; k162 <= kz + 3; ++k162) {
                    for (j13 = 0; !(j13 != 0 && this.isOpaque(world, i18, j13, k162) || this.getY(j13) < 0); --j13) {
                        this.setBlockAndMetadata(world, i18, j13, k162, this.brickBlock, this.brickMeta);
                        this.setGrassToDirt(world, i18, j13 - 1, k162);
                    }
                    for (j13 = 1; j13 <= 7; ++j13) {
                        this.setAir(world, i18, j13, k162);
                    }
                }
            }
            this.placeWoodPillar(world, -8, kz);
            this.placeWoodPillar(world, 8, kz);
            int[] i110 = new int[]{-3, 3};
            k162 = i110.length;
            for (j13 = 0; j13 < k162; ++j13) {
                int i111 = i110[j13];
                if (segment == 0) {
                    this.placeWoodPillar(world, i111, kz);
                    continue;
                }
                for (int j14 = 1; j14 <= 3; ++j14) {
                    this.setBlockAndMetadata(world, i111, j14, kz, this.logBlock, this.logMeta);
                }
            }
            for (i19 = -7; i19 <= -4; ++i19) {
                this.setBlockAndMetadata(world, i19, 1, kz, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, i19, 2, kz, this.wallBlock, this.wallMeta);
                this.setBlockAndMetadata(world, i19, 4, kz, this.brickBlock, this.brickMeta);
            }
            for (i19 = 4; i19 <= 7; ++i19) {
                this.setBlockAndMetadata(world, i19, 1, kz, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, i19, 2, kz, this.wallBlock, this.wallMeta);
                this.setBlockAndMetadata(world, i19, 4, kz, this.brickBlock, this.brickMeta);
            }
            this.setBlockAndMetadata(world, -4, 2, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, -4, 3, kz, this.wallBlock, this.wallMeta);
            this.setBlockAndMetadata(world, 4, 2, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, 4, 3, kz, this.wallBlock, this.wallMeta);
            for (k17 = kz + 1; k17 <= kz + 3; ++k17) {
                this.setBlockAndMetadata(world, -8, 1, k17, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, -8, 2, k17, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, -8, 3, k17, this.rockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, -8, 4, k17, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, 8, 1, k17, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, 8, 2, k17, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, 8, 3, k17, this.rockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, 8, 4, k17, this.brickBlock, this.brickMeta);
            }
            for (int j15 = 1; j15 <= 3; ++j15) {
                this.setBlockAndMetadata(world, -2, j15, kz, this.fenceBlock, this.brickMeta);
                this.setBlockAndMetadata(world, 2, j15, kz, this.fenceBlock, this.brickMeta);
            }
            for (k17 = kz + 1; k17 <= kz + 3; ++k17) {
                for (i172 = -7; i172 <= -3; ++i172) {
                    this.setBlockAndMetadata(world, i172, 0, k17, this.doubleRockSlabBlock, this.rockSlabMeta);
                    if (random.nextInt(3) == 0) continue;
                    this.setBlockAndMetadata(world, i172, 1, k17, LOTRMod.thatchFloor, 0);
                }
                for (i172 = 3; i172 <= 7; ++i172) {
                    this.setBlockAndMetadata(world, i172, 0, k17, this.doubleRockSlabBlock, this.rockSlabMeta);
                    if (random.nextInt(3) == 0) continue;
                    this.setBlockAndMetadata(world, i172, 1, k17, LOTRMod.thatchFloor, 0);
                }
            }
            for (int i112 : new int[]{-7, 7}) {
                this.setBlockAndMetadata(world, i112, 1, kz + 1, Blocks.field_150407_cf, 0);
                this.setBlockAndMetadata(world, i112, 1, kz + 2, Blocks.field_150407_cf, 0);
                this.setBlockAndMetadata(world, i112, 1, kz + 3, this.fenceBlock, this.fenceMeta);
            }
            for (int i113 : new int[]{-3, 3}) {
                this.setBlockAndMetadata(world, i113, 1, kz + 1, this.gateBlock, 1);
                this.setBlockAndMetadata(world, i113, 1, kz + 2, this.gateBlock, 1);
                this.setBlockAndMetadata(world, i113, 1, kz + 3, this.fenceBlock, this.fenceMeta);
                this.setBlockAndMetadata(world, i113, 2, kz + 3, Blocks.field_150478_aa, 5);
            }
            int[] k18 = new int[]{-1, 1};
            i172 = k18.length;
            for (j13 = 0; j13 < i172; ++j13) {
                int f = k18[j13];
                LOTREntityHorse horse = new LOTREntityHorse(world);
                this.spawnNPCAndSetHome((EntityCreature)horse, world, 5 * f, 1, kz + 2, 0);
                horse.func_110214_p(0);
                horse.saddleMountForWorldGen();
                horse.func_110177_bN();
            }
            for (int i114 = -7; i114 <= 7; ++i114) {
                for (k162 = kz + 1; k162 <= kz + 3; ++k162) {
                    this.setBlockAndMetadata(world, i114, 4, k162, this.rockSlabBlock, this.rockSlabMeta | 8);
                }
                if (segment <= 0) continue;
                if (Math.abs(i114) <= 1) {
                    this.setBlockAndMetadata(world, i114, 4, kz, this.rockSlabBlock, this.rockSlabMeta | 8);
                    continue;
                }
                this.setBlockAndMetadata(world, i114, 4, kz, this.brickBlock, this.brickMeta);
            }
            for (int i115 : new int[]{-3, 3}) {
                this.setBlockAndMetadata(world, i115, 4, kz + 1, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i115, 4, kz + 3, this.doubleRockSlabBlock, this.rockSlabMeta);
            }
            for (int i116 = -8; i116 <= 8; ++i116) {
                this.setBlockAndMetadata(world, i116, 5, kz, this.brickBlock, this.brickMeta);
            }
            for (int i117 : new int[]{-7, 4}) {
                this.setBlockAndMetadata(world, i117, 6, kz, this.stairBlock, 1);
                this.setBlockAndMetadata(world, i117 + 1, 6, kz, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, i117 + 1, 7, kz, this.stairBlock, 1);
                this.setBlockAndMetadata(world, i117 + 2, 6, kz, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, i117 + 2, 7, kz, this.stairBlock, 0);
                this.setBlockAndMetadata(world, i117 + 3, 6, kz, this.stairBlock, 0);
                for (int k19 = kz + 1; k19 <= kz + 3; ++k19) {
                    this.setBlockAndMetadata(world, i117, 5, k19, this.roofStairBlock, 1);
                    this.setBlockAndMetadata(world, i117 + 1, 5, k19, this.brickBlock, this.brickMeta);
                    this.setBlockAndMetadata(world, i117 + 1, 6, k19, this.roofStairBlock, 1);
                    this.setBlockAndMetadata(world, i117 + 2, 5, k19, this.brickBlock, this.brickMeta);
                    this.setBlockAndMetadata(world, i117 + 2, 6, k19, this.roofStairBlock, 0);
                    this.setBlockAndMetadata(world, i117 + 3, 5, k19, this.roofStairBlock, 0);
                }
            }
            this.setBlockAndMetadata(world, -2, 6, kz, this.stairBlock, 1);
            this.setBlockAndMetadata(world, -1, 6, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, -1, 7, kz, this.stairBlock, 1);
            this.setBlockAndMetadata(world, 0, 6, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, 0, 7, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, 0, 8, kz, this.slabBlock, this.slabMeta);
            this.setBlockAndMetadata(world, 1, 6, kz, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, 1, 7, kz, this.stairBlock, 0);
            this.setBlockAndMetadata(world, 2, 6, kz, this.stairBlock, 0);
            for (int k110 = kz + 1; k110 <= kz + 3; ++k110) {
                this.setBlockAndMetadata(world, -2, 5, k110, this.roofStairBlock, 1);
                this.setBlockAndMetadata(world, -1, 5, k110, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, -1, 6, k110, this.roofStairBlock, 1);
                this.setBlockAndMetadata(world, 0, 5, k110, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, 0, 6, k110, this.roofBlock, this.roofMeta);
                this.setBlockAndMetadata(world, 0, 7, k110, this.roofSlabBlock, this.roofSlabMeta);
                this.setBlockAndMetadata(world, 1, 5, k110, this.brickBlock, this.brickMeta);
                this.setBlockAndMetadata(world, 1, 6, k110, this.roofStairBlock, 0);
                this.setBlockAndMetadata(world, 2, 5, k110, this.roofStairBlock, 0);
            }
            int[] k110 = new int[]{-8, -3, 3, 8};
            k162 = k110.length;
            for (j13 = 0; j13 < k162; ++j13) {
                int i117;
                i117 = k110[j13];
                for (int k111 = kz + 1; k111 <= kz + 3; ++k111) {
                    this.setBlockAndMetadata(world, i117, 5, k111, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (i16 = -9; i16 <= 9; ++i16) {
            i22 = Math.abs(i16);
            if (i22 <= 2) {
                this.setBlockAndMetadata(world, i16, 0, -1, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i16, 0, -2, this.doubleRockSlabBlock, this.rockSlabMeta);
                continue;
            }
            this.placeGrassFoundation(world, i16, -1);
            if (i22 == 3 || i22 == 8) {
                for (j12 = 1; j12 <= 4; ++j12) {
                    this.setBlockAndMetadata(world, i16, j12, -1, this.wallBlock, this.wallMeta);
                }
                continue;
            }
            this.setBlockAndMetadata(world, i16, 1, -1, this.leafBlock, this.leafMeta);
        }
        for (int k112 = 0; k112 <= 11; ++k112) {
            int[] i22 = new int[]{-9, 9};
            j12 = i22.length;
            for (k162 = 0; k162 < j12; ++k162) {
                i15 = i22[k162];
                this.placeGrassFoundation(world, i15, k112);
                if (k112 % 4 == 0) {
                    for (int j16 = 1; j16 <= 4; ++j16) {
                        this.setBlockAndMetadata(world, i15, j16, k112, this.wallBlock, this.wallMeta);
                    }
                    continue;
                }
                this.setBlockAndMetadata(world, i15, 1, k112, this.leafBlock, this.leafMeta);
            }
            if (k112 % 4 != 0) continue;
            this.setBlockAndMetadata(world, -9, 5, k112, this.stairBlock, 1);
            this.setBlockAndMetadata(world, 9, 5, k112, this.stairBlock, 0);
        }
        this.setBlockAndMetadata(world, -1, 5, 0, this.stairBlock, 4);
        this.setBlockAndMetadata(world, 0, 5, 0, this.stairBlock, 6);
        this.setBlockAndMetadata(world, 1, 5, 0, this.stairBlock, 5);
        this.setBlockAndMetadata(world, 0, 6, 0, LOTRMod.brick, 5);
        for (i16 = -1; i16 <= 1; ++i16) {
            this.setBlockAndMetadata(world, i16, 0, 0, this.doubleRockSlabBlock, this.rockSlabMeta);
            for (j1 = 1; j1 <= 4; ++j1) {
                this.setBlockAndMetadata(world, i16, j1, 0, LOTRMod.gateDolAmroth, 2);
            }
        }
        for (int i172 : new int[]{-2, 2}) {
            for (j13 = 1; j13 <= 4; ++j13) {
                this.setBlockAndMetadata(world, i172, j13, 0, this.brickBlock, this.brickMeta);
            }
            this.placeWallBanner(world, i172, 4, 0, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
        }
        this.setBlockAndMetadata(world, -8, 5, -1, this.stairBlock, 1);
        this.setBlockAndMetadata(world, 8, 5, -1, this.stairBlock, 0);
        int[] i118 = new int[]{-7, 4};
        j1 = i118.length;
        for (j12 = 0; j12 < j1; ++j12) {
            i172 = i118[j12];
            this.setBlockAndMetadata(world, i172 + 0, 5, -1, this.stairBlock, 4);
            this.setBlockAndMetadata(world, i172 + 0, 6, -1, this.stairBlock, 1);
            this.setBlockAndMetadata(world, i172 + 1, 6, -1, this.stairBlock, 4);
            this.setBlockAndMetadata(world, i172 + 1, 7, -1, this.stairBlock, 1);
            this.setBlockAndMetadata(world, i172 + 2, 6, -1, this.stairBlock, 5);
            this.setBlockAndMetadata(world, i172 + 2, 7, -1, this.stairBlock, 0);
            this.setBlockAndMetadata(world, i172 + 3, 5, -1, this.stairBlock, 5);
            this.setBlockAndMetadata(world, i172 + 3, 6, -1, this.stairBlock, 0);
            this.setBlockAndMetadata(world, i172 + 1, 5, 0, this.stairBlock, 4);
            this.setBlockAndMetadata(world, i172 + 2, 5, 0, this.stairBlock, 5);
        }
        this.setBlockAndMetadata(world, -3, 5, -1, this.brickBlock, this.brickMeta);
        this.setBlockAndMetadata(world, -2, 5, -1, this.stairBlock, 4);
        this.setBlockAndMetadata(world, -2, 6, -1, this.stairBlock, 1);
        this.setBlockAndMetadata(world, -1, 6, -1, this.stairBlock, 4);
        this.setBlockAndMetadata(world, -1, 7, -1, this.stairBlock, 1);
        this.setBlockAndMetadata(world, 0, 7, -1, this.brickBlock, this.brickMeta);
        this.setBlockAndMetadata(world, 0, 8, -1, this.slabBlock, this.slabMeta);
        this.setBlockAndMetadata(world, 1, 6, -1, this.stairBlock, 5);
        this.setBlockAndMetadata(world, 1, 7, -1, this.stairBlock, 0);
        this.setBlockAndMetadata(world, 2, 5, -1, this.stairBlock, 5);
        this.setBlockAndMetadata(world, 2, 6, -1, this.stairBlock, 0);
        this.setBlockAndMetadata(world, 3, 5, -1, this.brickBlock, this.brickMeta);
        for (k15 = 1; k15 <= 3; ++k15) {
            for (i14 = -1; i14 <= 1; ++i14) {
                if (k15 == 3 && Math.abs(i14) >= 1) continue;
                this.setAir(world, i14, 4, k15);
            }
        }
        for (k15 = 1; k15 <= 11; ++k15) {
            this.setBlockAndMetadata(world, 0, 0, k15, this.doubleRockSlabBlock, this.rockSlabMeta);
        }
        for (int i119 = -9; i119 <= 9; ++i119) {
            for (k142 = 12; k142 <= 18; ++k142) {
                for (j12 = 0; !(j12 != 0 && this.isOpaque(world, i119, j12, k142) || this.getY(j12) < 0); --j12) {
                    this.setBlockAndMetadata(world, i119, j12, k142, this.brickBlock, this.brickMeta);
                    this.setGrassToDirt(world, i119, j12 - 1, k142);
                }
                for (j12 = 1; j12 <= 9; ++j12) {
                    this.setAir(world, i119, j12, k142);
                }
            }
        }
        int[] i119 = new int[]{12, 18};
        k142 = i119.length;
        for (j12 = 0; j12 < k142; ++j12) {
            int j17;
            k162 = i119[j12];
            for (i15 = -9; i15 <= 9; ++i15) {
                this.setBlockAndMetadata(world, i15, 1, k162, this.doubleRockSlabBlock, this.rockSlabMeta);
                for (j17 = 2; j17 <= 6; ++j17) {
                    this.setBlockAndMetadata(world, i15, j17, k162, this.brickBlock, this.brickMeta);
                }
            }
            int[] i120 = new int[]{-9, 9};
            j17 = i120.length;
            for (int k111 = 0; k111 < j17; ++k111) {
                int i121 = i120[k111];
                this.placeWoodPillar(world, i121, k162);
                this.setBlockAndMetadata(world, i121, 4, k162, this.doubleRockSlabBlock, this.rockSlabMeta);
                for (int j18 = 5; j18 <= 7; ++j18) {
                    this.setBlockAndMetadata(world, i121, j18, k162, this.pillarBlock, this.pillarMeta);
                }
                this.setBlockAndMetadata(world, i121, 8, k162, this.rockSlabBlock, this.rockSlabMeta);
            }
            for (i15 = -8; i15 <= 8; ++i15) {
                int j19;
                int i23 = Math.abs(i15);
                if (i23 >= 5) {
                    if (i23 % 2 == 0) {
                        this.setBlockAndMetadata(world, i15, 7, k162, this.slabBlock, this.slabMeta);
                    } else {
                        this.setBlockAndMetadata(world, i15, 7, k162, this.brickBlock, this.brickMeta);
                    }
                }
                if (i23 == 4) {
                    for (j19 = 5; j19 <= 10; ++j19) {
                        this.setBlockAndMetadata(world, i15, j19, k162, this.pillarBlock, this.pillarMeta);
                    }
                    this.setBlockAndMetadata(world, i15, 11, k162, this.slabBlock, this.slabMeta);
                }
                if (i23 > 3) continue;
                for (j19 = 7; j19 <= 8; ++j19) {
                    this.setBlockAndMetadata(world, i15, j19, k162, this.brickBlock, this.brickMeta);
                }
                this.setBlockAndMetadata(world, i15, 9, k162, this.doubleRockSlabBlock, this.rockSlabMeta);
                if (i23 >= 1) {
                    this.setBlockAndMetadata(world, i15, 10, k162, this.brickBlock, this.brickMeta);
                    if (i23 % 2 == 0) {
                        this.setBlockAndMetadata(world, i15, 11, k162, this.slabBlock, this.slabMeta);
                    }
                }
                if (i23 != 0) continue;
                this.setBlockAndMetadata(world, i15, 10, k162, this.slabBlock, this.slabMeta);
            }
        }
        for (k13 = 13; k13 <= 17; ++k13) {
            int[] k142 = new int[]{-4, 4};
            j12 = k142.length;
            for (k162 = 0; k162 < j12; ++k162) {
                i15 = k142[k162];
                this.setBlockAndMetadata(world, i15, 9, k13, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i15, 10, k13, this.brickBlock, this.brickMeta);
                if (k13 % 2 != 0) continue;
                this.setBlockAndMetadata(world, i15, 11, k13, this.slabBlock, this.slabMeta);
            }
        }
        for (int i122 = -3; i122 <= 3; ++i122) {
            i22 = Math.abs(i122);
            for (k12 = 13; k12 <= 17; ++k12) {
                this.setBlockAndMetadata(world, i122, 9, k12, this.doubleRockSlabBlock, this.rockSlabMeta);
            }
            for (k12 = 14; k12 <= 16; ++k12) {
                this.setBlockAndMetadata(world, i122, 10, k12, this.doubleRockSlabBlock, this.rockSlabMeta);
                if (i22 <= 2) {
                    this.setBlockAndMetadata(world, i122, 11, k12, this.brickBlock, this.brickMeta);
                }
                if (i22 > 1) continue;
                this.setBlockAndMetadata(world, i122, 12, k12, this.brickBlock, this.brickMeta);
            }
        }
        for (k13 = 13; k13 <= 17; ++k13) {
            this.setBlockAndMetadata(world, -3, 11, k13, this.roofStairBlock, 1);
            this.setBlockAndMetadata(world, -2, 12, k13, this.roofStairBlock, 1);
            this.setBlockAndMetadata(world, -1, 13, k13, this.roofStairBlock, 1);
            this.setBlockAndMetadata(world, 0, 13, k13, this.roofBlock, this.roofMeta);
            this.setBlockAndMetadata(world, 0, 14, k13, this.roofSlabBlock, this.roofSlabMeta);
            this.setBlockAndMetadata(world, 1, 13, k13, this.roofStairBlock, 0);
            this.setBlockAndMetadata(world, 2, 12, k13, this.roofStairBlock, 0);
            this.setBlockAndMetadata(world, 3, 11, k13, this.roofStairBlock, 0);
        }
        for (int k162 : new int[]{13, 17}) {
            this.setBlockAndMetadata(world, -3, 10, k162, this.roofStairBlock, 4);
            this.setBlockAndMetadata(world, -2, 11, k162, this.roofStairBlock, 4);
            this.setBlockAndMetadata(world, -1, 12, k162, this.roofStairBlock, 4);
            this.setBlockAndMetadata(world, 1, 12, k162, this.roofStairBlock, 5);
            this.setBlockAndMetadata(world, 2, 11, k162, this.roofStairBlock, 5);
            this.setBlockAndMetadata(world, 3, 10, k162, this.roofStairBlock, 5);
        }
        this.placeWallBanner(world, 0, 12, 14, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
        this.placeWallBanner(world, 0, 12, 16, LOTRItemBanner.BannerType.DOL_AMROTH, 0);
        this.placeWallBanner(world, -4, 9, 12, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
        this.setBlockAndMetadata(world, -3, 9, 12, this.doubleRockSlabBlock, this.rockSlabMeta);
        this.setBlockAndMetadata(world, -2, 9, 12, this.stairBlock, 6);
        this.setBlockAndMetadata(world, -2, 8, 12, LOTRMod.stainedGlassPane, 11);
        this.setBlockAndMetadata(world, -1, 9, 12, this.doubleRockSlabBlock, this.rockSlabMeta);
        this.setBlockAndMetadata(world, 0, 9, 12, this.stairBlock, 6);
        this.setBlockAndMetadata(world, 0, 8, 12, LOTRMod.stainedGlassPane, 0);
        this.setBlockAndMetadata(world, 1, 9, 12, this.doubleRockSlabBlock, this.rockSlabMeta);
        this.setBlockAndMetadata(world, 2, 9, 12, this.stairBlock, 6);
        this.setBlockAndMetadata(world, 2, 8, 12, LOTRMod.stainedGlassPane, 11);
        this.setBlockAndMetadata(world, 3, 9, 12, this.doubleRockSlabBlock, this.rockSlabMeta);
        this.placeWallBanner(world, 4, 9, 12, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
        this.placeWoodPillar(world, -3, 12);
        this.placeWoodPillar(world, 3, 12);
        this.placeWoodPillar(world, -6, 18);
        this.placeWoodPillar(world, -2, 18);
        this.placeWoodPillar(world, 2, 18);
        this.placeWoodPillar(world, 6, 18);
        for (k1 = 13; k1 <= 17; ++k1) {
            int[] i24 = new int[]{-9, 9};
            k12 = i24.length;
            for (k162 = 0; k162 < k12; ++k162) {
                int j110;
                i15 = i24[k162];
                this.setBlockAndMetadata(world, i15, 1, k1, this.doubleRockSlabBlock, this.rockSlabMeta);
                for (j110 = 2; j110 <= 3; ++j110) {
                    this.setBlockAndMetadata(world, i15, j110, k1, this.brickBlock, this.brickMeta);
                }
                this.setBlockAndMetadata(world, i15, 4, k1, this.doubleRockSlabBlock, this.rockSlabMeta);
                for (j110 = 5; j110 <= 6; ++j110) {
                    this.setBlockAndMetadata(world, i15, j110, k1, this.brickBlock, this.brickMeta);
                }
                if (k1 % 2 == 1) {
                    this.setBlockAndMetadata(world, i15, 7, k1, this.slabBlock, this.slabMeta);
                    continue;
                }
                this.setBlockAndMetadata(world, i15, 7, k1, this.brickBlock, this.brickMeta);
            }
        }
        for (k1 = 13; k1 <= 17; ++k1) {
            for (int step = 0; step <= 4; ++step) {
                this.setBlockAndMetadata(world, -8 + step, 4 + step, k1, this.stairBlock, 4);
                this.setBlockAndMetadata(world, 8 - step, 4 + step, k1, this.stairBlock, 5);
            }
            this.setBlockAndMetadata(world, -8, 5, k1, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, -8, 6, k1, (Block)Blocks.field_150349_c, 0);
            this.setBlockAndMetadata(world, -7, 6, k1, (Block)Blocks.field_150349_c, 0);
            this.setBlockAndMetadata(world, 8, 5, k1, this.brickBlock, this.brickMeta);
            this.setBlockAndMetadata(world, 8, 6, k1, (Block)Blocks.field_150349_c, 0);
            this.setBlockAndMetadata(world, 7, 6, k1, (Block)Blocks.field_150349_c, 0);
        }
        for (i13 = -8; i13 <= 8; ++i13) {
            i22 = Math.abs(i13);
            if (i22 == 8) {
                for (k12 = 13; k12 <= 17; ++k12) {
                    this.setBlockAndMetadata(world, i13, 7, k12, this.leafBlock, this.leafMeta);
                }
                for (k12 = 14; k12 <= 16; ++k12) {
                    this.setBlockAndMetadata(world, i13, 8, k12, this.leafBlock, this.leafMeta);
                }
                continue;
            }
            if (i22 == 7) {
                for (k12 = 13; k12 <= 17; ++k12) {
                    this.setBlockAndMetadata(world, i13, 7, k12, this.leafBlock, this.leafMeta);
                }
                this.setBlockAndMetadata(world, i13, 8, 13, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 8, 17, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 7, 15, this.rockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i13, 6, 15, this.brickBlock, this.brickMeta);
                continue;
            }
            if (i22 == 6) {
                this.setBlockAndMetadata(world, i13, 7, 13, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 7, 17, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 8, 13, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 8, 17, this.leafBlock, this.leafMeta);
                this.setBlockAndMetadata(world, i13, 7, 14, this.rockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i13, 7, 15, this.rockSlabBlock, this.rockSlabMeta);
                this.setBlockAndMetadata(world, i13, 7, 16, this.rockSlabBlock, this.rockSlabMeta);
                continue;
            }
            if (i22 != 5) continue;
            this.setBlockAndMetadata(world, i13, 8, 13, this.leafBlock, this.leafMeta);
            this.setBlockAndMetadata(world, i13, 8, 14, this.leafBlock, this.leafMeta);
            this.setBlockAndMetadata(world, i13, 8, 16, this.leafBlock, this.leafMeta);
            this.setBlockAndMetadata(world, i13, 8, 17, this.leafBlock, this.leafMeta);
        }
        for (i13 = -8; i13 <= 8; ++i13) {
            for (k142 = 13; k142 <= 17; ++k142) {
                this.setBlockAndMetadata(world, i13, 0, k142, this.doubleRockSlabBlock, this.rockSlabMeta);
            }
        }
        for (i13 = -2; i13 <= 2; ++i13) {
            this.setBlockAndMetadata(world, i13, 0, 12, this.doubleRockSlabBlock, this.rockSlabMeta);
            for (j1 = 1; j1 <= 3; ++j1) {
                this.setAir(world, i13, j1, 12);
            }
        }
        for (int j111 = 1; j111 <= 3; ++j111) {
            int[] j112 = new int[]{-2, 2};
            n = j112.length;
            for (k162 = 0; k162 < n; ++k162) {
                i15 = j112[k162];
                this.setBlockAndMetadata(world, i15, j111, 12, this.brickBlock, this.brickMeta);
            }
            for (int i123 = -1; i123 <= 1; ++i123) {
                this.setBlockAndMetadata(world, i123, j111, 12, LOTRMod.gateDolAmroth, 2);
            }
        }
        for (int f : new int[]{-1, 1}) {
            int j113;
            this.setBlockAndMetadata(world, 4 * f, 4, 13, this.slabBlock, this.slabMeta | 8);
            this.setBlockAndMetadata(world, 3 * f, 5, 13, this.slabBlock, this.slabMeta);
            this.setBlockAndMetadata(world, 2 * f, 5, 13, this.slabBlock, this.slabMeta | 8);
            this.setBlockAndMetadata(world, 1 * f, 6, 13, this.slabBlock, this.slabMeta);
            this.setBlockAndMetadata(world, 0 * f, 6, 13, this.slabBlock, this.slabMeta);
            this.placeWallBanner(world, 3 * f, 4, 12, LOTRItemBanner.BannerType.DOL_AMROTH, 0);
            this.setBlockAndMetadata(world, 6 * f, 3, 13, Blocks.field_150478_aa, 3);
            for (j113 = 5; j113 <= 6; ++j113) {
                this.setBlockAndMetadata(world, 6 * f, j113, 18, this.woodBeamBlock, this.woodBeamMeta);
            }
            for (j113 = 5; j113 <= 7; ++j113) {
                this.setBlockAndMetadata(world, 2 * f, j113, 18, this.woodBeamBlock, this.woodBeamMeta);
            }
            this.placeWallBanner(world, 6 * f, 5, 18, LOTRItemBanner.BannerType.DOL_AMROTH, 0);
            this.placeWallBanner(world, 6 * f, 5, 18, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
            this.placeWallBanner(world, 2 * f, 6, 18, LOTRItemBanner.BannerType.DOL_AMROTH, 0);
            this.placeWallBanner(world, 2 * f, 6, 18, LOTRItemBanner.BannerType.DOL_AMROTH, 2);
            this.setBlockAndMetadata(world, 6 * f, 3, 17, Blocks.field_150478_aa, 4);
            for (int k113 : new int[]{13, 17}) {
                this.setBlockAndMetadata(world, 4 * f, 1, k113, this.plankBlock, this.plankMeta);
                this.setBlockAndMetadata(world, 5 * f, 1, k113, this.plankSlabBlock, this.plankSlabMeta | 8);
                this.setBlockAndMetadata(world, 7 * f, 1, k113, this.plankSlabBlock, this.plankSlabMeta | 8);
                this.placeChest(world, random, 6 * f, 1, k113, 0, LOTRChestContents.DOL_AMROTH_STABLES);
            }
        }
        this.setBlockAndMetadata(world, -8, 1, 13, Blocks.field_150462_ai, 0);
        this.setBlockAndMetadata(world, -8, 1, 17, Blocks.field_150460_al, 2);
        this.setBlockAndMetadata(world, 8, 1, 13, LOTRMod.gondorianTable, 0);
        this.setBlockAndMetadata(world, 8, 1, 17, LOTRMod.dolAmrothTable, 0);
        for (int i172 : new int[]{-9, 9}) {
            for (int k114 = 14; k114 <= 16; ++k114) {
                this.setBlockAndMetadata(world, i172, 1, k114, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setAir(world, i172, 2, k114);
            }
            this.setBlockAndMetadata(world, i172, 3, 14, this.stairBlock, 7);
            this.setBlockAndMetadata(world, i172, 3, 15, this.slabBlock, this.slabMeta | 8);
            this.setBlockAndMetadata(world, i172, 3, 16, this.stairBlock, 6);
        }
        int[] j111 = new int[]{-8, 7};
        i14 = j111.length;
        for (n = 0; n < i14; ++n) {
            for (int i25 = i172 = j111[n]; i25 <= i172 + 1; ++i25) {
                this.setBlockAndMetadata(world, i25, 1, 18, this.doubleRockSlabBlock, this.rockSlabMeta);
                this.setAir(world, i25, 2, 18);
            }
            this.setBlockAndMetadata(world, i172, 3, 18, this.stairBlock, 4);
            this.setBlockAndMetadata(world, i172 + 1, 3, 18, this.stairBlock, 5);
        }
        for (i12 = -8; i12 <= 8; ++i12) {
            this.setBlockAndMetadata(world, i12, 1, 15, Blocks.field_150404_cg, 11);
        }
        for (i12 = -2; i12 <= 2; ++i12) {
            this.setBlockAndMetadata(world, i12, 1, 14, Blocks.field_150404_cg, 11);
            this.setBlockAndMetadata(world, i12, 1, 16, Blocks.field_150404_cg, 11);
        }
        this.generateWindow(world, -4, 3, 18);
        this.generateWindow(world, 4, 3, 18);
        for (int k162 : new int[]{14, 16}) {
            this.setBlockAndMetadata(world, -1, 9, k162, Blocks.field_150406_ce, 3);
            this.setBlockAndMetadata(world, 0, 9, k162, Blocks.field_150406_ce, 11);
            this.setBlockAndMetadata(world, 1, 9, k162, Blocks.field_150406_ce, 3);
        }
        this.setBlockAndMetadata(world, -2, 9, 15, Blocks.field_150406_ce, 3);
        this.setBlockAndMetadata(world, -1, 9, 15, Blocks.field_150406_ce, 11);
        this.setBlockAndMetadata(world, 0, 9, 15, Blocks.field_150406_ce, 11);
        this.setBlockAndMetadata(world, 1, 9, 15, Blocks.field_150406_ce, 11);
        this.setBlockAndMetadata(world, 2, 9, 15, Blocks.field_150406_ce, 3);
        this.setBlockAndMetadata(world, 0, 8, 15, this.fenceBlock, this.fenceMeta);
        this.setBlockAndMetadata(world, 0, 7, 15, LOTRMod.chandelier, 2);
        for (i1 = -1; i1 <= 1; ++i1) {
            this.setBlockAndMetadata(world, i1, 3, 18, this.doubleRockSlabBlock, this.rockSlabMeta);
            this.setBlockAndMetadata(world, i1, 7, 18, this.doubleRockSlabBlock, this.rockSlabMeta);
            for (j1 = 4; j1 <= 6; ++j1) {
                if (IntMath.mod((int)(i1 + j1), (int)2) == 0) {
                    this.setBlockAndMetadata(world, i1, j1, 18, LOTRMod.stainedGlassPane, 0);
                    continue;
                }
                this.setBlockAndMetadata(world, i1, j1, 18, LOTRMod.stainedGlassPane, 11);
            }
        }
        this.setBlockAndMetadata(world, 0, 8, 18, this.doubleRockSlabBlock, this.rockSlabMeta);
        for (i1 = -6; i1 <= 6; ++i1) {
            i22 = Math.abs(i1);
            this.placeGrassFoundation(world, i1, 19);
            if (i22 % 4 == 2) {
                this.setBlockAndMetadata(world, i1, 1, 19, this.stairBlock, 3);
                this.setGrassToDirt(world, i1, 0, 19);
            } else {
                this.setBlockAndMetadata(world, i1, 1, 19, this.leafBlock, this.leafMeta);
            }
            if (i22 >= 6) {
                this.setBlockAndMetadata(world, i1, 6, 19, this.slabBlock, this.slabMeta | 8);
                continue;
            }
            if (i22 >= 3) {
                this.setBlockAndMetadata(world, i1, 7, 19, this.slabBlock, this.slabMeta);
                continue;
            }
            if (i22 >= 2) {
                this.setBlockAndMetadata(world, i1, 7, 19, this.slabBlock, this.slabMeta | 8);
                continue;
            }
            this.setBlockAndMetadata(world, i1, 8, 19, this.slabBlock, this.slabMeta);
        }
        LOTREntityDolAmrothCaptain captain = new LOTREntityDolAmrothCaptain(world);
        captain.spawnRidingHorse = false;
        this.spawnNPCAndSetHome(captain, world, 0, 1, 15, 8);
        return true;
    }

    private void placeWoodPillar(World world, int i, int k) {
        int j = 0;
        while ((!this.isOpaque(world, i, j, k) || this.getBlock(world, i, j, k) == this.brickBlock && this.getMeta(world, i, j, k) == this.brickMeta) && this.getY(j) >= 0) {
            this.setBlockAndMetadata(world, i, j, k, this.woodBeamBlock, this.woodBeamMeta);
            this.setGrassToDirt(world, i, j - 1, k);
            --j;
        }
        for (j = 1; j <= 4; ++j) {
            this.setBlockAndMetadata(world, i, j, k, this.woodBeamBlock, this.woodBeamMeta);
        }
    }

    private void generateWindow(World world, int i, int j, int k) {
        this.setBlockAndMetadata(world, i - 1, j, k, this.stairBlock, 0);
        this.setBlockAndMetadata(world, i, j, k, this.slabBlock, this.slabMeta);
        this.setBlockAndMetadata(world, i + 1, j, k, this.stairBlock, 1);
        for (int i1 = i - 1; i1 <= i + 1; ++i1) {
            this.setAir(world, i1, j + 1, k);
            this.setAir(world, i1, j + 2, k);
        }
        this.setBlockAndMetadata(world, i - 1, j + 3, k, this.stairBlock, 4);
        this.setBlockAndMetadata(world, i, j + 3, k, this.slabBlock, this.slabMeta | 8);
        this.setBlockAndMetadata(world, i + 1, j + 3, k, this.stairBlock, 5);
    }

    private void placeGrassFoundation(World world, int i, int k) {
        for (int j1 = 6; !(j1 < 0 && this.isOpaque(world, i, j1, k) || this.getY(j1) < 0); --j1) {
            if (j1 > 0) {
                this.setAir(world, i, j1, k);
                continue;
            }
            if (j1 == 0) {
                this.setBlockAndMetadata(world, i, j1, k, (Block)Blocks.field_150349_c, 0);
                this.setGrassToDirt(world, i, j1 - 1, k);
                continue;
            }
            this.setBlockAndMetadata(world, i, j1, k, Blocks.field_150346_d, 0);
            this.setGrassToDirt(world, i, j1 - 1, k);
        }
    }
}

