/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.api.recipeHandlers;

import cpw.mods.fml.relauncher.ReflectionHelper;
import craftedMods.lotr.recipes.api.utils.LOTRRecipeHandlerUtils;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.client.gui.LOTRGuiTrade;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.item.LOTRItemBarrel;
import lotr.common.item.LOTRItemCoin;
import lotr.common.item.LOTRItemMug;
import lotr.common.item.LOTRPoisonedDrinks;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class AbstractTraderRecipeHandler
extends AbstractRecipeHandler<TraderRecipe> {
    public static final int ALL_STRENGHTS_META = 9999;
    protected final String traderName;
    protected final LOTRTradeEntries itemsBought;
    protected final LOTRTradeEntries itemsSold;
    protected List<LOTRItemMug.Vessel> vesselsSold;
    private final TraderRecipeHandlerRenderer renderer = new TraderRecipeHandlerRenderer();
    private final TraderRecipeHandlerRecipeViewer recipeViewer = new TraderRecipeHandlerRecipeViewer(this);

    public AbstractTraderRecipeHandler(String prefix, String unlocalizedName, String faction, LOTRTradeEntries itemsBought, LOTRTradeEntries itemsSold) {
        super(prefix + (faction == null ? "" : faction + ".") + unlocalizedName);
        this.traderName = unlocalizedName;
        this.itemsBought = itemsBought;
        this.itemsSold = itemsSold;
    }

    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        try {
            LOTRItemMug.Vessel[] vesselsArray = (LOTRItemMug.Vessel[])ReflectionHelper.getPrivateValue(LOTRTradeEntries.class, (Object)this.itemsSold, (String[])new String[]{"drinkVessels"});
            if (vesselsArray != null) {
                this.vesselsSold = Arrays.asList(vesselsArray);
            }
        }
        catch (Exception e) {
            logger.error("Could not get private field value drinkVessels from LOTRTradeEntries via reflection", (Throwable)e);
        }
        if (this.vesselsSold == null) {
            this.vesselsSold = new ArrayList<LOTRItemMug.Vessel>();
        }
    }

    public Collection<TraderRecipe> getDynamicCraftingRecipes(ItemStack result) {
        ArrayList<TraderRecipe> recipes = new ArrayList<TraderRecipe>();
        if (result.func_77973_b() != LOTRMod.silverCoin) {
            for (LOTRTradeEntry entry : this.itemsSold.tradeEntries) {
                boolean add = false;
                int baseCost = entry.getCost();
                ItemStack baseItem = entry.createTradeItem();
                if (result.func_77973_b() instanceof LOTRItemMug && LOTRItemMug.isItemFullDrink((ItemStack)result) && baseItem.func_77973_b() instanceof LOTRItemMug && LOTRItemMug.isItemFullDrink((ItemStack)baseItem) && result.func_77973_b() == baseItem.func_77973_b() && LOTRPoisonedDrinks.isDrinkPoisoned((ItemStack)result) == LOTRPoisonedDrinks.isDrinkPoisoned((ItemStack)baseItem) && (baseItem.func_77960_j() == 9999 || LOTRItemMug.getFoodStrength((ItemStack)result) == LOTRItemMug.getFoodStrength((ItemStack)baseItem))) {
                    LOTRItemMug.Vessel vessel = LOTRItemMug.getVessel((ItemStack)result);
                    if (this.vesselsSold.contains(vessel)) {
                        add = true;
                    }
                } else {
                    boolean bl = add = baseItem.func_77973_b() instanceof LOTRItemBarrel || result.func_77973_b() instanceof LOTRItemBarrel ? RecipeHandlerUtils.getInstance().areStacksSameType(baseItem, result) : RecipeHandlerUtils.getInstance().areStacksSameTypeForCrafting(baseItem, result);
                }
                if (!add) continue;
                ItemStack toAdd = result.func_77946_l();
                toAdd.field_77994_a = baseItem.field_77994_a;
                if (toAdd.func_77984_f()) {
                    toAdd.func_77964_b(0);
                }
                recipes.add(new TraderRecipe(toAdd, AbstractTraderRecipeHandler.getMinTradeCost(toAdd, baseCost, true), AbstractTraderRecipeHandler.getMaxTradeCost(toAdd, baseCost, true), true));
            }
        } else {
            recipes.addAll(this.getAllCraftingRecipes());
        }
        return recipes;
    }

    protected Collection<TraderRecipe> getAllCraftingRecipes() {
        ArrayList<TraderRecipe> recipes = new ArrayList<TraderRecipe>();
        for (LOTRTradeEntry entry : this.itemsBought.tradeEntries) {
            int baseCost = entry.getCost();
            ItemStack baseItem = entry.createTradeItem();
            recipes.add(new TraderRecipe(baseItem, AbstractTraderRecipeHandler.getMinTradeCost(baseItem, baseCost, false), AbstractTraderRecipeHandler.getMaxTradeCost(baseItem, baseCost, false), false));
        }
        return recipes;
    }

    public Collection<TraderRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        ArrayList<TraderRecipe> recipes = new ArrayList<TraderRecipe>();
        if (ingredient.func_77973_b() != LOTRMod.silverCoin) {
            for (LOTRTradeEntry entry : this.itemsBought.tradeEntries) {
                int baseCost = entry.getCost();
                ItemStack baseItem = entry.createTradeItem();
                if (!RecipeHandlerUtils.getInstance().areStacksSameTypeForCrafting(baseItem, ingredient)) continue;
                ItemStack toAdd = ingredient.func_77946_l();
                toAdd.field_77994_a = baseItem.field_77994_a;
                if (toAdd.func_77984_f()) {
                    toAdd.func_77964_b(0);
                }
                recipes.add(new TraderRecipe(toAdd, AbstractTraderRecipeHandler.getMinTradeCost(toAdd, baseCost, false), AbstractTraderRecipeHandler.getMaxTradeCost(toAdd, baseCost, false), false));
            }
        } else {
            recipes.addAll(this.getAllUsageRecipes());
        }
        return recipes;
    }

    protected Collection<TraderRecipe> getAllUsageRecipes() {
        ArrayList<TraderRecipe> recipes = new ArrayList<TraderRecipe>();
        for (LOTRTradeEntry entry : this.itemsSold.tradeEntries) {
            int baseCost = entry.getCost();
            ItemStack baseItem = entry.createTradeItem();
            if (baseItem.func_77973_b() instanceof LOTRItemMug && LOTRItemMug.isItemFullDrink((ItemStack)baseItem) && baseItem.func_77960_j() == 9999) {
                for (float strength : LOTRRecipeHandlerUtils.getDrinkStrenghts()) {
                    baseItem = baseItem.func_77946_l();
                    LOTRItemMug.setStrengthMeta((ItemStack)baseItem, (int)LOTRRecipeHandlerUtils.getDrinkStrengthIndex(strength));
                    recipes.add(new TraderRecipe(baseItem, AbstractTraderRecipeHandler.getMinTradeCost(baseItem, baseCost, true), AbstractTraderRecipeHandler.getMaxTradeCost(baseItem, baseCost, true), true));
                }
                continue;
            }
            recipes.add(new TraderRecipe(baseItem, AbstractTraderRecipeHandler.getMinTradeCost(baseItem, baseCost, true), AbstractTraderRecipeHandler.getMaxTradeCost(baseItem, baseCost, true), true));
        }
        return recipes;
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)("entity.lotr." + this.traderName + ".name"));
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(TraderRecipe recipe, EnumRecipeItemRole role) {
        ArrayList<RecipeItemSlot> slots = new ArrayList<RecipeItemSlot>();
        if (role == EnumRecipeItemRole.INGREDIENT) {
            if (recipe.isSold()) {
                slots.add(this.createRecipeItemSlot(30, 24));
            }
            slots.add(this.createRecipeItemSlot(58, 24));
        } else {
            slots.add(this.createRecipeItemSlot(111, 24));
            if (!recipe.isSold()) {
                slots.add(this.createRecipeItemSlot(139, 24));
            }
        }
        return slots;
    }

    public int getRecipesPerPage() {
        return 2;
    }

    public TraderRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerRecipeViewer<TraderRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public static int getMinTradeCost(ItemStack itemStack, int baseCost, boolean sold) {
        return AbstractTraderRecipeHandler.getTradeCost(itemStack, baseCost, sold, 0.75f);
    }

    public static int getMaxTradeCost(ItemStack itemStack, int baseCost, boolean sold) {
        return AbstractTraderRecipeHandler.getTradeCost(itemStack, baseCost, sold, 1.25f);
    }

    public static int getTradeCost(ItemStack itemStack, int baseCost, boolean sold, float probabilityFactor) {
        float tradeCost = baseCost;
        Item item = itemStack.func_77973_b();
        if (item instanceof LOTRItemMug) {
            LOTRItemMug.Vessel vessel;
            LOTRItemMug mug = (LOTRItemMug)item;
            if (mug.isBrewable) {
                tradeCost *= LOTRItemMug.getFoodStrength((ItemStack)itemStack);
            }
            if (LOTRItemMug.isItemFullDrink((ItemStack)itemStack) && (vessel = LOTRItemMug.getVessel((ItemStack)itemStack)) != null) {
                tradeCost += (float)vessel.extraPrice;
            }
        }
        if (sold) {
            tradeCost *= LOTREnchantmentHelper.calcTradeValueFactor((ItemStack)itemStack);
        }
        return Math.max(Math.round(Math.max(tradeCost *= probabilityFactor, 1.0f)), 1);
    }

    public class TraderRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<TraderRecipe, AbstractTraderRecipeHandler> {
        private Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public TraderRecipeHandlerRecipeViewer(AbstractTraderRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiTrade.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public boolean isGuiContainerSupported(GuiContainer container) {
            if (container instanceof LOTRGuiTrade) {
                LOTRGuiTrade tradeGui = (LOTRGuiTrade)container;
                if (!((AbstractTraderRecipeHandler)this.handler).traderName.equals(LOTRRecipeHandlerUtils.getUnlocalizedEntityName(tradeGui.theEntity.getClass()))) {
                    return false;
                }
            }
            return true;
        }

        public Collection<TraderRecipe> getAllRecipes() {
            Collection<TraderRecipe> recipes = ((AbstractTraderRecipeHandler)this.handler).getAllCraftingRecipes();
            recipes.addAll(((AbstractTraderRecipeHandler)this.handler).getAllUsageRecipes());
            return recipes;
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiTrade.class ? 126 : super.getOffsetX(guiClass);
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiTrade.class ? 130 : super.getOffsetY(guiClass);
        }

        public String getButtonTooltip(Class<? extends GuiContainer> guiClass) {
            return StatCollector.func_74838_a((String)"neiLotr.handler.trader.recipeViewer.tooltip");
        }
    }

    public class TraderRecipeHandlerRenderer
    implements RecipeHandlerRenderer<AbstractTraderRecipeHandler, TraderRecipe> {
        public void renderBackground(AbstractTraderRecipeHandler handler, TraderRecipe recipe, int cycleticks) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)15.0f, (float)0.0f, (float)0.0f);
            RecipeHandlerRendererUtils.getInstance().bindTexture("textures/gui/container/crafting_table.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(42, 19, 65, 30, 80, 26);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 13, 18, 10, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 41, 18, 4, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(96, 19, 26, 26, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(95, 23, 65, 34, 18, 18);
            if (!recipe.isSold()) {
                RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(123, 23, 65, 34, 18, 18);
            }
            if (recipe.isSold()) {
                RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(14, 23, 65, 34, 18, 18);
            }
            GL11.glPopMatrix();
        }

        public void renderForeground(AbstractTraderRecipeHandler handler, TraderRecipe recipe, int cycleticks) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)15.0f, (float)0.0f, (float)0.0f);
            int offsetX = recipe.isSold() ? 0 : 81;
            RecipeHandlerRendererUtils.getInstance().drawText(StatCollector.func_74838_a((String)"neiLotr.handler.trader.minLabel"), offsetX + 15, 14, 0x404040, false);
            RecipeHandlerRendererUtils.getInstance().drawText(StatCollector.func_74838_a((String)"neiLotr.handler.trader.maxLabel"), offsetX + 42, 14, 0x404040, false);
            GL11.glPopMatrix();
        }
    }

    public class TraderRecipe
    extends AbstractRecipe {
        private final int minPrice;
        private final int maxPrice;
        private final boolean sold;

        public TraderRecipe(ItemStack stack, int minPrice, int maxPrice, boolean sold) {
            if (sold) {
                this.add(new ItemStack(LOTRMod.silverCoin, minPrice), this.ingredients);
                this.add(new ItemStack(LOTRMod.silverCoin, maxPrice), this.ingredients);
                this.add(stack, this.results);
            } else {
                this.add(new ItemStack(LOTRMod.silverCoin, minPrice), this.results);
                this.add(new ItemStack(LOTRMod.silverCoin, maxPrice), this.results);
                this.add(stack, this.ingredients);
            }
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.sold = sold;
            this.generatePermutations();
        }

        public boolean consumes(ItemStack ingredient) {
            return this.sold && ingredient.func_77973_b() instanceof LOTRItemCoin ? true : super.consumes(ingredient);
        }

        public boolean produces(ItemStack result) {
            return !this.sold && result.func_77973_b() instanceof LOTRItemCoin ? true : super.produces(result);
        }

        public int getMinPrice() {
            return this.minPrice;
        }

        public int getMaxPrice() {
            return this.maxPrice;
        }

        public boolean isSold() {
            return this.sold;
        }

        public ItemStack getIngredientReplacement(ItemStack defaultReplacement) {
            ItemStack ret = defaultReplacement.func_77946_l();
            if (ret.func_77984_f()) {
                ret.func_77964_b(0);
            }
            return ret;
        }

        public ItemStack getResultReplacement(ItemStack defaultReplacement) {
            ItemStack ret = defaultReplacement.func_77946_l();
            if (ret.func_77984_f()) {
                ret.func_77964_b(0);
            }
            return ret;
        }
    }
}

