/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.FurnaceRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lotr.client.gui.LOTRGuiHobbitOven;
import lotr.common.LOTRMod;
import lotr.common.tileentity.LOTRTileEntityHobbitOven;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

@RegisteredHandler
public class HobbitOvenRecipeHandler
extends AbstractRecipeHandler<HobbitOvenRecipe> {
    private final HobbitOvenRecipeHandlerRenderer renderer = new HobbitOvenRecipeHandlerRenderer();
    private final HobbitOvenRecipeHandlerRecipeViewer recipeViewer = new HobbitOvenRecipeHandlerRecipeViewer(this);

    public HobbitOvenRecipeHandler() {
        super("lotr.hobbitOven");
    }

    public String getDisplayName() {
        return LOTRMod.hobbitOven.func_149732_F();
    }

    public int getRecipesPerPage() {
        return 1;
    }

    public Collection<HobbitOvenRecipe> loadSimpleStaticRecipes() {
        ArrayList<HobbitOvenRecipe> ret = new ArrayList<HobbitOvenRecipe>();
        FurnaceRecipes.func_77602_a().func_77599_b().forEach((ingredient, result) -> {
            if (LOTRTileEntityHobbitOven.isCookResultAcceptable((ItemStack)result)) {
                ret.add(new HobbitOvenRecipe((ItemStack)ingredient, (ItemStack)result));
            }
        });
        return ret;
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(HobbitOvenRecipe recipe, EnumRecipeItemRole role) {
        ArrayList<RecipeItemSlot> slots = new ArrayList<RecipeItemSlot>();
        switch (role) {
            case INGREDIENT: {
                for (int i = 0; i < 9; ++i) {
                    slots.add(this.createRecipeItemSlot(3 + i * 18, 10));
                }
                break;
            }
            case RESULT: {
                for (int i = 0; i < 9; ++i) {
                    slots.add(this.createRecipeItemSlot(3 + i * 18, 56));
                }
                break;
            }
            case OTHER: {
                slots.add(this.createRecipeItemSlot(75, 100));
            }
        }
        return slots;
    }

    public HobbitOvenRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerRecipeViewer<HobbitOvenRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public int getDefaultOrder() {
        return 8000;
    }

    public class HobbitOvenRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<HobbitOvenRecipe, HobbitOvenRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public HobbitOvenRecipeHandlerRecipeViewer(HobbitOvenRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiHobbitOven.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public Collection<HobbitOvenRecipe> getAllRecipes() {
            return ((HobbitOvenRecipeHandler)this.handler).getStaticRecipes();
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return 0;
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return 9;
        }
    }

    public class HobbitOvenRecipeHandlerRenderer
    implements RecipeHandlerRenderer<HobbitOvenRecipeHandler, HobbitOvenRecipe> {
        public void renderBackground(HobbitOvenRecipeHandler handler, HobbitOvenRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("lotr:gui/oven.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(0, 0, 5, 11, 166, 117);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(75, 29, 176, 14, 24, 25, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.INCREASE_DOWN);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(75, 83, 176, 0, 14, 13, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.DECREASE_DOWN);
        }

        public void renderForeground(HobbitOvenRecipeHandler handler, HobbitOvenRecipe recipe, int cycleticks) {
        }
    }

    public class HobbitOvenRecipe
    extends FurnaceRecipe {
        public HobbitOvenRecipe(ItemStack ingredient, ItemStack result) {
            super(ingredient, result);
            this.addAll(Arrays.asList(ingredient, ingredient, ingredient, ingredient, ingredient, ingredient, ingredient, ingredient), this.ingredients);
            this.addAll(Arrays.asList(result, result, result, result, result, result, result, result), this.results);
        }
    }
}

