/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.base;

import craftedMods.recipes.api.Recipe;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerCacheManager;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerCraftingHelper;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.base.RecipeHandlerResourceLoader;
import craftedMods.recipes.base.RecipeItemSlotImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRecipeHandler<T extends Recipe>
implements RecipeHandler<T> {
    private final String unlocalizedName;
    protected final Collection<T> staticRecipes = new ArrayList<T>();
    private boolean areStaticRecipesLoaded = false;
    protected Logger logger;
    protected RecipeHandlerConfiguration config;
    protected RecipeHandlerResourceLoader resourceLoader;
    protected Map<ResourceLocation, Supplier<InputStream>> loadedResources = new HashMap<ResourceLocation, Supplier<InputStream>>();
    protected int order;

    protected AbstractRecipeHandler(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)("neiRecipeHandlers.recipeHandler." + this.getUnlocalizedName() + ".name"));
    }

    @Override
    public boolean areStaticRecipesLoaded() {
        return this.areStaticRecipesLoaded;
    }

    @Override
    public Collection<T> getStaticRecipes() {
        return this.staticRecipes;
    }

    @Override
    public Collection<T> getDynamicCraftingRecipes(ItemStack result) {
        return null;
    }

    @Override
    public Collection<T> getDynamicUsageRecipes(ItemStack ingredient) {
        return null;
    }

    @Override
    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.order = this.config.getInt("Order", this.getDefaultOrder(), Integer.MIN_VALUE, Integer.MAX_VALUE, "The order number of the recipe handler. Higher values mean that the handler will be displayed after handlers with a lower order number. Negative values are also possible.");
    }

    @Override
    public Collection<T> loadSimpleStaticRecipes() {
        return null;
    }

    @Override
    public T loadComplicatedStaticRecipe(ItemStack ... stacks) {
        return null;
    }

    @Override
    public void onPostLoad(Collection<T> staticRecipes) {
        this.staticRecipes.addAll(staticRecipes);
        this.areStaticRecipesLoaded = true;
    }

    protected RecipeItemSlot createRecipeItemSlot(int x, int y) {
        return new RecipeItemSlotImpl(x, y);
    }

    @Override
    public void onUpdate(int cycleticks) {
    }

    @Override
    public RecipeHandlerCacheManager<T> getCacheManager() {
        return null;
    }

    @Override
    public int getRecipesPerPage() {
        return 2;
    }

    @Override
    public <V extends RecipeHandlerRenderer<W, T>, W extends RecipeHandler<T>> V getRenderer() {
        return null;
    }

    @Override
    public int getComplicatedStaticRecipeDepth() {
        return 0;
    }

    @Override
    public RecipeHandlerCraftingHelper<T> getCraftingHelper() {
        return null;
    }

    @Override
    public RecipeHandlerRecipeViewer<T> getRecipeViewer() {
        return null;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public int getDefaultOrder() {
        return 10000;
    }
}

