/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider;

import codechicken.nei.api.API;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.ModMetadata;
import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.api.ItemHidingHandler;
import craftedMods.recipes.api.ItemOverrideHandler;
import craftedMods.recipes.api.ItemStackComparisonHandler;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerFactory;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.ResourceHandler;
import craftedMods.recipes.api.VanillaCraftingTableRecipeHandlerSupport;
import craftedMods.recipes.api.VersionCheckerHandler;
import craftedMods.recipes.provider.NEIRecipeHandlersConfiguration;
import craftedMods.recipes.provider.NEIRecipeHandlersTransferRectManager;
import craftedMods.recipes.provider.PluginRecipeHandler;
import craftedMods.recipes.provider.RecipeHandlerManager;
import craftedMods.recipes.provider.ResourceHandlerResourcePack;
import craftedMods.recipes.provider.recipeHandlers.VanillaCraftingTableRecipeHandler;
import craftedMods.recipes.utils.NEIRecipeHandlersUtils;
import craftedMods.recipes.utils.VersionChecker;
import craftedMods.utils.ClassDiscoverer;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

public class NEIIntegrationManager
implements IResourceManagerReloadListener {
    private final NEIRecipeHandlersConfiguration config;
    private final Logger logger;
    private final ClassDiscoverer discoverer;
    private RecipeHandlerManager recipeHandlerManager;
    private Collection<ItemHidingHandler> itemHidingHandlers = new ArrayList<ItemHidingHandler>();
    private Collection<ItemOverrideHandler> itemOverrideHandlers = new ArrayList<ItemOverrideHandler>();
    private Collection<ItemStackComparisonHandler> itemStackComarisonHandlers = new ArrayList<ItemStackComparisonHandler>();
    private Map<VersionCheckerHandler, VersionChecker> versionCheckers = new HashMap<VersionCheckerHandler, VersionChecker>();
    private Collection<Class<?>> recipeHandlersToRemove = new HashSet();
    private ResourceHandlerResourcePack recipeHandlerResourcePack;
    private boolean wasLoaded = false;

    public NEIIntegrationManager(NEIRecipeHandlersConfiguration config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.discoverer = new ClassDiscoverer(logger);
    }

    public void preInit() {
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, RecipeHandler.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, RecipeHandlerFactory.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, ItemHidingHandler.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, ItemOverrideHandler.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, ResourceHandler.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, VersionCheckerHandler.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, VanillaCraftingTableRecipeHandlerSupport.class);
        this.discoverer.registerClassToDiscover(RegisteredHandler.class, ItemStackComparisonHandler.class);
        this.discoverer.discoverClassesAsync();
    }

    public void init(boolean useCachedRecipes) {
        try {
            long start = System.currentTimeMillis();
            Map<Class<? extends Annotation>, Map<Class<?>, Set<Class<?>>>> discoveredClasses = this.discoverer.getDiscoveredClasses(this.config.getClassDiscovererThreadTimeout());
            this.setupResourceHandlerHandlerResourcePack(discoveredClasses);
            if (Minecraft.func_71410_x().func_110442_L() instanceof IReloadableResourceManager) {
                IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
                resourceManager.func_110542_a((IResourceManagerReloadListener)this);
            } else {
                this.logger.warn(String.format("The MC resource manager doesn't implement %s. Some features of %s are therefore not available.", new Object[0]), new Object[]{IReloadableResourceManager.class.getName(), "NEI Recipe Handlers"});
            }
            this.itemStackComarisonHandlers.addAll(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, ItemStackComparisonHandler.class));
            this.recipeHandlerManager = new RecipeHandlerManager(this.config.getConfigFile(), discoveredClasses);
            VanillaCraftingTableRecipeHandler vanillaRecipeHandler = new VanillaCraftingTableRecipeHandler(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, VanillaCraftingTableRecipeHandlerSupport.class));
            this.recipeHandlerManager.init(useCachedRecipes, Arrays.asList(vanillaRecipeHandler));
            NEIRecipeHandlers.mod.getLogger().info("Enable item hiding handlers: " + this.config.isHideTechnicalBlocks());
            if (this.config.isHideTechnicalBlocks()) {
                this.itemHidingHandlers.addAll(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, ItemHidingHandler.class));
            }
            this.itemOverrideHandlers.addAll(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, ItemOverrideHandler.class));
            final ArrayList<VersionCheckerHandler> versionCheckerHandlers = new ArrayList<VersionCheckerHandler>(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, VersionCheckerHandler.class));
            final StringBuilder newModDescriptionBuilder = new StringBuilder(EnumChatFormatting.DARK_GREEN + "\n\nLoaded modules: ");
            ModMetadata neiRecipeHandlersMetadata = FMLCommonHandler.instance().findContainerFor((Object)NEIRecipeHandlers.mod).getMetadata();
            if (versionCheckerHandlers.isEmpty()) {
                newModDescriptionBuilder.append(EnumChatFormatting.RED + "None");
            }
            newModDescriptionBuilder.append("\n");
            for (VersionCheckerHandler handler : versionCheckerHandlers) {
                newModDescriptionBuilder.append(String.format("%s\n - %s (%s)", EnumChatFormatting.GREEN, handler.getLocalizedHandlerName(), handler.getCurrentVersion() != null ? handler.getCurrentVersion().toString() : ""));
            }
            neiRecipeHandlersMetadata.description = neiRecipeHandlersMetadata.description.concat(newModDescriptionBuilder.toString());
            FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

                public String call() throws Exception {
                    StringBuilder modulesList = new StringBuilder();
                    if (versionCheckerHandlers.isEmpty()) {
                        newModDescriptionBuilder.append("None");
                    }
                    for (VersionCheckerHandler handler : versionCheckerHandlers) {
                        modulesList.append(handler.getLocalizedHandlerName() + " (" + (handler.getCurrentVersion() != null ? handler.getCurrentVersion().toString() : "") + "); ");
                    }
                    return modulesList.toString();
                }

                public String getLabel() {
                    return "NEI Recipe Handlers modules: ";
                }
            });
            if (this.config.isUseVersionChecker()) {
                for (VersionCheckerHandler handler : versionCheckerHandlers) {
                    if (handler.getCurrentVersion() != null && handler.getVersionFileURL() != null && handler.getVersionFileURL().trim().isEmpty()) continue;
                    VersionChecker checker = new VersionChecker(handler.getVersionFileURL(), handler.getCurrentVersion());
                    if (!NEIRecipeHandlersUtils.doVersionCheck(handler.getLocalizedHandlerName(), checker, this.logger)) continue;
                    this.versionCheckers.put(handler, checker);
                    handler.onVersionCheck(checker.getRemoteVersion().getRemoteVersion());
                }
            }
            this.logger.info("Initialized NEI configuration within " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            this.logger.error("Couldn't initialize NEI configuration: ", (Throwable)e);
        }
    }

    private void setupResourceHandlerHandlerResourcePack(Map<Class<? extends Annotation>, Map<Class<?>, Set<Class<?>>>> discoveredClasses) {
        ArrayList<ResourceHandler> handlersToRegister = new ArrayList<ResourceHandler>(NEIRecipeHandlersUtils.discoverRegisteredHandlers(discoveredClasses, ResourceHandler.class));
        Iterator handlersToRegisterIterator = handlersToRegister.iterator();
        while (handlersToRegisterIterator.hasNext()) {
            ResourceHandler handler = (ResourceHandler)handlersToRegisterIterator.next();
            Map<ResourceLocation, Supplier<InputStream>> resources = handler.getResources();
            int resourceCount = resources == null ? 0 : resources.size();
            this.logger.debug(String.format("The resource handler \"%s\" registered %d resources", handler.getClass().getName(), resourceCount));
            if (resourceCount > 0) continue;
            handlersToRegisterIterator.remove();
        }
        this.recipeHandlerResourcePack = new ResourceHandlerResourcePack(handlersToRegister);
        NEIRecipeHandlersUtils.registerDefaultResourcePack(this.recipeHandlerResourcePack);
        this.logger.info("Registered the resource handler resource pack");
    }

    public void removeRecipeHandler(String recipeHandlerClass) throws ClassNotFoundException {
        Class<?> loadedClass = Class.forName(recipeHandlerClass);
        if (!IUsageHandler.class.isAssignableFrom(loadedClass) && !ICraftingHandler.class.isAssignableFrom(loadedClass)) {
            throw new IllegalArgumentException(String.format("The provided class \"%s\" is not an instance of ICraftingHandler or IUsageHandler", loadedClass.getName()));
        }
        this.recipeHandlersToRemove.add(loadedClass);
    }

    public void load() {
        if (!this.config.isDisabled()) {
            long start = System.currentTimeMillis();
            if (this.config.isBrewingRecipeHandlerDisabled()) {
                this.removeCraftingAndUsageHandler(BrewingRecipeHandler.class);
            }
            for (Class<?> recipeHandlerToRemove : this.recipeHandlersToRemove) {
                if (IUsageHandler.class.isAssignableFrom(recipeHandlerToRemove)) {
                    this.removeUsageHandler(recipeHandlerToRemove);
                }
                if (!ICraftingHandler.class.isAssignableFrom(recipeHandlerToRemove)) continue;
                this.removeCraftingHandler(recipeHandlerToRemove);
            }
            this.recipeHandlerManager.getRecipeHandlers().values().stream().sorted((handler1, handler2) -> {
                if (handler1.getOrder() != handler2.getOrder()) {
                    return handler1.getOrder() - handler2.getOrder();
                }
                return handler1.getDisplayName().compareTo(handler2.getDisplayName());
            }).forEach(handler -> this.loadHandler(new PluginRecipeHandler(handler)));
            if (this.config.isHideTechnicalBlocks()) {
                this.registerHiddenItems();
            }
            this.registerItemOverrides();
            this.wasLoaded = true;
            this.logger.info("Loaded NEI configuration for within " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public void onWorldLoad() {
        if (this.config.isUseVersionChecker()) {
            this.versionCheckers.forEach((handler, checker) -> {
                if (checker.compareRemoteVersion() == VersionChecker.EnumVersionComparison.NEWER) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b(NEIRecipeHandlersUtils.getVersionNotificationChatText(handler.getLocalizedHandlerName(), checker.getRemoteVersion()));
                }
            });
        }
    }

    public void refreshCache() {
        this.recipeHandlerManager.refreshCache();
    }

    public void func_110549_a(IResourceManager manager) {
        if (this.wasLoaded) {
            this.registerItemOverrides();
            this.logger.info("Reloaded the item override handlers");
        }
    }

    public Collection<ItemStackComparisonHandler> getItemStackComparisonHandlers() {
        return this.itemStackComarisonHandlers;
    }

    private void loadHandler(PluginRecipeHandler<?, ?> handler) {
        GuiCraftingRecipe.craftinghandlers.add(handler);
        GuiUsageRecipe.usagehandlers.add(handler);
        new RecipeHandlerEventHandler(handler.getInnerHandler());
        NEIRecipeHandlersTransferRectManager.registerHandler(handler.getInnerHandler());
    }

    private <T extends ICraftingHandler & IUsageHandler> void removeCraftingAndUsageHandler(Class<T> handlerClass) {
        this.removeCraftingHandler(handlerClass);
        this.removeUsageHandler(handlerClass);
    }

    private void removeCraftingHandler(Class<? extends ICraftingHandler> handlerClass) {
        this.removeHandler(handlerClass, GuiCraftingRecipe.craftinghandlers, false);
    }

    private void removeUsageHandler(Class<? extends IUsageHandler> handlerClass) {
        this.removeHandler(handlerClass, GuiUsageRecipe.usagehandlers, true);
    }

    private <T> void removeHandler(Class<? extends T> handlerClass, List<T> handlerList, boolean isUsageHandler) {
        for (int i = 0; i < handlerList.size(); ++i) {
            T handler = handlerList.get(i);
            if (handler.getClass() != handlerClass) continue;
            handlerList.remove(i);
            this.logger.debug(String.format("Removed the %s recipe handler \"%s\" of class \"%s\"", isUsageHandler ? "usage" : "crafting", handler, handlerClass.getName()));
        }
    }

    private void registerHiddenItems() {
        for (ItemHidingHandler handler : this.itemHidingHandlers) {
            Collection<ItemStack> hiddenStacks = handler.getHiddenStacks();
            if (hiddenStacks == null) continue;
            hiddenStacks.forEach(API::hideItem);
            NEIRecipeHandlers.mod.getLogger().debug("The item hiding handler \"" + handler.getClass() + "\" has hidden " + (hiddenStacks == null ? 0 : hiddenStacks.size()) + " items");
        }
    }

    private void registerItemOverrides() {
        for (ItemOverrideHandler handler : this.itemOverrideHandlers) {
            Map<ItemStack, String> overrides = handler.getItemOverrideNames();
            if (overrides == null) continue;
            overrides.forEach(API::setOverrideName);
            NEIRecipeHandlers.mod.getLogger().debug("The item override handler \"" + handler.getClass() + "\" overwrote the name of " + (overrides == null ? 0 : overrides.size()) + " items");
        }
    }

    public class RecipeHandlerEventHandler {
        public RecipeHandlerEventHandler(RecipeHandler<?> handler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

