/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.RecipeInfo;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.provider.PluginRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.opengl.GL11;

public class NEIRecipeHandlersTransferRectManager
implements IContainerInputHandler,
IContainerTooltipHandler,
IContainerDrawHandler {
    private static HashMap<Class<? extends GuiContainer>, HashMap<RecipeHandler<?>, TransferRect>> guiMap;

    public static void registerHandler(RecipeHandler<?> handler) {
        RecipeHandlerRecipeViewer<?> recipeViewer;
        if (handler.getRecipeViewer() != null && (recipeViewer = handler.getRecipeViewer()).getSupportedGUIClasses() != null) {
            ArrayList<Class<GuiContainer>> guiClasses = new ArrayList<Class<GuiContainer>>(recipeViewer.getSupportedGUIClasses());
            if (guiClasses.contains(GuiRecipe.class)) {
                guiClasses.remove(GuiRecipe.class);
                guiClasses.add(GuiCraftingRecipe.class);
                guiClasses.add(GuiUsageRecipe.class);
            }
            for (Class clazz : guiClasses) {
                Rectangle area = new Rectangle(RecipeHandlerRecipeViewer.VIEW_ALL_RECIPES_RECTANGLE);
                area.translate(recipeViewer.getOffsetX(clazz), recipeViewer.getOffsetY(clazz));
                if (!guiMap.containsKey(clazz)) {
                    guiMap.put(clazz, new HashMap());
                }
                guiMap.get(clazz).put(handler, new TransferRect(area, NEIRecipeHandlersTransferRectManager.getViewAllRecipedIdentifier(handler), new Object[0]));
            }
        }
    }

    public static String getViewAllRecipedIdentifier(RecipeHandler<?> handler) {
        return "all_" + handler.getUnlocalizedName();
    }

    public boolean canHandle(GuiContainer gui) {
        return guiMap.containsKey(gui.getClass()) && guiMap.get(gui.getClass()).keySet().stream().anyMatch(handler -> handler.getRecipeViewer().isGuiContainerSupported(gui));
    }

    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
        if (!this.canHandle(gui)) {
            return false;
        }
        if (gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)gui;
            Boolean res = this.executeForGuiRecipe(guiRecipe, null, triple -> {
                Point offset = guiRecipe.getRecipePosition(((Integer)triple.getLeft()).intValue());
                boolean result = false;
                if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
                    result = this.transferRect(gui, (RecipeHandler)triple.getRight(), offset.x, offset.y, false);
                }
                if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage")) {
                    result = this.transferRect(gui, (RecipeHandler)triple.getRight(), offset.x, offset.y, true);
                }
                if (result) {
                    return true;
                }
                return null;
            }, false);
            return res == Boolean.TRUE;
        }
        int[] offset = RecipeInfo.getGuiOffset((GuiContainer)gui);
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            return this.transferRect(gui, null, offset[0], offset[1], false);
        }
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage")) {
            return this.transferRect(gui, null, offset[0], offset[1], true);
        }
        return false;
    }

    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (!this.canHandle(gui)) {
            return false;
        }
        if (gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)gui;
            Boolean res = this.executeForGuiRecipe(guiRecipe, null, triple -> {
                Point offset = guiRecipe.getRecipePosition(((Integer)triple.getLeft()).intValue());
                boolean result = false;
                if (button == 0) {
                    result = this.transferRect(gui, (RecipeHandler)triple.getRight(), offset.x, offset.y, false);
                }
                if (button == 1) {
                    result = this.transferRect(gui, (RecipeHandler)triple.getRight(), offset.x, offset.y, true);
                }
                if (result) {
                    return true;
                }
                return null;
            }, false);
            return res == Boolean.TRUE;
        }
        int[] offset = RecipeInfo.getGuiOffset((GuiContainer)gui);
        if (button == 0) {
            return this.transferRect(gui, null, offset[0], offset[1], false);
        }
        if (button == 1) {
            return this.transferRect(gui, null, offset[0], offset[1], true);
        }
        return false;
    }

    private boolean transferRect(GuiContainer gui, RecipeHandler<?> currentHandler, int offsetx, int offsety, boolean usage) {
        Map transferRects = guiMap.get(gui.getClass());
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.field_147003_i - offsetx, pos.y - gui.field_147009_r - offsety);
        for (Map.Entry entry : transferRects.entrySet()) {
            TransferRect rect;
            if (!((RecipeHandler)entry.getKey()).getRecipeViewer().isGuiContainerSupported(gui) || currentHandler != null && currentHandler != entry.getKey() || !(rect = (TransferRect)entry.getValue()).rect.contains(relMouse)) continue;
            if (usage) {
                if (!GuiUsageRecipe.openRecipeGui((String)rect.outputId, (Object[])rect.results)) continue;
            } else if (!GuiCraftingRecipe.openRecipeGui((String)rect.outputId, (Object[])rect.results)) continue;
            return true;
        }
        return false;
    }

    private List<String> transferRectTooltip(GuiContainer gui, RecipeHandler<?> currentHandler, Map<RecipeHandler<?>, TransferRect> transferRects, int offsetx, int offsety, List<String> currenttip) {
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.field_147003_i - offsetx, pos.y - gui.field_147009_r - offsety);
        for (Map.Entry<RecipeHandler<?>, TransferRect> entry : transferRects.entrySet()) {
            TransferRect rect;
            if (!entry.getKey().getRecipeViewer().isGuiContainerSupported(gui) || currentHandler != null && currentHandler != entry.getKey() || !(rect = entry.getValue()).rect.contains(relMouse)) continue;
            currenttip.add(entry.getKey().getRecipeViewer().getButtonTooltip(gui.getClass()));
            break;
        }
        return currenttip;
    }

    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public boolean keyTyped(GuiContainer gui, char keyChar, int keyID) {
        return false;
    }

    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        if (!this.canHandle(gui)) {
            return currenttip;
        }
        List<String> ret = currenttip;
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            if (gui instanceof GuiRecipe) {
                GuiRecipe guiRecipe = (GuiRecipe)gui;
                ret = this.executeForGuiRecipe(guiRecipe, null, triple -> {
                    Point offset = guiRecipe.getRecipePosition(((Integer)triple.getLeft()).intValue());
                    List oldtip = currenttip;
                    List<String> newTip = this.transferRectTooltip(gui, (RecipeHandler)triple.getRight(), (Map)guiMap.get(gui.getClass()), offset.x, offset.y, currenttip);
                    if (!oldtip.equals(newTip)) {
                        return newTip;
                    }
                    return null;
                }, false);
                if (ret == null) {
                    ret = currenttip;
                }
            } else {
                int[] offset = RecipeInfo.getGuiOffset((GuiContainer)gui);
                ret = this.transferRectTooltip(gui, null, (Map)guiMap.get(gui.getClass()), offset[0], offset[1], currenttip);
            }
        }
        return ret;
    }

    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        return currenttip;
    }

    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }

    public void onPreDraw(GuiContainer var1) {
    }

    public void postRenderObjects(GuiContainer guiContainer, int mouseX, int mouseY) {
        if (this.canHandle(guiContainer)) {
            guiMap.get(guiContainer.getClass()).forEach((handler, rect) -> {
                if (handler.getRecipeViewer().isGuiContainerSupported(guiContainer)) {
                    if (guiContainer instanceof GuiRecipe) {
                        GuiRecipe guiRecipe = (GuiRecipe)guiContainer;
                        this.executeForGuiRecipe(guiRecipe, (RecipeHandler<?>)handler, triple -> {
                            Point offset = guiRecipe.getRecipePosition(((Integer)triple.getLeft()).intValue());
                            this.renderButtons(guiContainer, (RecipeHandler<?>)handler, offset.x, offset.y);
                            return null;
                        }, true);
                    } else {
                        int[] offset = RecipeInfo.getGuiOffset((GuiContainer)guiContainer);
                        this.renderButtons(guiContainer, (RecipeHandler<?>)handler, offset[0], offset[1]);
                    }
                }
            });
        }
    }

    private <T> T executeForGuiRecipe(GuiRecipe guiContainer, RecipeHandler<?> handler, Function<Triple<Integer, RecipeHandler<?>, RecipeHandler<?>>, T> toExecute, boolean innerHandlerEqualToHandler) {
        GuiRecipe guiRecipe = guiContainer;
        IRecipeHandler currentHandler = (IRecipeHandler)guiRecipe.currenthandlers.get(guiRecipe.recipetype);
        if (currentHandler instanceof PluginRecipeHandler) {
            RecipeHandler innerHandler = ((PluginRecipeHandler)currentHandler).getInnerHandler();
            if (!innerHandlerEqualToHandler || innerHandler == handler) {
                for (int currentRecipe = guiRecipe.page * currentHandler.recipiesPerPage(); currentRecipe < currentHandler.numRecipes() && currentRecipe < (guiRecipe.page + 1) * currentHandler.recipiesPerPage(); ++currentRecipe) {
                    T result = toExecute.apply(Triple.of((Object)currentRecipe, handler, innerHandler));
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private void renderButtons(GuiContainer guiContainer, RecipeHandler<?> handler, int offsetX, int offsetY) {
        Point absMousePos = GuiDraw.getMousePosition();
        Point relMouse = new Point(absMousePos.x - guiContainer.field_147003_i - offsetX, absMousePos.y - guiContainer.field_147009_r - offsetY);
        Rectangle location = new Rectangle(RecipeHandlerRecipeViewer.VIEW_ALL_RECIPES_RECTANGLE);
        location.translate(handler.getRecipeViewer().getOffsetX(guiContainer.getClass()), handler.getRecipeViewer().getOffsetY(guiContainer.getClass()));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(guiContainer.field_147003_i + location.x + offsetX), (float)(guiContainer.field_147009_r + location.y + offsetY), (float)0.0f);
        GL11.glScalef((float)((float)location.width / 16.0f), (float)((float)location.height / 16.0f), (float)0.0f);
        RenderItem.getInstance().func_77015_a(GuiDraw.fontRenderer, GuiDraw.renderEngine, handler.getRecipeViewer().getButtonIcon(guiContainer.getClass()), 0, 0);
        GL11.glScalef((float)(16.0f / (float)location.width), (float)(16.0f / (float)location.height), (float)0.0f);
        if (location.contains(relMouse)) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawGradientRect((int)0, (int)0, (int)location.width, (int)location.height, (int)-2130706433, (int)-2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
    }

    public void renderObjects(GuiContainer var1, int var2, int var3) {
    }

    public void renderSlotOverlay(GuiContainer var1, Slot var2) {
    }

    public void renderSlotUnderlay(GuiContainer var1, Slot var2) {
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new NEIRecipeHandlersTransferRectManager());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new NEIRecipeHandlersTransferRectManager());
        GuiContainerManager.addDrawHandler((IContainerDrawHandler)new NEIRecipeHandlersTransferRectManager());
        guiMap = new HashMap();
    }

    public static class TransferRect {
        private Rectangle rect;
        private String outputId;
        private Object[] results;

        public TransferRect(Rectangle rectangle, String outputId, Object ... results) {
            this.rect = rectangle;
            this.outputId = outputId;
            this.results = results;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public String getOutputId() {
            return this.outputId;
        }

        public Object[] getResults() {
            return this.results;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransferRect)) {
                return false;
            }
            return this.rect.equals(((TransferRect)obj).rect);
        }

        public int hashCode() {
            return this.rect.hashCode();
        }
    }
}

