/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider;

import codechicken.nei.ItemList;
import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.api.Recipe;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerCacheManager;
import craftedMods.recipes.api.RecipeHandlerFactory;
import craftedMods.recipes.provider.RecipeHandlerConfigurationImpl;
import craftedMods.recipes.utils.NEIRecipeHandlersUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;

public class RecipeHandlerManager {
    private Map<String, RecipeHandler<?>> recipeHandlers = new HashMap();
    private final Configuration config;
    private final Map<Class<? extends Annotation>, Map<Class<?>, Set<Class<?>>>> discoveredClasses;
    private final ExecutorService complicatedStaticRecipeLoadingThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private long complicatedStaticRecipeIterations = 0L;
    private final AtomicLong complicatedStaticRecipeIterationsCounter = new AtomicLong(1L);
    private static final int COMPLICATED_STATIC_RECIPE_BATCH_SIZE = 300;
    public static final String RECIPE_HANDLER_HEADER_TAG_KEY = "header";
    public static final String RECIPE_HANDLER_CONTENT_TAG_KEY = "content";

    public RecipeHandlerManager(Configuration config, Map<Class<? extends Annotation>, Map<Class<?>, Set<Class<?>>>> discoveredClasses) {
        this.config = config;
        this.discoveredClasses = discoveredClasses;
    }

    public void init(boolean useCache, Collection<RecipeHandler<?>> initialHandlers) {
        this.discoverRecipeHandlersInClasspath(initialHandlers);
        if (!this.recipeHandlers.isEmpty()) {
            this.loadRecipeHandlers();
            HashMap recipes = new HashMap(this.recipeHandlers.size());
            if (useCache) {
                this.loadRecipesFromCache(recipes);
            }
            this.loadStaticRecipes(recipes);
            this.writeRecipesToCache();
        }
    }

    private void discoverRecipeHandlersInClasspath(Collection<RecipeHandler<?>> initialHandlers) {
        ArrayList recipeHandlers = new ArrayList(initialHandlers);
        recipeHandlers.addAll(NEIRecipeHandlersUtils.discoverRegisteredHandlers(this.discoveredClasses, RecipeHandler.class));
        recipeHandlers.addAll(NEIRecipeHandlersUtils.discoverRegisteredHandlers(this.discoveredClasses, RecipeHandlerFactory.class).stream().map(factory -> factory.getRecipeHandlers()).flatMap(Collection::stream).collect(Collectors.toList()));
        recipeHandlers.forEach(this::registerRecipeHandler);
    }

    private void registerRecipeHandler(RecipeHandler<?> instance) {
        if (this.recipeHandlers.putIfAbsent(instance.getUnlocalizedName(), instance) == null) {
            NEIRecipeHandlers.mod.getLogger().debug("Successfully registered recipe handler \"" + instance.getUnlocalizedName() + "\" of class \"" + instance.getClass().getName() + "\"");
        } else {
            NEIRecipeHandlers.mod.getLogger().warn("Couldn't register recipe handler \"" + instance.getClass().getName() + "\". A recipe handler with the unlocalized name \"" + instance.getUnlocalizedName() + "\" is already registered!");
        }
    }

    private void loadRecipeHandlers() {
        Iterator<RecipeHandler<?>> handlers = this.recipeHandlers.values().iterator();
        while (handlers.hasNext()) {
            RecipeHandler<?> handler = handlers.next();
            try {
                RecipeHandlerConfigurationImpl config = new RecipeHandlerConfigurationImpl(this.config, handler.getUnlocalizedName());
                boolean categoryDisabled = false;
                StringBuilder parentCategory = new StringBuilder();
                for (String category : NEIRecipeHandlersUtils.getRecipeHandlerCategories(handler.getUnlocalizedName())) {
                    parentCategory.append(category);
                    categoryDisabled = categoryDisabled || this.config.getBoolean("Disable all recipe handlers in this category", "recipeHandlers." + parentCategory.toString(), false, "If set to true, all recipe handlers in this category and all subcategories will be disabled");
                    parentCategory.append(".");
                }
                if (config.isEnabled() && !categoryDisabled) {
                    handler.onPreLoad(config, LogManager.getLogger((String)handler.getUnlocalizedName()));
                    continue;
                }
                handlers.remove();
                NEIRecipeHandlers.mod.getLogger().info("The recipe handler \"" + handler.getDisplayName() + "\" was disabled by the user (via the config file).");
            }
            catch (Exception e) {
                handlers.remove();
                NEIRecipeHandlers.mod.getLogger().error("Couldn't load recipe handler \"" + handler.getUnlocalizedName() + "\"", (Throwable)e);
            }
        }
        this.config.save();
    }

    private void loadRecipesFromCache(Map<RecipeHandler<?>, Collection<Recipe>> cachedRecipes) {
        if (NEIRecipeHandlers.mod.getConfig().isComplicatedStaticRecipeLoadingCacheEnabled()) {
            try (FileInputStream in = new FileInputStream(NEIRecipeHandlers.mod.getRecipeCache());){
                NBTTagCompound cacheRootTag = CompressedStreamTools.func_74796_a((InputStream)in);
                for (String key : cacheRootTag.func_150296_c()) {
                    NBTTagCompound handlerTag = cacheRootTag.func_74775_l(key);
                    boolean wasHandlerFound = false;
                    for (RecipeHandler<?> handler : this.recipeHandlers.values()) {
                        if (!handler.getUnlocalizedName().equals(key)) continue;
                        wasHandlerFound = true;
                        RecipeHandlerCacheManager<?> cache = handler.getCacheManager();
                        if (cache != null && cache.isCacheEnabled()) {
                            NBTTagCompound headerTag = handlerTag.func_74775_l(RECIPE_HANDLER_HEADER_TAG_KEY);
                            if (cache.isCacheValid(headerTag)) {
                                Collection<?> readRecipes = cache.readRecipesFromCache(headerTag, handlerTag.func_74775_l(RECIPE_HANDLER_CONTENT_TAG_KEY));
                                if (readRecipes != null && !readRecipes.isEmpty()) {
                                    if (!cachedRecipes.containsKey(handler)) {
                                        cachedRecipes.put(handler, new ArrayList());
                                    }
                                    cachedRecipes.get(handler).addAll(readRecipes);
                                    NEIRecipeHandlers.mod.getLogger().info("The recipe handler \"" + handler.getUnlocalizedName() + "\" loaded " + readRecipes.size() + " recipes from the cache");
                                    continue;
                                }
                                NEIRecipeHandlers.mod.getLogger().info("The recipe handler \"" + handler.getUnlocalizedName() + "\" loaded no recipes from the cache");
                                continue;
                            }
                            NEIRecipeHandlers.mod.getLogger().info("The cache of the recipe handler \"" + key + "\" is not valid, the discovered data won't be used");
                            continue;
                        }
                        NEIRecipeHandlers.mod.getLogger().debug("The recipe handler \"" + key + "\" doesn't support caching (the discovered cache data won't be used)");
                    }
                    if (wasHandlerFound) continue;
                    NEIRecipeHandlers.mod.getLogger().debug("A cache entry \"" + key + "\" was found with no corresponding recipe handler, it'll be ignored");
                }
            }
            catch (Exception e) {
                NEIRecipeHandlers.mod.getLogger().error("Couldn't load the static recipes from the cache: ", (Throwable)e);
            }
        }
    }

    private void loadStaticRecipes(Map<RecipeHandler<?>, Collection<Recipe>> staticRecipes) {
        this.loadSimpleStaticRecipes(staticRecipes);
        int maxItemIterationDepth = 0;
        for (RecipeHandler<?> recipeHandler : this.recipeHandlers.values()) {
            maxItemIterationDepth = Math.max(maxItemIterationDepth, recipeHandler.getComplicatedStaticRecipeDepth());
        }
        if (maxItemIterationDepth > 2) {
            NEIRecipeHandlers.mod.getLogger().warn("The static recipe iteration depth (" + maxItemIterationDepth + ") is very high (yes, three is high because itemCount^iterationDepth iterations are required) which can delay the startup of MC.");
        }
        if (maxItemIterationDepth != 0) {
            HashMap<RecipeHandler<? extends Recipe>, Collection<Recipe>> complicatedStaticRecipes = new HashMap<RecipeHandler<? extends Recipe>, Collection<Recipe>>();
            for (RecipeHandler<?> recipeHandler : this.recipeHandlers.values()) {
                if (recipeHandler.getComplicatedStaticRecipeDepth() <= 0) continue;
                complicatedStaticRecipes.put(recipeHandler, new ArrayList(150));
            }
            this.loadComplicatedStaticRecipes(maxItemIterationDepth, complicatedStaticRecipes);
            try {
                this.complicatedStaticRecipeLoadingThreadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            complicatedStaticRecipes.forEach((handler, recipes) -> {
                if (!staticRecipes.containsKey(handler)) {
                    staticRecipes.put((RecipeHandler<?>)handler, new ArrayList());
                }
                if (recipes != null && !recipes.isEmpty()) {
                    ((Collection)staticRecipes.get(handler)).addAll(recipes);
                }
            });
        }
        staticRecipes.forEach((handler, recipes) -> this.postLoadHandler((RecipeHandler)handler, (Collection)recipes));
    }

    private void loadSimpleStaticRecipes(Map<RecipeHandler<?>, Collection<Recipe>> staticRecipes) {
        for (RecipeHandler<?> handler : this.recipeHandlers.values()) {
            try {
                Collection<?> recipes = handler.loadSimpleStaticRecipes();
                NEIRecipeHandlers.mod.getLogger().debug("The recipe handler \"" + handler.getUnlocalizedName() + "\" loaded " + (recipes != null ? recipes.size() : 0) + " simple static recipes");
                if (!staticRecipes.containsKey(handler)) {
                    staticRecipes.put(handler, new ArrayList(50));
                }
                if (recipes == null || recipes.isEmpty()) continue;
                staticRecipes.get(handler).addAll(recipes);
            }
            catch (Exception e) {
                NEIRecipeHandlers.mod.getLogger().error("Couldn't load simple static recipes of recipe handler \"" + handler.getUnlocalizedName() + "\"", (Throwable)e);
            }
        }
    }

    private void loadComplicatedStaticRecipes(int maxDepth, Map<RecipeHandler<? extends Recipe>, Collection<Recipe>> staticRecipes) {
        this.complicatedStaticRecipeIterations = (long)Math.pow(ItemList.items.size(), maxDepth);
        this.itemStackIteration(1, maxDepth, new ItemStack[maxDepth], staticRecipes);
    }

    private void itemStackIteration(int start, int end, ItemStack[] stackArray, Map<RecipeHandler<? extends Recipe>, Collection<Recipe>> staticRecipes) {
        ArrayList<Runnable> complicatedStaticRecipeLoadingTaskList = new ArrayList<Runnable>(300);
        Iterator iterator = ItemList.items.iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            stackArray[start - 1] = stack = (ItemStack)iterator.next();
            staticRecipes.forEach((handler, recipes) -> {
                Object recipe;
                if (handler.getComplicatedStaticRecipeDepth() >= start && (recipe = handler.loadComplicatedStaticRecipe(stackArray)) != null) {
                    recipes.add(recipe);
                }
            });
            if (start != end) {
                ItemStack[] clone = Arrays.copyOf(stackArray, end);
                complicatedStaticRecipeLoadingTaskList.add(() -> this.itemStackIteration(start + 1, end, clone, staticRecipes));
            }
            if (complicatedStaticRecipeLoadingTaskList.size() > 300) {
                this.executeTasks(complicatedStaticRecipeLoadingTaskList);
            }
            this.complicatedStaticRecipeIterationsCounter.incrementAndGet();
        }
        if (complicatedStaticRecipeLoadingTaskList.size() > 0) {
            this.executeTasks(complicatedStaticRecipeLoadingTaskList);
        }
        if (this.complicatedStaticRecipeIterationsCounter.get() >= this.complicatedStaticRecipeIterations) {
            this.complicatedStaticRecipeLoadingThreadPool.shutdown();
        }
    }

    private void executeTasks(Collection<Runnable> tasks) {
        ArrayList<Runnable> copy = new ArrayList<Runnable>(tasks);
        tasks.clear();
        this.complicatedStaticRecipeLoadingThreadPool.execute(() -> {
            try {
                for (Runnable runnable : copy) {
                    runnable.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void writeRecipesToCache() {
        if (NEIRecipeHandlers.mod.getConfig().isComplicatedStaticRecipeLoadingCacheEnabled()) {
            try (FileOutputStream out = new FileOutputStream(NEIRecipeHandlers.mod.getRecipeCache());){
                NBTTagCompound cacheRootTag = new NBTTagCompound();
                for (RecipeHandler<?> handler : this.recipeHandlers.values()) {
                    try {
                        RecipeHandlerCacheManager<?> cache;
                        if (handler.getCacheManager() == null || !(cache = handler.getCacheManager()).isCacheEnabled()) continue;
                        NBTTagCompound handlerTag = new NBTTagCompound();
                        NBTTagCompound headerTag = new NBTTagCompound();
                        NBTTagCompound contentTag = new NBTTagCompound();
                        cache.writeRecipesToCache(headerTag, contentTag);
                        cache.validateCache();
                        handlerTag.func_74782_a(RECIPE_HANDLER_HEADER_TAG_KEY, (NBTBase)headerTag);
                        handlerTag.func_74782_a(RECIPE_HANDLER_CONTENT_TAG_KEY, (NBTBase)contentTag);
                        cacheRootTag.func_74782_a(handler.getUnlocalizedName(), (NBTBase)handlerTag);
                        NEIRecipeHandlers.mod.getLogger().debug("The recipe handler \"" + handler.getUnlocalizedName() + "\" wrote data to the cache");
                    }
                    catch (Exception e) {
                        NEIRecipeHandlers.mod.getLogger().error("The recipe handler \"" + handler.getUnlocalizedName() + "\" couldn't write data to the cache: ", (Throwable)e);
                    }
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)cacheRootTag, (OutputStream)out);
            }
            catch (Exception e) {
                NEIRecipeHandlers.mod.getLogger().error("Couldn't write data to the cache: ", (Throwable)e);
            }
        }
    }

    private <T extends Recipe> void postLoadHandler(RecipeHandler<T> handler, Collection<T> recipes) {
        handler.onPostLoad(recipes);
    }

    public void refreshCache() {
        this.writeRecipesToCache();
    }

    public Map<String, RecipeHandler<?>> getRecipeHandlers() {
        return this.recipeHandlers;
    }
}

