/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider;

import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.api.ResourceHandler;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;

public class ResourceHandlerResourcePack
implements IResourcePack {
    private final Map<ResourceLocation, Supplier<InputStream>> resources = new HashMap<ResourceLocation, Supplier<InputStream>>();
    private final Map<ResourceLocation, Collection<Supplier<InputStream>>> langFileParts = new HashMap<ResourceLocation, Collection<Supplier<InputStream>>>();

    public ResourceHandlerResourcePack(Collection<ResourceHandler> handlers) {
        for (ResourceHandler handler : handlers) {
            Map<ResourceLocation, Supplier<InputStream>> resources = handler.getResources();
            if (resources == null) continue;
            for (ResourceLocation location : resources.keySet()) {
                if (this.resources.containsKey(location)) {
                    if (location.func_110623_a().endsWith(".lang")) {
                        if (!this.langFileParts.containsKey(location)) {
                            this.langFileParts.put(location, new ArrayList());
                            this.langFileParts.get(location).add(this.resources.get(location));
                        }
                        this.langFileParts.get(location).add(resources.get(location));
                        continue;
                    }
                    NEIRecipeHandlers.mod.getLogger().warn("The resource " + location.toString() + " was overridden by another resource handler");
                    continue;
                }
                this.resources.put(location, resources.get(location));
            }
            for (ResourceLocation location : this.langFileParts.keySet()) {
                Collection<Supplier<InputStream>> parts = this.langFileParts.get(location);
                ArrayList<Supplier<InputStream>> partsWithNewLineBetweenStreams = new ArrayList<Supplier<InputStream>>();
                for (Supplier<InputStream> part : parts) {
                    partsWithNewLineBetweenStreams.add(part);
                    partsWithNewLineBetweenStreams.add(() -> new ByteArrayInputStream("\n".getBytes()));
                }
                Supplier<InputStream> sequencedSupplier = () -> new SequenceInputStream(Collections.enumeration(partsWithNewLineBetweenStreams.stream().map(Supplier::get).collect(Collectors.toList())));
                this.resources.put(location, sequencedSupplier);
            }
        }
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        return this.func_110589_b(location) ? this.resources.get(location).get() : null;
    }

    public boolean func_110589_b(ResourceLocation location) {
        return this.resources.containsKey(location);
    }

    public Set<?> func_110587_b() {
        return Collections.singleton("neirecipehandlers");
    }

    public IMetadataSection func_135058_a(IMetadataSerializer serializer, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "NEI Recipe Handlers Resource Handler Resources";
    }
}

