/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.provider.recipeHandlers;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandlerConfiguration;
import craftedMods.recipes.api.RecipeHandlerCraftingHelper;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.VanillaCraftingTableRecipeHandlerSupport;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractCraftingHelper;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.CraftingGridRecipeHandler;
import craftedMods.recipes.base.ShapedRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class VanillaCraftingTableRecipeHandler
extends CraftingGridRecipeHandler {
    private final Collection<VanillaCraftingTableRecipeHandlerSupport> supportHandlers = new ArrayList<VanillaCraftingTableRecipeHandlerSupport>();
    private final VanillaCraftingTableRecipeHandlerCraftingHelper craftingHelper = new VanillaCraftingTableRecipeHandlerCraftingHelper();
    private final VanillaCraftingTableRecipeViewer recipeViewer = new VanillaCraftingTableRecipeViewer(this);

    public VanillaCraftingTableRecipeHandler(Collection<VanillaCraftingTableRecipeHandlerSupport> supportHandlers) {
        super("vanilla.craftingTable", () -> ((CraftingManager)CraftingManager.func_77594_a()).func_77592_b());
        this.supportHandlers.addAll(supportHandlers);
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"neiRecipeHandlers.handler.vanilla.craftingTable.name");
    }

    @Override
    public void onPreLoad(RecipeHandlerConfiguration config, Logger logger) {
        super.onPreLoad(config, logger);
        this.removeRecipeHandler("codechicken.nei.recipe.ShapedRecipeHandler");
        this.removeRecipeHandler("codechicken.nei.recipe.ShapelessRecipeHandler");
    }

    private void removeRecipeHandler(String recipeHandlerClass) {
        try {
            RecipeHandlerUtils.getInstance().removeNativeRecipeHandler(recipeHandlerClass);
        }
        catch (Exception e) {
            this.logger.error(String.format("Couldn't remove the native recipe handler \"%s\"", recipeHandlerClass));
        }
    }

    @Override
    protected void undefinedRecipeTypeFound(IRecipe recipe, Collection<AbstractRecipe> container) {
        for (VanillaCraftingTableRecipeHandlerSupport supportHandler : this.supportHandlers) {
            Pair<Collection<AbstractRecipe>, Boolean> result = supportHandler.undefinedRecipeTypeFound(recipe);
            if (result == null) continue;
            if (((Boolean)result.getRight()).booleanValue()) {
                return;
            }
            if (result.getLeft() == null || ((Collection)result.getLeft()).isEmpty()) continue;
            container.addAll((Collection)result.getLeft());
            return;
        }
        super.undefinedRecipeTypeFound(recipe, container);
    }

    @Override
    public Collection<AbstractRecipe> getDynamicCraftingRecipes(ItemStack result) {
        Collection<AbstractRecipe> ret = super.getDynamicCraftingRecipes(result);
        this.supportHandlers.forEach(handler -> ret.addAll(handler.getDynamicCraftingRecipes(result)));
        return ret;
    }

    @Override
    public Collection<AbstractRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        Collection<AbstractRecipe> ret = super.getDynamicUsageRecipes(ingredient);
        this.supportHandlers.forEach(handler -> ret.addAll(handler.getDynamicUsageRecipes(ingredient)));
        return ret;
    }

    @Override
    public RecipeHandlerCraftingHelper<AbstractRecipe> getCraftingHelper() {
        return this.craftingHelper;
    }

    @Override
    public AbstractRecipe loadComplicatedStaticRecipe(ItemStack ... stacks) {
        for (VanillaCraftingTableRecipeHandlerSupport supportHandler : this.supportHandlers) {
            AbstractRecipe recipe = supportHandler.loadComplicatedStaticRecipe(stacks);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getComplicatedStaticRecipeDepth() {
        return this.supportHandlers.parallelStream().map(handler -> handler.getComplicatedStaticRecipeDepth()).collect(Collectors.maxBy(Comparator.naturalOrder())).orElse(0);
    }

    @Override
    protected boolean isMineTweakerSupportEnabled() {
        return RecipeHandlerUtils.getInstance().hasMineTweaker();
    }

    @Override
    public int getDefaultOrder() {
        return 0;
    }

    @Override
    public RecipeHandlerRecipeViewer<AbstractRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public class VanillaCraftingTableRecipeViewer
    extends AbstractRecipeViewer<AbstractRecipe, VanillaCraftingTableRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public VanillaCraftingTableRecipeViewer(VanillaCraftingTableRecipeHandler handler) {
            super(handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(GuiCrafting.class);
        }

        @Override
        public Collection<AbstractRecipe> getAllRecipes() {
            return ((VanillaCraftingTableRecipeHandler)this.handler).isMineTweakerSupportEnabled() ? ((VanillaCraftingTableRecipeHandler)this.handler).loadRecipes() : ((VanillaCraftingTableRecipeHandler)this.handler).getStaticRecipes();
        }

        @Override
        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }
    }

    public class VanillaCraftingTableRecipeHandlerCraftingHelper
    extends AbstractCraftingHelper<AbstractRecipe> {
        @Override
        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses(AbstractRecipe recipe) {
            return this.isRecipe2x2(recipe) ? Arrays.asList(GuiInventory.class, GuiCrafting.class) : Arrays.asList(GuiCrafting.class);
        }

        @Override
        public int getOffsetX(Class<? extends GuiContainer> guiClass, AbstractRecipe recipe) {
            return guiClass == GuiInventory.class ? 63 : 5;
        }

        @Override
        public int getOffsetY(Class<? extends GuiContainer> guiClass, AbstractRecipe recipe) {
            return guiClass == GuiInventory.class ? 20 : 11;
        }

        @Override
        public boolean matches(ItemStack stack1, ItemStack stack2) {
            return super.matches(stack1, stack2) && VanillaCraftingTableRecipeHandler.this.supportHandlers.parallelStream().map(handler -> handler.matches(stack1, stack2)).reduce(Boolean::logicalAnd).orElse(true) != false;
        }

        private boolean isRecipe2x2(AbstractRecipe recipe) {
            boolean ret;
            boolean bl = ret = recipe.getRecipeItems(EnumRecipeItemRole.INGREDIENT).size() <= 4;
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                ret = shapedRecipe.getWidth() <= 2 && shapedRecipe.getHeight() <= 2;
            }
            return ret;
        }
    }
}

