/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.utils;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.relauncher.ReflectionHelper;
import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.ItemStackComparisonHandler;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.ItemStackSet;
import craftedMods.recipes.base.RecipeItemSlotImpl;
import craftedMods.recipes.utils.RemoteVersion;
import craftedMods.recipes.utils.VersionChecker;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class NEIRecipeHandlersUtils {
    public static ItemStackSet generatePermutations(Collection<ItemStack> stacks) {
        ItemStackSet permutations = ItemStackSet.create(new ItemStack[0]);
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            List perms = ItemList.itemMap.get((Object)stack.func_77973_b());
            if (stack.func_77960_j() == Short.MAX_VALUE && perms != null && !perms.isEmpty()) {
                permutations.addAll(perms);
                continue;
            }
            permutations.add(stack);
        }
        return permutations;
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        Boolean handlerResult = null;
        for (ItemStackComparisonHandler handler : NEIRecipeHandlers.mod.getNEIIntegrationManager().getItemStackComparisonHandlers()) {
            Boolean result = handler.areStacksOfSameType(stack1, stack2);
            if (result == null) continue;
            if (handlerResult == null) {
                handlerResult = result;
                continue;
            }
            if (handlerResult == null || result == handlerResult) continue;
            handlerResult = null;
            break;
        }
        return handlerResult == null ? NEIServerUtils.areStacksSameType((ItemStack)stack1, (ItemStack)stack2) : handlerResult;
    }

    public static boolean areStacksSameTypeForCrafting(ItemStack stack1, ItemStack stack2) {
        Boolean handlerResult = null;
        for (ItemStackComparisonHandler handler : NEIRecipeHandlers.mod.getNEIIntegrationManager().getItemStackComparisonHandlers()) {
            Boolean result = handler.areStacksOfSameTypeForCrafting(stack1, stack2);
            if (result == null) continue;
            if (handlerResult == null) {
                handlerResult = result;
                continue;
            }
            if (handlerResult == null || result == handlerResult) continue;
            handlerResult = null;
            break;
        }
        return handlerResult == null ? NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack1, (ItemStack)stack2) : handlerResult;
    }

    public static EnumRecipeItemRole createRecipeItemRole(String name) {
        return (EnumRecipeItemRole)EnumHelper.addEnum(EnumRecipeItemRole.class, (String)name, (Object[])new Object[0]);
    }

    public static ItemStack[] extractRecipeItems(Object container) {
        ItemStack[] ret = null;
        if (container instanceof String) {
            ArrayList stacks = OreDictionary.getOres((String)((String)container));
            ret = stacks.toArray(new ItemStack[stacks.size()]);
        } else {
            ret = container instanceof Item ? new ItemStack[]{new ItemStack((Item)container)} : (container instanceof Block ? new ItemStack[]{new ItemStack((Block)container)} : NEIServerUtils.extractRecipeItems((Object)container));
        }
        if (ret != null) {
            for (int i = 0; i < ret.length; ++i) {
                ItemStack stack = ret[i];
                if (stack != null && stack.func_77973_b() != null) continue;
                ret[i] = new ItemStack((Block)Blocks.field_150480_ab);
            }
        }
        return ret;
    }

    public static List<ItemStack> getItemList() {
        return ItemList.items;
    }

    public static String[] getRecipeHandlerCategories(String unlocalizedName) {
        String[] categories;
        String[] cats = unlocalizedName.split("\\.");
        if (cats.length > 1) {
            categories = new String[cats.length - 1];
            for (int i = 0; i < cats.length - 1; ++i) {
                categories[i] = cats[i];
            }
        } else {
            categories = new String[]{};
        }
        return categories;
    }

    public static Collection<ItemStack> readItemStackListFromNBT(NBTTagCompound compound, String tagName) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (compound.func_74764_b(tagName)) {
            NBTTagList list = compound.func_150295_c(tagName, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack stack = NEIRecipeHandlersUtils.readItemStackFromNBT(list.func_150305_b(i));
                if (stack == null) continue;
                ret.add(stack);
            }
        }
        return ret;
    }

    public static void writeItemStackListToNBT(NBTTagCompound compound, String tagName, Collection<? extends ItemStack> stacks) {
        NBTTagList list = new NBTTagList();
        for (ItemStack itemStack : stacks) {
            NBTTagCompound stackTag = new NBTTagCompound();
            NEIRecipeHandlersUtils.writeItemStackToNBT(itemStack, stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a(tagName, (NBTBase)list);
    }

    public static List<RecipeItemSlot> offset(List<RecipeItemSlot> slotsList, int xOffset, int yOffset) {
        ArrayList<RecipeItemSlot> ret = new ArrayList<RecipeItemSlot>();
        for (RecipeItemSlot slot : slotsList) {
            ret.add(slot == null ? null : new RecipeItemSlotImpl(slot.getX() + xOffset, slot.getY() + yOffset));
        }
        return ret;
    }

    public static boolean registerDefaultResourcePack(IResourcePack pack) {
        return ((List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"})).add(pack);
    }

    public static <T> Collection<T> discoverRegisteredHandlers(Map<Class<? extends Annotation>, Map<Class<?>, Set<Class<?>>>> discoveredClasses, Class<T> handlerClass) {
        ArrayList handlerInstanceCollection = new ArrayList();
        Set<Class<?>> discoveredHandlers = discoveredClasses.get(RegisteredHandler.class).get(handlerClass);
        NEIRecipeHandlers.mod.getLogger().info(String.format("Found %d handlers of type \"%s\" in the classpath", discoveredHandlers.size(), handlerClass.getSimpleName()));
        discoveredHandlers.forEach(clazz -> {
            try {
                Class handler = clazz;
                if (handler.getAnnotation(RegisteredHandler.class).isEnabled()) {
                    handlerInstanceCollection.add(handler.newInstance());
                    NEIRecipeHandlers.mod.getLogger().debug(String.format("Registered the handler \"%s\" of type \"%s\"", handler.getName(), handlerClass.getSimpleName()));
                } else {
                    NEIRecipeHandlers.mod.getLogger().info(String.format("The handler \"%s\" of type \"%s\" was disabled by the author", handler.getName(), handlerClass.getSimpleName()));
                }
            }
            catch (Exception e) {
                NEIRecipeHandlers.mod.getLogger().error("Couldn't create an instance of class \"" + clazz.getName() + "\"", (Throwable)e);
            }
        });
        return handlerInstanceCollection;
    }

    public static IChatComponent getVersionNotificationChatText(String handlerName, RemoteVersion version) {
        IChatComponent part1 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part1", new Object[]{handlerName}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN));
        IChatComponent part2 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part2", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE));
        IChatComponent part3 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part3", new Object[]{version.getRemoteVersion().toString()}).func_150255_a(version.getDownloadURL() != null ? new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, version.getDownloadURL().toString())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"neiRecipeHandlers.versionChecker.notification.chat.version.tooltip", (Object[])new Object[0])))) : new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW));
        part1.func_150257_a(part2).func_150257_a(part3);
        if (version.getChangelogURL() != null) {
            IChatComponent part4 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part4", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE));
            IChatComponent part5 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part5", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, version.getChangelogURL().toString())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"neiRecipeHandlers.versionChecker.notification.chat.changelog.tooltip", (Object[])new Object[0])))));
            IChatComponent part6 = new ChatComponentTranslation("neiRecipeHandlers.versionChecker.notification.chat.part6", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE));
            part1.func_150257_a(part4).func_150257_a(part5).func_150257_a(part6);
        }
        return part1;
    }

    public static boolean doVersionCheck(String handlerName, VersionChecker versionChecker, Logger logger) {
        boolean ret = false;
        try {
            logger.debug(String.format("Starting version check for %s...", handlerName));
            versionChecker.checkVersion();
            if (versionChecker.getRemoteVersion() != null) {
                logger.info(String.format("Found a remote version for %s: %s (%s version)", handlerName, versionChecker.getRemoteVersion().getRemoteVersion().toString(), versionChecker.compareRemoteVersion().toDisplayString()));
                ret = true;
            }
        }
        catch (Exception e) {
            logger.error(String.format("Version check failed for %s", handlerName), (Throwable)e);
        }
        return ret;
    }

    public static void writeItemStackToNBT(ItemStack stack, NBTTagCompound compound) {
        compound.func_74778_a("Identifier", Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        compound.func_74768_a("Count", stack.field_77994_a);
        compound.func_74768_a("Damage", stack.func_77960_j());
        if (stack.func_77978_p() != null) {
            compound.func_74782_a("Tag", (NBTBase)stack.func_77978_p());
        }
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound compound) {
        ItemStack ret = null;
        Item item = (Item)Item.field_150901_e.func_82594_a(compound.func_74779_i("Identifier"));
        if (item != null) {
            int stackSize = compound.func_74762_e("Count");
            int itemDamage = compound.func_74762_e("Damage");
            if (itemDamage < 0) {
                itemDamage = 0;
            }
            NBTTagCompound tag = compound.func_150297_b("Tag", 10) ? compound.func_74775_l("Tag") : null;
            ret = new ItemStack(item, stackSize, itemDamage);
            if (tag != null) {
                ret.func_77982_d(tag);
            }
        }
        return ret;
    }
}

