/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.recipes.utils;

import craftedMods.recipes.NEIRecipeHandlers;
import craftedMods.recipes.utils.RemoteVersion;
import craftedMods.utils.SemanticVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class VersionChecker {
    private String versionFileURL;
    private SemanticVersion localVersion = null;
    private RemoteVersion remoteVersion = null;

    public VersionChecker(String versionFileURL, SemanticVersion localVersion) throws MalformedURLException {
        this.localVersion = localVersion;
        this.versionFileURL = versionFileURL;
    }

    public EnumVersionComparison checkVersion() {
        if (this.ping()) {
            try {
                this.remoteVersion = this.parseVersionFile(this.downloadVersionFile());
            }
            catch (IOException e) {
                NEIRecipeHandlers.mod.getLogger().error(String.format("Couldn't download the version file \"%s\"", this.versionFileURL.toString()), (Throwable)e);
            }
            catch (Exception e) {
                NEIRecipeHandlers.mod.getLogger().error(String.format("Couldn't parse the contents of the version file \"%s\"", this.versionFileURL.toString()), (Throwable)e);
            }
        }
        return this.compareRemoteVersion();
    }

    private boolean ping() {
        if (this.versionFileURL != null) {
            try {
                URLConnection conn = new URL(this.versionFileURL).openConnection();
                conn.setConnectTimeout(2000);
                conn.connect();
                return true;
            }
            catch (MalformedURLException e) {
                NEIRecipeHandlers.mod.getLogger().error(String.format("The URL of the version file \"%s\" isn't valid", this.versionFileURL));
            }
            catch (IOException e) {
                NEIRecipeHandlers.mod.getLogger().error(String.format("Cannot connect to the version file \"%s\"", this.versionFileURL.toString()), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private String downloadVersionFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RemoteVersion parseVersionFile(String versionString) throws MalformedURLException {
        if (versionString != null) {
            SemanticVersion remoteVersion = null;
            URL downloadURL = null;
            URL changelogURL = null;
            String[] parts = versionString.split("\\|");
            remoteVersion = SemanticVersion.of(parts[0]);
            if (parts.length >= 1 && !parts[1].trim().isEmpty()) {
                downloadURL = new URL(parts[1]);
            }
            if (parts.length >= 2 && !parts[2].trim().isEmpty()) {
                changelogURL = new URL(parts[2]);
            }
            return new RemoteVersion(remoteVersion, downloadURL, changelogURL);
        }
        return null;
    }

    public RemoteVersion getRemoteVersion() {
        return this.remoteVersion;
    }

    public EnumVersionComparison compareRemoteVersion() {
        int comp;
        int n = comp = this.remoteVersion != null ? this.localVersion.compareTo(this.remoteVersion.getRemoteVersion()) : 0;
        if (comp == 0) {
            return EnumVersionComparison.CURRENT;
        }
        if (comp < 0) {
            return EnumVersionComparison.NEWER;
        }
        return EnumVersionComparison.OLDER;
    }

    public static enum EnumVersionComparison {
        CURRENT,
        OLDER,
        NEWER;


        public String toDisplayString() {
            return this.name().toLowerCase();
        }
    }
}

