/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.storage.tank;

import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Fluids;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.network.GuiSynced;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityTank
extends TileEntityInventory
implements IHasGui {
    protected final Fluids fluidsComponent = this.addComponent(new Fluids(this));
    @GuiSynced
    protected final Fluids.InternalFluidTank contents;

    public TileEntityTank(int bucketMultiplier) {
        this.contents = this.fluidsComponent.addTank("contents", 1000 * bucketMultiplier);
    }

    @Override
    protected List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (!this.func_145831_w().field_72995_K) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            this.contents.readFromNBT(nbt);
        }
    }

    @Override
    protected ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(drop);
        if (this.contents.getFluidAmount() > 0) {
            this.contents.writeToNBT(nbt);
        }
        return drop;
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack inHand = StackUtil.get(player, hand);
        if (LiquidUtil.isFluidContainer(inHand)) {
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.fluidsComponent.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> info, ITooltipFlag advanced) {
        info.add("Capacity: " + this.contents.getCapacity() + " mB");
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(stack);
        if (!nbtTagCompound.func_74764_b("Empty")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTagCompound);
            if (fluidStack == null) {
                info.add("Empty");
            } else {
                info.add(fluidStack.getLocalizedName());
                info.add("Amount: " + fluidStack.amount + " mB");
                info.add("Type: " + (fluidStack.getFluid().isGaseous() ? "Gas" : "Liquid"));
            }
        } else {
            info.add("Empty");
        }
    }

    @Override
    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185852_e;
    }

    public ContainerBase<? extends TileEntityTank> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }
}

