/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.core;

import java.io.File;
import java.util.HashMap;
import me.ichun.mods.hats.client.core.EventHandlerClient;
import me.ichun.mods.hats.client.gui.GuiHatSelection;
import me.ichun.mods.hats.client.render.RenderHat;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.hats.common.core.ProxyCommon;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.hats.common.thread.ThreadHatsReader;
import me.ichun.mods.ichunutil.client.module.tabula.model.ModelTabula;
import me.ichun.mods.ichunutil.common.module.tabula.formats.ImportList;
import me.ichun.mods.ichunutil.common.module.tabula.project.ProjectInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ProxyClient
extends ProxyCommon {
    public static HashMap<String, ModelTabula> models = new HashMap();

    @Override
    public void preInitMod() {
        super.preInitMod();
        Hats.eventHandlerClient = new EventHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)Hats.eventHandlerClient);
        RenderingRegistry.registerEntityRenderingHandler(EntityHat.class, (IRenderFactory)new RenderHat.RenderFactory());
    }

    @Override
    public void getHatsAndOpenGui() {
        new ThreadHatsReader(HatHandler.hatsFolder, false, true).start();
    }

    @Override
    public void clearAllHats() {
        super.clearAllHats();
        models.clear();
    }

    @Override
    public void remap(String duplicate, String original) {
        super.remap(duplicate, original);
        models.put(duplicate, models.get(original));
    }

    @Override
    public void openHatsGui() {
        FMLClientHandler.instance().displayGuiScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (GuiScreen)new GuiHatSelection((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    @Override
    public void loadHatFile(File file) {
        ProjectInfo info;
        if (ImportList.isFileSupported((File)file) && (info = ImportList.createProjectFromFile((File)file)) != null) {
            String hatName = file.getName().substring(0, file.getName().length() - 4).toLowerCase();
            HatHandler.getActualHatNamesMap().put(file, hatName);
            models.put(hatName, new ModelTabula(info));
        }
    }
}

