/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminermodsupport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import portablejim.veinminer.api.IMCMessage;
import portablejim.veinminer.api.Permission;
import portablejim.veinminer.api.VeinminerHarvestFailedCheck;
import portablejim.veinminer.api.VeinminerPostUseTool;
import portablejim.veinminermodsupport.Lists;

@Mod(modid="veinminermodsupport", name="VeinMiner Mod Support", acceptedMinecraftVersions="[1.12,1.13)")
public class VeinMinerModSupport {
    private boolean debugMode = false;
    @Mod.Instance(value="veinminermodsupport")
    public static VeinMinerModSupport instance;
    private boolean forceConsumerAvailable;
    private static final String[] FALSETOOLS_DEFAULT;
    private Set<String> falseTools = new LinkedHashSet<String>();
    private static final String[] OVERRIDE_BLACKLIST_DEFAULT;
    private Set<String> overrideBlacklist = new LinkedHashSet<String>();
    private static final String CONFIG_AUTODETECT = "autodetect";
    private static final String CONFIG_AUTODETECT_COMMENT = "Autodetect items and blocks during game start-up.";
    private boolean AUTODETECT_TOOLS_TOGGLE;
    private static final boolean AUTODETECT_TOOLS_TOGGLE_DEFAULT = true;
    private static final String AUTODETECT_TOOLS_TOGGLE_CONFIGNAME = "autodetect.tools";
    private static final String AUTODETECT_TOOLS_TOGGLE_DESCRIPTION = "Autodetect tools on starting the game, adding the names to the list.";
    private static final String[] BADTOOLS_DEFAULT;
    private Set<String> badTools = new LinkedHashSet<String>();

    @NetworkCheckHandler
    public boolean checkClientModVersion(Map<String, String> mods, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "veinminer");
        File loadedFile = new File(configDir, "modSupport.cfg");
        try {
            Configuration config = new Configuration(loadedFile);
            config.load();
            config.addCustomCategoryComment(CONFIG_AUTODETECT, CONFIG_AUTODETECT_COMMENT);
            this.AUTODETECT_TOOLS_TOGGLE = config.get(CONFIG_AUTODETECT, AUTODETECT_TOOLS_TOGGLE_CONFIGNAME, true, AUTODETECT_TOOLS_TOGGLE_DESCRIPTION).getBoolean(true);
            config.setCategoryComment("advanced", "You probably don't want to touch these");
            String[] badTools_array = config.getStringList("bad_tools", "advanced", BADTOOLS_DEFAULT, "Tools that break veinminer.");
            String[] falseTools_array = config.getStringList("special_snowflake_tools", "advanced", FALSETOOLS_DEFAULT, "Tools that need to be treated as special snowflakes\n");
            String[] overrideBlacklist_array = config.getStringList("override_blacklist_blocks", "advanced", OVERRIDE_BLACKLIST_DEFAULT, "Blocks to not override success for\n");
            this.falseTools = new LinkedHashSet<String>(Arrays.asList(falseTools_array));
            this.overrideBlacklist = new LinkedHashSet<String>(Arrays.asList(overrideBlacklist_array));
            this.badTools = new LinkedHashSet<String>(Arrays.asList(badTools_array));
            config.save();
        }
        catch (Exception e) {
            event.getModLog().error("Error writing config file");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        String fileName;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModContainer thisMod = (ModContainer)Loader.instance().getIndexedModList().get("veinminermodsupport");
        if (thisMod != null && ((fileName = thisMod.getSource().getName()).contains("-dev") || !fileName.contains(".jar"))) {
            this.debugMode = true;
            this.devLog("DEV VERSION");
        }
        this.forceConsumerAvailable = false;
        if (this.AUTODETECT_TOOLS_TOGGLE) {
            this.addTools();
        }
    }

    private void addTools() {
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.devLog("Tinkers support loaded");
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            this.devLog("Ex Nihilo support loaded");
            IMCMessage.addToolType("crook", "Crook", "exnihilo:crook");
            IMCMessage.addToolType("hammer", "Hammer", "exnihilo:hammer_stone");
        } else if (Loader.isModLoaded((String)"excompressum")) {
            IMCMessage.addToolType("hammer", "Hammer", "excompressum:chickenStick");
        }
        this.addAllTool(Lists.Tools.shears_array, "shears");
        this.addAllTool(Lists.Tools.sickle_array, "hoe");
        this.addAllTool(Lists.Tools.hammer_array, "pickaxe");
        this.addAllTool(Lists.Tools.drill_array, "pickaxe");
        this.addAllTool(Lists.Tools.drill_array, "shovel");
        this.addAllTool(Lists.Tools.pickaxe_array, "pickaxe");
        this.addAllTool(Lists.Tools.shovel_array, "shovel");
        this.addAllTool(Lists.Tools.hoe_array, "hoe");
        this.addAllTool(Lists.Tools.axe_array, "axe");
        this.addAllTool(Lists.Tools.multitool_array, "axe");
        this.addAllTool(Lists.Tools.multitool_array, "shovel");
        this.addAllTool(Lists.Tools.multitool_array, "pickaxe");
        this.addAllTool(Lists.Tools.multitool_array, "axe");
        this.addAllTool(Lists.Tools.nihilo_hammer_array, "hammer");
        this.addAllTool(Lists.Tools.nihilo_crook_array, "crook");
        this.addAllBlock(Lists.Blocks.nihilo_hammer_array, "hammer");
        this.addAllBlock(Lists.Blocks.nihilo_crook_array, "crook");
    }

    private void addAllTool(String[] list, String category) {
        for (String item : list) {
            ResourceLocation id = new ResourceLocation(item);
            if (!Loader.isModLoaded((String)id.func_110624_b())) continue;
            IMCMessage.addTool(category, item);
        }
    }

    private void addAllBlock(String[] list, String category) {
        for (String item : list) {
            ResourceLocation id = new ResourceLocation(item);
            if (!Loader.isModLoaded((String)id.func_110624_b())) continue;
            IMCMessage.addBlock(category, item);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Testing for dartcraft classes and functions.");
            try {
                Method obj = Class.forName("bluedart.api.IForceConsumer").getMethod("attemptRepair", ItemStack.class);
                this.forceConsumerAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.devLog("Failed to find Dartcraft force consumer. Disabling repair support");
            }
            catch (NoSuchMethodException e) {
                this.devLog("Failed to find Dartcraft force consumer function. Disabling repair support");
            }
        }
    }

    private void devLog(String string) {
        if (this.debugMode) {
            FMLLog.getLogger().info("[veinminermodsupport] " + string);
        }
    }

    @SubscribeEvent
    public void banBadTools(VeinminerHarvestFailedCheck event) {
        String item_name;
        ItemStack currentEquipped = event.player.func_184614_ca();
        if (currentEquipped != null && currentEquipped.func_77973_b() != null && Item.field_150901_e.func_177774_c((Object)currentEquipped.func_77973_b()) != null && this.badTools.contains(item_name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)currentEquipped.func_77973_b())).toString())) {
            event.allowContinue = Permission.FORCE_DENY;
        }
    }

    @SubscribeEvent
    public void makeToolsWork(VeinminerHarvestFailedCheck event) {
        String item_name;
        ItemStack currentEquipped = event.player.func_184614_ca();
        if (currentEquipped == null) {
            return;
        }
        if (event.allowContinue == Permission.DENY) {
            if (this.overrideBlacklist.contains(event.blockName)) {
                this.devLog("Denied with block: " + event.blockName);
                event.allowContinue = Permission.FORCE_DENY;
            } else {
                this.devLog("Not Denied with block: " + event.blockName);
            }
        }
        Item currentEquippedItem = event.player.func_184614_ca().func_77973_b();
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.devLog("Tinkers Construct detected");
            this.tinkersConstructToolEvent(event);
        }
        if (event.allowContinue == Permission.DENY && this.falseTools.contains(item_name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)currentEquipped.func_77973_b())).toString())) {
            this.devLog("Allowed start with " + item_name);
            event.allowContinue = Permission.ALLOW;
        }
        if (Loader.isModLoaded((String)"exnihilo")) {
            Class<?> hammerBase;
            this.devLog("Ex Nihilo detected");
            if (currentEquippedItem != null) {
                if (currentEquipped.getClass() != null && currentEquipped.getClass().getCanonicalName() != null && currentEquippedItem.getClass().getCanonicalName().startsWith("exnihilo.items.hammers") && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed hammer start");
                    event.allowContinue = Permission.ALLOW;
                } else {
                    this.devLog(currentEquippedItem.getClass().getCanonicalName());
                }
                Block testLeaves = Block.func_149684_b((String)event.blockName);
                if (Block.func_149684_b((String)event.blockName).isLeaves(testLeaves.func_176203_a(event.blockMetadata), (IBlockAccess)event.player.func_130014_f_(), event.player.func_180425_c()) && event.allowContinue == Permission.DENY) {
                    String item_name2 = currentEquippedItem.getRegistryName().toString();
                    if ("exnihilo:crook".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                    if ("exnihilo:crook_bone".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                    if ("exastris:crook_rf".equals(item_name2)) {
                        event.allowContinue = Permission.ALLOW;
                    }
                }
            }
            try {
                hammerBase = Class.forName("exnihilo.items.hammers.ItemHammerBase");
                if (currentEquippedItem != null && hammerBase.isAssignableFrom(currentEquippedItem.getClass()) && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed generic Ex Nihilo hammer start");
                    event.allowContinue = Permission.ALLOW;
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Ex Nihilo generic hammer support failed.");
            }
            try {
                hammerBase = Class.forName("ExAstris.Item.ItemHammerRF");
                if (currentEquippedItem != null && hammerBase.isAssignableFrom(currentEquippedItem.getClass()) && event.allowContinue == Permission.DENY) {
                    this.devLog("Allowed Ex Astris hammer start");
                    event.allowContinue = Permission.ALLOW;
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Ex Astris hammer support failed.");
            }
        }
    }

    private void tinkersConstructToolEvent(VeinminerHarvestFailedCheck event) {
        ItemStack currentItem = event.player.func_184614_ca();
        if (currentItem == null) {
            this.devLog("ERROR: Item is null");
            return;
        }
        if (!currentItem.func_77942_o()) {
            this.devLog("ERROR: No NBT data");
            return;
        }
        NBTTagCompound toolTags = currentItem.func_77978_p().func_74775_l("Stats");
        if (toolTags == null || toolTags.func_82582_d()) {
            this.devLog("ERROR: Not Tinkers Construct Tool");
            return;
        }
        Block block = Block.func_149684_b((String)event.blockName);
        if (block == null) {
            this.devLog("ERROR: Block id wrong.");
            return;
        }
        this.devLog("Allowing event");
        if (event.allowContinue == Permission.DENY) {
            event.allowContinue = Permission.ALLOW;
        }
    }

    @SubscribeEvent
    public void fixFalseNegatives(VeinminerHarvestFailedCheck event) {
        if (event.allowContinue == Permission.DENY && "IC2:blockRubWood".equals(event.blockName)) {
            event.allowContinue = Permission.ALLOW;
        }
    }

    @SubscribeEvent
    public void applyForce(VeinminerPostUseTool event) {
        ItemStack currentEquippedItemStack = event.player.func_184614_ca();
        if (this.forceConsumerAvailable && currentEquippedItemStack != null && Loader.isModLoaded((String)"DartCraft")) {
            this.devLog("Reflecting on Dartcraft run repair method.");
            try {
                Class<?> IForceConsumer = Class.forName("bluedart.api.IForceConsumer");
                if (IForceConsumer != null && IForceConsumer.isInstance(currentEquippedItemStack.func_77973_b())) {
                    Method attemptRepair = IForceConsumer.getMethod("attemptRepair", ItemStack.class);
                    attemptRepair.invoke((Object)currentEquippedItemStack.func_77973_b(), currentEquippedItemStack);
                    this.devLog("Repairing dartcraft force consumer");
                }
            }
            catch (ClassNotFoundException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class.");
                this.forceConsumerAvailable = false;
            }
            catch (NoSuchMethodException e) {
                this.devLog("Strange, I thought we already found the Dartcraft class and correct method.");
                this.forceConsumerAvailable = false;
            }
            catch (InvocationTargetException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a InvocationTargetException.");
                this.forceConsumerAvailable = false;
            }
            catch (IllegalAccessException e) {
                this.devLog("Trying to repair Dartcraft tools didn't work. It threw a IllegalAccessException.");
                this.forceConsumerAvailable = false;
            }
        }
    }

    static {
        FALSETOOLS_DEFAULT = new String[]{"excompressum:chicken_stick", "excompressum:compressed_hammer_wood", "excompressum:compressed_hammer_stone", "excompressum:compressed_hammer_iron", "excompressum:compressed_hammer_gold", "excompressum:compressed_hammer_diamond", "excompressum:double_compressed_diamond_hammer", "excompressum:compressed_crook", "redstonearsenal:tool.axe_flux", "redstonearsenal:tool.battlewrench_flux", "redstonearsenal:tool.hammer_flux", "redstonearsenal:tool.pickaxe_flux", "redstonearsenal:tool.shovel_flux", "redstonearsenal:tool.sickle_flux", "redstonearsenal:tool.sword_flux", "actuallyadditions:item_drill"};
        OVERRIDE_BLACKLIST_DEFAULT = new String[]{"EnderIO:blockConduitBundle"};
        BADTOOLS_DEFAULT = new String[0];
    }
}

