/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.renderer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;

public class RenderProjectileBase<T extends EntityProjectileBase>
extends Render<T> {
    protected RenderProjectileBase(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(@Nonnull T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        ITinkerProjectile handler = ((EntityProjectileBase)((Object)entity)).getCapability(CapabilityTinkerProjectile.PROJECTILE_CAPABILITY, null);
        if (handler == null) {
            return;
        }
        ItemStack itemStack = handler.getItemStack();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.customRendering(entity, x, y, z, entityYaw, partialTicks);
        float f11 = (float)((EntityProjectileBase)((Object)entity)).field_70249_b - partialTicks;
        if (f11 > 0.0f) {
            float f12 = -MathHelper.func_76126_a((float)(f11 * 3.0f)) * f11;
            GL11.glRotatef((float)f12, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.field_76990_c == null || this.field_76990_c.field_78724_e == null) {
            return;
        }
        this.field_76990_c.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        if (!itemStack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_181564_a(itemStack, ItemCameraTransforms.TransformType.NONE);
        } else {
            ItemStack dummy = new ItemStack(Items.field_151055_y);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(dummy, Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a());
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    public void customRendering(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glRotatef((float)((EntityProjectileBase)((Object)entity)).field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((EntityProjectileBase)((Object)entity)).field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        if (((EntityProjectileBase)((Object)entity)).field_70254_i) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-((EntityProjectileBase)((Object)entity)).getStuckDepth()));
        }
        this.customCustomRendering(entity, x, y, z, entityYaw, partialTicks);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    protected void customCustomRendering(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull T entity) {
        return TextureMap.field_174945_f;
    }

    public static <T extends EntityProjectileBase, U extends Render<? super T>> IRenderFactory<T> getFactory(Class<U> clazz) {
        try {
            Constructor constr = clazz.getDeclaredConstructor(RenderManager.class);
            return manager -> RenderProjectileBase.getRender(constr, manager);
        }
        catch (NoSuchMethodException e) {
            TConstruct.log.error((Object)e);
            return null;
        }
    }

    protected static <T extends EntityProjectileBase> Render<? super T> getRender(Constructor<? extends Render<? super T>> constr, RenderManager manager) {
        try {
            return constr.newInstance(manager);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            TConstruct.log.error((Object)e);
            return null;
        }
    }
}

