/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.recipes;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;

public interface IRefineryRecipeManager {
    public IHeatableRecipe createHeatingRecipe(FluidStack var1, FluidStack var2, int var3, int var4);

    default public IHeatableRecipe addHeatableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
        return this.getHeatableRegistry().addRecipe(this.createHeatingRecipe(in, out, heatFrom, heatTo));
    }

    public ICoolableRecipe createCoolableRecipe(FluidStack var1, FluidStack var2, int var3, int var4);

    default public ICoolableRecipe addCoolableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
        return this.getCoolableRegistry().addRecipe(this.createCoolableRecipe(in, out, heatFrom, heatTo));
    }

    public IDistillationRecipe createDistillationRecipe(FluidStack var1, FluidStack var2, FluidStack var3, long var4);

    default public IDistillationRecipe addDistillationRecipe(FluidStack in, FluidStack outGas, FluidStack outLiquid, long powerRequired) {
        return this.getDistillationRegistry().addRecipe(this.createDistillationRecipe(in, outGas, outLiquid, powerRequired));
    }

    public IRefineryRegistry<IHeatableRecipe> getHeatableRegistry();

    public IRefineryRegistry<ICoolableRecipe> getCoolableRegistry();

    public IRefineryRegistry<IDistillationRecipe> getDistillationRegistry();

    public static interface IDistillationRecipe
    extends IRefineryRecipe {
        public long powerRequired();

        public FluidStack outGas();

        public FluidStack outLiquid();
    }

    public static interface ICoolableRecipe
    extends IHeatExchangerRecipe {
    }

    public static interface IHeatableRecipe
    extends IHeatExchangerRecipe {
    }

    public static interface IHeatExchangerRecipe
    extends IRefineryRecipe {
        @Nullable
        public FluidStack out();

        public int heatFrom();

        public int heatTo();
    }

    public static interface IRefineryRecipe {
        public FluidStack in();
    }

    public static interface IRefineryRegistry<R extends IRefineryRecipe> {
        public Stream<R> getRecipes(Predicate<R> var1);

        public Collection<R> getAllRecipes();

        @Nullable
        public R getRecipeForInput(@Nullable FluidStack var1);

        public Collection<R> removeRecipes(Predicate<R> var1);

        public R addRecipe(R var1);
    }
}

