/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.items.IList;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class TriggerInventory
extends BCStatement
implements ITriggerExternal {
    public State state;

    public TriggerInventory(State state) {
        super("buildcraft:inventory." + state.name().toLowerCase(Locale.ROOT), "buildcraft.inventory." + state.name().toLowerCase(Locale.ROOT));
        this.state = state;
    }

    @Override
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCCoreSprites.TRIGGER_INVENTORY.get((Object)this.state);
    }

    @Override
    public int maxParameters() {
        return this.state == State.CONTAINS || this.state == State.SPACE ? 1 : 0;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.inventory." + this.state.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer container, IStatementParameter[] parameters) {
        IItemHandler handler;
        ItemStack searchedStack = StackUtil.EMPTY;
        if (parameters != null && parameters.length >= 1 && parameters[0] != null) {
            searchedStack = parameters[0].getItemStack();
        }
        if ((handler = (IItemHandler)tile.getCapability(CapUtil.CAP_ITEMS, side.func_176734_d())) != null) {
            boolean hasSlots = false;
            boolean foundItems = false;
            boolean foundSpace = false;
            for (int i = 0; i < handler.getSlots(); ++i) {
                hasSlots = true;
                ItemStack stack = handler.getStackInSlot(i);
                foundItems |= !stack.func_190926_b() && (searchedStack.func_190926_b() || StackUtil.canStacksOrListsMerge(stack, searchedStack));
                foundSpace |= (stack.func_190926_b() || StackUtil.canStacksOrListsMerge(stack, searchedStack) && stack.func_190916_E() < stack.func_77976_d()) && (searchedStack.func_190926_b() || searchedStack.func_77973_b() instanceof IList || handler.insertItem(i, searchedStack, true).func_190926_b());
            }
            if (!hasSlots) {
                return false;
            }
            switch (this.state) {
                case EMPTY: {
                    return !foundItems;
                }
                case CONTAINS: {
                    return foundItems;
                }
                case SPACE: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.TRIGGER_INVENTORY_ALL;
    }

    public static enum State {
        EMPTY,
        CONTAINS,
        SPACE,
        FULL;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

