/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import buildcraft.lib.BCLibConfig;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public abstract class AtlasSpriteSwappable
extends TextureAtlasSprite {
    private TextureAtlasSprite current;
    private boolean needsSwapping = true;

    public AtlasSpriteSwappable(String baseName) {
        super(baseName);
        if (!BCLibConfig.useSwappableSprites) {
            throw new IllegalStateException("The user has disabled swappable sprites but some code still called it's constructor anyway!\n(Note that this is a *mod* bug, not a user configuration issue - there are legitimate reasons\nto disabled swappable sprites normally, like for optifine compat)");
        }
    }

    public boolean func_130098_m() {
        return true;
    }

    public void func_94219_l() {
        if (this.current == null) {
            this.func_94217_a(Minecraft.func_71410_x().func_147117_R().func_174944_f());
            return;
        }
        Profiler p = Minecraft.func_71410_x().field_71424_I;
        p.func_194340_a(((Object)((Object)this)).getClass()::getSimpleName);
        if (this.needsSwapping) {
            p.func_76320_a("copy");
            this.current.func_94217_a((TextureAtlasSprite)this);
            p.func_76319_b();
        }
        if (this.current.func_130098_m() && BCLibConfig.enableAnimatedSprites) {
            p.func_76320_a("update");
            p.func_76320_a(this.func_94215_i());
            this.current.func_94219_l();
            p.func_76319_b();
            p.func_76319_b();
        } else if (this.needsSwapping) {
            p.func_76320_a("swap");
            TextureUtil.func_147955_a((int[][])this.current.func_147965_a(0), (int)this.current.func_94211_a(), (int)this.current.func_94216_b(), (int)this.current.func_130010_a(), (int)this.current.func_110967_i(), (boolean)false, (boolean)false);
            p.func_76319_b();
        }
        this.needsSwapping = false;
        p.func_76319_b();
    }

    public boolean swapWith(TextureAtlasSprite other) {
        if (this.current != other && (this.current == null || other != null)) {
            this.current = other;
            if (this.field_130223_c == 0) {
                this.field_130223_c = other.func_94211_a();
                this.field_130224_d = other.func_94216_b();
            }
            this.func_147963_d(Minecraft.func_71410_x().field_71474_y.field_151442_I);
            this.needsSwapping = true;
            return true;
        }
        return false;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TextureAtlasSprite sprite = AtlasSpriteSwappable.loadSprite(manager, super.func_94215_i(), location, true);
        if (sprite != null) {
            this.swapWith(sprite);
        }
        return false;
    }

    public static TextureAtlasSprite loadSprite(String name, ResourceLocation location, boolean careIfMissing) {
        return AtlasSpriteSwappable.loadSprite(Minecraft.func_71410_x().func_110442_L(), name, location, careIfMissing);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TextureAtlasSprite loadSprite(IResourceManager manager, String name, ResourceLocation location, boolean careIfMissing) {
        TextureAtlasSprite sprite = AtlasSpriteSwappable.func_176604_a((ResourceLocation)new ResourceLocation(name));
        try {
            PngSizeInfo pngsizeinfo = PngSizeInfo.func_188532_a((IResource)manager.func_110536_a(location));
            try (IResource iresource = manager.func_110536_a(location);){
                boolean flag = iresource.func_110526_a("animation") != null;
                sprite.func_188538_a(pngsizeinfo, flag);
                sprite.func_188539_a(iresource, Minecraft.func_71410_x().field_71474_y.field_151442_I + 1);
                TextureAtlasSprite textureAtlasSprite = sprite;
                return textureAtlasSprite;
            }
        }
        catch (IOException io) {
            if (!careIfMissing) return null;
            FMLClientHandler.instance().trackMissingTexture(location);
            return null;
        }
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void func_147963_d(int level) {
        if (this.current != null) {
            this.current.func_147963_d(level);
        }
    }

    public int func_110970_k() {
        if (this.current == null) {
            return 0;
        }
        return this.current.func_110970_k();
    }

    public void func_94217_a(TextureAtlasSprite from) {
        super.func_94217_a(from);
        if (this.current == null) {
            this.current = from;
        } else {
            this.current.func_94217_a(from);
        }
    }

    public int[][] func_147965_a(int index) {
        if (this.current == null) {
            return new int[1][1];
        }
        return this.current.func_147965_a(index);
    }

    public void func_110968_a(List<int[][]> newFramesTextureData) {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + super.toString();
    }
}

