/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.IContainingElement;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.elem.GuiElementDrawable;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class Ledger_Neptune
implements IInteractionElement,
IContainingElement {
    public static final ISprite SPRITE_EXP_NEG = BCLibSprites.LEDGER_LEFT;
    public static final ISprite SPRITE_EXP_POS = BCLibSprites.LEDGER_RIGHT;
    public static final SpriteNineSliced SPRITE_SPLIT_NEG = new SpriteNineSliced(SPRITE_EXP_NEG, 4, 4, 12, 12, 16);
    public static final SpriteNineSliced SPRITE_SPLIT_POS = new SpriteNineSliced(SPRITE_EXP_POS, 4, 4, 12, 12, 16);
    public static final int LEDGER_CHANGE_DIFF = 2;
    public static final int LEDGER_GAP = 4;
    public static final int CLOSED_WIDTH = 22;
    public static final int CLOSED_HEIGHT = 24;
    public final BuildCraftGui gui;
    public final int colour;
    public final boolean expandPositive;
    public final IGuiPosition positionLedgerStart;
    public final IGuiPosition positionLedgerIconStart;
    public final IGuiPosition positionLedgerInnerStart;
    protected double maxWidth = 96.0;
    protected double maxHeight = 48.0;
    protected double currentWidth = 22.0;
    protected double currentHeight = 24.0;
    protected double lastWidth = this.currentWidth;
    protected double lastHeight = this.currentHeight;
    protected double interpWidth = this.lastWidth;
    protected double interpHeight = this.lastHeight;
    protected final List<IGuiElement> closedElements = new ArrayList<IGuiElement>();
    protected final List<IGuiElement> openElements = new ArrayList<IGuiElement>();
    protected IGuiPosition positionAppending;
    protected String title = "unknown";
    private int currentDifference = 0;
    @Nullable
    private IVariableNode.IVariableNodeBoolean isOpenProperty;

    public Ledger_Neptune(BuildCraftGui gui, int colour, boolean expandPositive) {
        this.gui = gui;
        this.colour = colour;
        this.expandPositive = expandPositive;
        if (expandPositive) {
            this.positionLedgerStart = gui.lowerRightLedgerPos;
            gui.lowerRightLedgerPos = this.getPosition(-1, 1).offset(0.0, 5.0);
            this.positionLedgerIconStart = this.positionLedgerStart.offset(2.0, 4.0);
        } else {
            this.positionLedgerStart = gui.lowerLeftLedgerPos.offset(() -> -this.getWidth(), 0.0);
            gui.lowerLeftLedgerPos = this.getPosition(1, 1).offset(0.0, 5.0);
            this.positionLedgerIconStart = this.positionLedgerStart.offset(4.0, 4.0);
        }
        this.positionLedgerInnerStart = this.positionLedgerIconStart.offset(20.0, 0.0);
        this.positionAppending = this.positionLedgerInnerStart.offset(0.0, 3.0);
        GuiRectangle iconRect = new GuiRectangle(0.0, 0.0, 16.0, 16.0);
        ISimpleDrawable drawable = this::drawIcon;
        this.closedElements.add(new GuiElementDrawable(gui, iconRect.offset(this.positionLedgerIconStart), drawable, false));
        this.appendText(this::getTitle, this::getTitleColour).setDropShadow(true);
        this.calculateMaxSize();
    }

    protected GuiElementText appendText(String text, int colour) {
        return this.appendText(() -> text, colour);
    }

    protected GuiElementText appendText(Supplier<String> text, int colour) {
        return this.appendText(text, () -> colour);
    }

    protected GuiElementText appendText(Supplier<String> text, IntSupplier colour) {
        return this.append(new GuiElementText(this.gui, this.positionAppending, text, colour));
    }

    protected <T extends IGuiElement> T append(T element) {
        this.openElements.add(element);
        this.positionAppending = this.positionAppending.offset(() -> 0.0, () -> 3.0 + element.getHeight());
        return element;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOpenProperty(IVariableNode.IVariableNodeBoolean prop) {
        this.isOpenProperty = prop;
        if (prop.evaluate()) {
            this.currentDifference = 1;
            this.lastWidth = this.currentWidth = this.maxWidth;
            this.lastHeight = this.currentHeight = this.maxHeight;
        } else {
            this.currentDifference = -1;
            this.currentWidth = 22.0;
            this.lastWidth = 22.0;
            this.currentHeight = 24.0;
            this.lastHeight = 24.0;
        }
    }

    @Override
    public void calculateSizes() {
        this.calculateMaxSize();
        if (this.isOpenProperty != null) {
            this.setOpenProperty(this.isOpenProperty);
        }
    }

    public void calculateMaxSize() {
        double w = 22.0;
        double h = 24.0;
        for (IGuiElement element : this.openElements) {
            w = Math.max(w, element.getEndX());
            h = Math.max(h, element.getEndY());
        }
        this.maxWidth = (w -= this.getX()) + 8.0;
        this.maxHeight = (h -= this.getY()) + 8.0;
    }

    @Override
    public void tick() {
        this.lastWidth = this.currentWidth;
        this.lastHeight = this.currentHeight;
        double targetWidth = this.currentWidth;
        double targetHeight = this.currentHeight;
        if (this.currentDifference == 1) {
            targetWidth = this.maxWidth;
            targetHeight = this.maxHeight;
        } else if (this.currentDifference == -1) {
            targetWidth = 22.0;
            targetHeight = 24.0;
        } else {
            return;
        }
        double maxDiff = Math.max(this.maxWidth - 22.0, this.maxHeight - 24.0);
        double ldgDiff = MathHelper.func_151237_a((double)(maxDiff / 5.0), (double)1.0, (double)15.0);
        if (this.currentWidth < targetWidth) {
            this.currentWidth += ldgDiff;
            if (this.currentWidth > targetWidth) {
                this.currentWidth = targetWidth;
            }
        } else if (this.currentWidth > targetWidth) {
            this.currentWidth -= ldgDiff;
            if (this.currentWidth < targetWidth) {
                this.currentWidth = targetWidth;
            }
        }
        if (this.currentHeight < targetHeight) {
            this.currentHeight += ldgDiff;
            if (this.currentHeight > targetHeight) {
                this.currentHeight = targetHeight;
            }
        } else if (this.currentHeight > targetHeight) {
            this.currentHeight -= ldgDiff;
            if (this.currentHeight < targetHeight) {
                this.currentHeight = targetHeight;
            }
        }
    }

    private static double interp(double past, double current, float partialTicks) {
        if (past == current) {
            return current;
        }
        if (partialTicks <= 0.0f) {
            return past;
        }
        if (partialTicks >= 1.0f) {
            return current;
        }
        return past * (double)(1.0f - partialTicks) + current * (double)partialTicks;
    }

    @Deprecated
    public GuiRectangle getEnclosingRectangle() {
        return this.asImmutable();
    }

    public final boolean shouldDrawOpen() {
        return this.currentWidth > 22.0 || this.currentHeight > 24.0;
    }

    @Override
    public List<IGuiElement> getChildElements() {
        return this.openElements;
    }

    @Override
    public IGuiPosition getChildElementPosition() {
        return this.positionLedgerInnerStart;
    }

    public List<IGuiElement> getClosedElements() {
        return this.closedElements;
    }

    @Override
    public void drawBackground(float partialTicks) {
        double startX = this.getX();
        double startY = this.getY();
        this.interpWidth = Ledger_Neptune.interp(this.lastWidth, this.currentWidth, partialTicks);
        this.interpHeight = Ledger_Neptune.interp(this.lastHeight, this.currentHeight, partialTicks);
        SpriteNineSliced split = this.expandPositive ? SPRITE_SPLIT_POS : SPRITE_SPLIT_NEG;
        RenderUtil.setGLColorFromIntPlusAlpha(this.colour);
        split.draw(startX, startY, this.interpWidth, this.interpHeight);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IGuiPosition pos2 = this.expandPositive ? this.positionLedgerIconStart : this.positionLedgerIconStart;
        try (GuiUtil.AutoGlScissor a = GuiUtil.scissor(pos2.getX(), pos2.getY(), this.interpWidth - 4.0, this.interpHeight - 8.0);){
            for (IGuiElement element : this.closedElements) {
                element.drawBackground(partialTicks);
            }
            if (this.shouldDrawOpen()) {
                for (IGuiElement element : this.openElements) {
                    element.drawBackground(partialTicks);
                }
            }
        }
    }

    @Override
    public void drawForeground(float partialTicks) {
        double scissorX = this.positionLedgerIconStart.getX();
        double scissorY = this.positionLedgerIconStart.getY();
        double scissorWidth = this.interpWidth - 8.0;
        double scissorHeight = this.interpHeight - 8.0;
        try (GuiUtil.AutoGlScissor a = GuiUtil.scissor(scissorX, scissorY, scissorWidth, scissorHeight);){
            for (IGuiElement element : this.closedElements) {
                element.drawForeground(partialTicks);
            }
            if (this.shouldDrawOpen()) {
                for (IGuiElement element : this.openElements) {
                    element.drawForeground(partialTicks);
                }
            }
        }
    }

    @Override
    public void onMouseClicked(int button) {
        boolean childClicked = false;
        for (IGuiElement elem : this.openElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseClicked(button);
            childClicked |= elem.contains(this.gui.mouse);
        }
        for (IGuiElement elem : this.closedElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseClicked(button);
            childClicked |= elem.contains(this.gui.mouse);
        }
        if (!childClicked && this.contains(this.gui.mouse)) {
            boolean nowOpen = false;
            if (this.currentDifference == 1) {
                this.currentDifference = -1;
            } else {
                this.currentDifference = 1;
                nowOpen = true;
            }
            if (this.isOpenProperty != null) {
                this.isOpenProperty.set(nowOpen);
            }
        }
    }

    @Override
    public void onMouseDragged(int button, long ticksSinceClick) {
        for (IGuiElement elem : this.openElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseDragged(button, ticksSinceClick);
        }
        for (IGuiElement elem : this.closedElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseDragged(button, ticksSinceClick);
        }
    }

    @Override
    public void onMouseReleased(int button) {
        for (IGuiElement elem : this.openElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseReleased(button);
        }
        for (IGuiElement elem : this.closedElements) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseReleased(button);
        }
    }

    protected void drawIcon(double x, double y) {
    }

    @Override
    public double getX() {
        return this.positionLedgerStart.getX();
    }

    @Override
    public double getY() {
        return this.positionLedgerStart.getY();
    }

    @Override
    public double getWidth() {
        float partialTicks = this.gui.getLastPartialTicks();
        if (this.lastWidth == this.currentWidth) {
            return this.currentWidth;
        }
        if (partialTicks <= 0.0f) {
            return this.lastWidth;
        }
        if (partialTicks >= 1.0f) {
            return this.currentWidth;
        }
        return this.lastWidth * (double)(1.0f - partialTicks) + this.currentWidth * (double)partialTicks;
    }

    @Override
    public double getHeight() {
        float partialTicks = this.gui.getLastPartialTicks();
        if (this.lastHeight == this.currentHeight) {
            return this.currentHeight;
        }
        if (partialTicks <= 0.0f) {
            return this.lastHeight;
        }
        if (partialTicks >= 1.0f) {
            return this.currentHeight;
        }
        return this.lastHeight * (double)(1.0f - partialTicks) + this.currentHeight * (double)partialTicks;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
    }

    public int getTitleColour() {
        return -1980113;
    }

    @Override
    public void addToolTips(List<ToolTip> tooltips) {
        for (IGuiElement element : this.closedElements) {
            element.addToolTips(tooltips);
        }
        if (this.shouldDrawOpen()) {
            for (IGuiElement element : this.openElements) {
                element.addToolTips(tooltips);
            }
        }
        if ((this.currentWidth != this.maxWidth || this.currentHeight != this.maxHeight) && this.contains(this.gui.mouse)) {
            tooltips.add(new ToolTip(this.getTitle()));
        }
    }

    @Override
    public void addHelpElements(List<ElementHelpInfo.HelpPosition> elements) {
        for (IGuiElement element : this.closedElements) {
            element.addHelpElements(elements);
        }
        if (this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            for (IGuiElement element : this.openElements) {
                element.addHelpElements(elements);
            }
        }
    }
}

