/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.lib.BCLibConfig;
import buildcraft.lib.misc.LocaleUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;

public class ColourUtil {
    public static final char MINECRAFT_FORMAT_CHAR;
    public static final String COLOUR_SPECIAL_START;
    public static final Function<TextFormatting, TextFormatting> getTextFormatForBlack;
    public static final Function<TextFormatting, TextFormatting> getTextFormatForWhite;
    public static final EnumDyeColor[] COLOURS;
    private static final String[] NAMES;
    private static final int[] DARK_HEX;
    private static final int[] LIGHT_HEX;
    private static final String[] DYES;
    private static final Map<String, EnumDyeColor> nameToColourMap;
    private static final int[] FACE_TO_COLOUR;
    private static final TextFormatting[] FORMATTING_VALUES;
    private static final TextFormatting[] COLOUR_TO_FORMAT;
    private static final TextFormatting[] REPLACE_FOR_WHITE;
    private static final TextFormatting[] REPLACE_FOR_BLACK;
    private static final TextFormatting[] REPLACE_FOR_WHITE_HIGH_CONTRAST;
    private static final TextFormatting[] REPLACE_FOR_BLACK_HIGH_CONTRAST;
    private static final TextFormatting[] FACE_TO_FORMAT;
    private static final Pattern ALL_FORMAT_MATCHER;

    private static void replaceColourForBlack(TextFormatting colour, TextFormatting with) {
        ColourUtil.replaceColourForBlack(colour, with, with);
    }

    private static void replaceColourForBlack(TextFormatting colour, TextFormatting normal, TextFormatting highContrast) {
        ColourUtil.REPLACE_FOR_BLACK[colour.ordinal()] = normal;
        ColourUtil.REPLACE_FOR_BLACK_HIGH_CONTRAST[colour.ordinal()] = highContrast;
    }

    private static void replaceColourForWhite(TextFormatting colour, TextFormatting with) {
        ColourUtil.replaceColourForWhite(colour, with, with);
    }

    private static void replaceColourForWhite(TextFormatting colour, TextFormatting normal, TextFormatting highContrast) {
        ColourUtil.REPLACE_FOR_WHITE[colour.ordinal()] = normal;
        ColourUtil.REPLACE_FOR_WHITE_HIGH_CONTRAST[colour.ordinal()] = highContrast;
    }

    @Nullable
    public static EnumDyeColor parseColourOrNull(String string) {
        return nameToColourMap.get(string);
    }

    public static String getDyeName(EnumDyeColor colour) {
        return DYES[colour.func_176767_b()];
    }

    public static String getName(EnumDyeColor colour) {
        return NAMES[colour.func_176767_b()];
    }

    public static int getDarkHex(EnumDyeColor colour) {
        return DARK_HEX[colour.func_176767_b()];
    }

    public static int getLightHex(EnumDyeColor colour) {
        return LIGHT_HEX[colour.func_176767_b()];
    }

    public static int getColourForSide(EnumFacing face) {
        return FACE_TO_COLOUR[face.ordinal()];
    }

    public static String[] getNameArray() {
        return Arrays.copyOf(NAMES, NAMES.length);
    }

    public static String getTextFullTooltip(EnumDyeColor colour) {
        if (BCLibConfig.useColouredLabels) {
            TextFormatting formatColour = ColourUtil.convertColourToTextFormat(colour);
            return formatColour.toString() + ColourUtil.getTextFormatForBlack(formatColour) + LocaleUtil.localizeColour(colour) + TextFormatting.RESET;
        }
        return LocaleUtil.localizeColour(colour);
    }

    public static String getTextFullTooltipSpecial(EnumDyeColor colour) {
        if (colour == EnumDyeColor.BLACK || colour == EnumDyeColor.BLUE) {
            return ColourUtil.getTextFullTooltip(colour);
        }
        if (BCLibConfig.useColouredLabels) {
            TextFormatting formatColour = ColourUtil.convertColourToTextFormat(colour);
            return COLOUR_SPECIAL_START + Integer.toHexString(colour.func_176765_a()) + ColourUtil.getTextFormatForBlack(formatColour) + LocaleUtil.localizeColour(colour) + TextFormatting.RESET;
        }
        return LocaleUtil.localizeColour(colour);
    }

    public static String getTextFullTooltip(EnumFacing face) {
        if (BCLibConfig.useColouredLabels) {
            TextFormatting formatColour = ColourUtil.convertFaceToTextFormat(face);
            return formatColour.toString() + ColourUtil.getTextFormatForBlack(formatColour) + LocaleUtil.localizeFacing(face) + TextFormatting.RESET;
        }
        return LocaleUtil.localizeFacing(face);
    }

    public static TextFormatting getTextFormatForBlack(TextFormatting in) {
        if (in.func_96302_c()) {
            if (BCLibConfig.useHighContrastLabelColours) {
                return REPLACE_FOR_BLACK_HIGH_CONTRAST[in.ordinal()];
            }
            return REPLACE_FOR_BLACK[in.ordinal()];
        }
        return in;
    }

    public static TextFormatting getTextFormatForWhite(TextFormatting in) {
        if (in.func_96302_c()) {
            if (BCLibConfig.useHighContrastLabelColours) {
                return REPLACE_FOR_WHITE_HIGH_CONTRAST[in.ordinal()];
            }
            return REPLACE_FOR_WHITE[in.ordinal()];
        }
        return in;
    }

    public static TextFormatting convertColourToTextFormat(EnumDyeColor colour) {
        return COLOUR_TO_FORMAT[colour.ordinal()];
    }

    public static TextFormatting convertFaceToTextFormat(EnumFacing face) {
        return FACE_TO_FORMAT[face.ordinal()];
    }

    public static int swapArgbToAbgr(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static EnumDyeColor getNext(EnumDyeColor colour) {
        int ord = colour.ordinal() + 1;
        return COLOURS[ord & 0xF];
    }

    public static EnumDyeColor getNextOrNull(@Nullable EnumDyeColor colour) {
        if (colour == null) {
            return COLOURS[0];
        }
        if (colour == COLOURS[COLOURS.length - 1]) {
            return null;
        }
        return ColourUtil.getNext(colour);
    }

    public static EnumDyeColor getPrev(EnumDyeColor colour) {
        int ord = colour.ordinal() + 16 - 1;
        return COLOURS[ord & 0xF];
    }

    public static EnumDyeColor getPrevOrNull(@Nullable EnumDyeColor colour) {
        if (colour == null) {
            return COLOURS[COLOURS.length - 1];
        }
        if (colour == COLOURS[0]) {
            return null;
        }
        return ColourUtil.getPrev(colour);
    }

    public static String stripAllFormatCodes(String string) {
        return ALL_FORMAT_MATCHER.matcher(string).replaceAll("");
    }

    static {
        getTextFormatForBlack = ColourUtil::getTextFormatForBlack;
        getTextFormatForWhite = ColourUtil::getTextFormatForWhite;
        COLOURS = EnumDyeColor.values();
        NAMES = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        DARK_HEX = new int[]{0x2D2D2D, 10696757, 3755038, 6044196, 3424674, 8667071, 3571870, 0x888888, 0x444444, 15041952, 4172342, 13615665, 8362705, 0xFF64FF, 16738816, 0xFFFFFF};
        LIGHT_HEX = new int[]{0x181414, 12462887, 32526, 8998957, 2437523, 8271039, 0x299799, 0xA0A7A7, 0x7A7A7A, 14250393, 3790126, 16767260, 0x66AAFF, 14238662, 15366197, 0xE4E4E4};
        DYES = new String[16];
        FORMATTING_VALUES = TextFormatting.values();
        COLOUR_TO_FORMAT = new TextFormatting[16];
        REPLACE_FOR_WHITE = new TextFormatting[16];
        REPLACE_FOR_BLACK = new TextFormatting[16];
        REPLACE_FOR_WHITE_HIGH_CONTRAST = new TextFormatting[16];
        REPLACE_FOR_BLACK_HIGH_CONTRAST = new TextFormatting[16];
        FACE_TO_FORMAT = new TextFormatting[6];
        ALL_FORMAT_MATCHER = Pattern.compile("(?i)\u00a7[0-9A-Za-z]");
        MINECRAFT_FORMAT_CHAR = (char)167;
        COLOUR_SPECIAL_START = MINECRAFT_FORMAT_CHAR + "z" + MINECRAFT_FORMAT_CHAR;
        for (int i = 0; i < 16; ++i) {
            ColourUtil.DYES[i] = "dye" + NAMES[i];
            ColourUtil.REPLACE_FOR_WHITE[i] = ColourUtil.REPLACE_FOR_WHITE_HIGH_CONTRAST[i] = FORMATTING_VALUES[i];
            ColourUtil.REPLACE_FOR_BLACK[i] = ColourUtil.REPLACE_FOR_BLACK_HIGH_CONTRAST[i] = FORMATTING_VALUES[i];
        }
        ColourUtil.replaceColourForWhite(TextFormatting.WHITE, TextFormatting.GRAY);
        ColourUtil.replaceColourForWhite(TextFormatting.YELLOW, TextFormatting.GOLD);
        ColourUtil.replaceColourForWhite(TextFormatting.AQUA, TextFormatting.BLUE);
        ColourUtil.replaceColourForWhite(TextFormatting.GREEN, TextFormatting.DARK_GREEN);
        ColourUtil.replaceColourForBlack(TextFormatting.BLACK, TextFormatting.GRAY);
        ColourUtil.replaceColourForBlack(TextFormatting.DARK_GRAY, TextFormatting.GRAY);
        ColourUtil.replaceColourForBlack(TextFormatting.DARK_BLUE, TextFormatting.BLUE, TextFormatting.AQUA);
        ColourUtil.replaceColourForBlack(TextFormatting.BLUE, TextFormatting.BLUE, TextFormatting.AQUA);
        ColourUtil.replaceColourForBlack(TextFormatting.DARK_PURPLE, TextFormatting.LIGHT_PURPLE);
        ColourUtil.replaceColourForBlack(TextFormatting.DARK_RED, TextFormatting.RED);
        ColourUtil.replaceColourForBlack(TextFormatting.DARK_GREEN, TextFormatting.GREEN);
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.BLACK.ordinal()] = TextFormatting.BLACK;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.GRAY.ordinal()] = TextFormatting.DARK_GRAY;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.SILVER.ordinal()] = TextFormatting.GRAY;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.WHITE.ordinal()] = TextFormatting.WHITE;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.RED.ordinal()] = TextFormatting.DARK_RED;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.BLUE.ordinal()] = TextFormatting.BLUE;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.CYAN.ordinal()] = TextFormatting.DARK_AQUA;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.LIGHT_BLUE.ordinal()] = TextFormatting.AQUA;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.GREEN.ordinal()] = TextFormatting.DARK_GREEN;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.LIME.ordinal()] = TextFormatting.GREEN;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.BROWN.ordinal()] = TextFormatting.GOLD;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.YELLOW.ordinal()] = TextFormatting.YELLOW;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.ORANGE.ordinal()] = TextFormatting.GOLD;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.PURPLE.ordinal()] = TextFormatting.DARK_PURPLE;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.MAGENTA.ordinal()] = TextFormatting.LIGHT_PURPLE;
        ColourUtil.COLOUR_TO_FORMAT[EnumDyeColor.PINK.ordinal()] = TextFormatting.LIGHT_PURPLE;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.UP.ordinal()] = TextFormatting.WHITE;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.DOWN.ordinal()] = TextFormatting.BLACK;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.NORTH.ordinal()] = TextFormatting.RED;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.SOUTH.ordinal()] = TextFormatting.BLUE;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.EAST.ordinal()] = TextFormatting.YELLOW;
        ColourUtil.FACE_TO_FORMAT[EnumFacing.WEST.ordinal()] = TextFormatting.GREEN;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumDyeColor c : COLOURS) {
            builder.put((Object)c.func_176610_l(), (Object)c);
        }
        nameToColourMap = builder.build();
        FACE_TO_COLOUR = new int[6];
        ColourUtil.FACE_TO_COLOUR[EnumFacing.DOWN.ordinal()] = -13421773;
        ColourUtil.FACE_TO_COLOUR[EnumFacing.UP.ordinal()] = -3355444;
    }
}

