/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.display;

import com.google.common.base.MoreObjects;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.UIState;
import journeymap.common.api.feature.Feature;

@ParametersAreNonnullByDefault
public abstract class Overlay
extends Displayable {
    protected String overlayGroupName;
    protected String title;
    protected String label;
    protected int dimension;
    protected int minZoom = 0;
    protected int maxZoom = 8;
    protected int displayOrder;
    protected EnumSet<Feature.Display> activeUIs = EnumSet.allOf(Feature.Display.class);
    protected EnumSet<Feature.MapType> activeMapTypes = EnumSet.allOf(Feature.MapType.class);
    protected TextProperties textProperties = new TextProperties();
    protected IOverlayListener overlayListener;
    protected boolean needsRerender = true;

    Overlay(String modId, String displayId) {
        super(modId, displayId);
    }

    public int getDimension() {
        return this.dimension;
    }

    public Overlay setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public String getOverlayGroupName() {
        return this.overlayGroupName;
    }

    public Overlay setOverlayGroupName(String overlayGroupName) {
        this.overlayGroupName = overlayGroupName;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Overlay setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Overlay setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public Overlay setMinZoom(int minZoom) {
        this.minZoom = Math.max(0, minZoom);
        return this;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public Overlay setMaxZoom(int maxZoom) {
        this.maxZoom = Math.min(8, maxZoom);
        return this;
    }

    @Override
    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public Overlay setDisplayOrder(int zIndex) {
        this.displayOrder = zIndex;
        return this;
    }

    public TextProperties getTextProperties() {
        return this.textProperties;
    }

    public Overlay setTextProperties(TextProperties textProperties) {
        this.textProperties = textProperties;
        return this;
    }

    public EnumSet<Feature.Display> getActiveUIs() {
        return this.activeUIs;
    }

    public Overlay setActiveUIs(EnumSet<Feature.Display> activeUIs) {
        this.activeUIs = EnumSet.noneOf(Feature.Display.class);
        this.activeUIs.addAll(activeUIs);
        return this;
    }

    public EnumSet<Feature.MapType> getActiveMapTypes() {
        return this.activeMapTypes;
    }

    public Overlay setActiveMapTypes(EnumSet<Feature.MapType> activeMapTypes) {
        this.activeMapTypes = EnumSet.noneOf(Feature.MapType.class);
        this.activeMapTypes.addAll(activeMapTypes);
        return this;
    }

    public boolean isActiveIn(UIState uiState) {
        return uiState.active && this.dimension == uiState.dimension && this.activeUIs.contains(uiState.ui) && this.activeMapTypes.contains(uiState.mapType) && this.minZoom <= uiState.zoom && this.maxZoom >= uiState.zoom;
    }

    public IOverlayListener getOverlayListener() {
        return this.overlayListener;
    }

    public Overlay setOverlayListener(@Nullable IOverlayListener overlayListener) {
        this.overlayListener = overlayListener;
        return this;
    }

    public void flagForRerender() {
        this.needsRerender = true;
    }

    public void clearFlagForRerender() {
        this.needsRerender = false;
    }

    public boolean getNeedsRerender() {
        return this.needsRerender;
    }

    protected final MoreObjects.ToStringHelper toStringHelper(Overlay instance) {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.label).add("title", (Object)this.title).add("overlayGroupName", (Object)this.overlayGroupName).add("activeMapTypes", this.activeMapTypes).add("activeUIs", this.activeUIs).add("dimension", this.dimension).add("displayOrder", this.displayOrder).add("maxZoom", this.maxZoom).add("minZoom", this.minZoom).add("textProperties", (Object)this.textProperties).add("hasOverlayListener", this.overlayListener != null);
    }
}

