/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.Policy;
import net.minecraft.client.Minecraft;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

@ParametersAreNonnullByDefault
public class ClientFeatures
extends PlayerFeatures {
    private static DateFormat DATEFORMAT = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
    private static Supplier<ClientFeatures> instance = Suppliers.memoize(ClientFeatures::new);
    private static final Map<String, String> modIdMap = new HashMap<String, String>();

    private ClientFeatures() {
        super(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
    }

    public boolean isAllowed(Feature feature, int dimension) {
        return this.get(dimension).isAllowed(JourneymapClient.getGameType(), feature);
    }

    @Override
    public boolean isAllowed(GameType gameType, Feature feature, int dimension) {
        return this.get(dimension).isAllowed(gameType, feature);
    }

    public static ClientFeatures instance() {
        return (ClientFeatures)instance.get();
    }

    public static String getServerOriginName() {
        return Constants.getString("jm.common.server_config");
    }

    public static String getFeatureCategoryName(Feature feature) {
        return Constants.getString(feature.getFeatureCategoryKey());
    }

    public static String getFeatureName(Feature feature) {
        return Constants.getString(feature.getFeatureKey());
    }

    public static String getFeatureTooltip(Feature feature) {
        return Constants.getString(feature.getFeatureTooltipKey());
    }

    public static String getOriginString(Policy policy) {
        String origin = policy.getOrigin();
        if (origin != null) {
            if (origin.startsWith("jm.")) {
                return Constants.getString(origin);
            }
            return ClientFeatures.getModName(origin);
        }
        return null;
    }

    public static String getAuditString(Policy policy) {
        String origin = ClientFeatures.getOriginString(policy);
        String time = DATEFORMAT.format(new Date(policy.getTimestamp()));
        switch (policy.getEvent()) {
            case Initialize: {
                return Constants.getString("jm.common.features.audit_feature_init", origin, time);
            }
            case Reset: {
                return Constants.getString("jm.common.features.audit_feature_reset", origin, time);
            }
            case Update: {
                if (policy.isAllowed()) {
                    return Constants.getString("jm.common.features.audit_feature_enable", origin, time);
                }
                return Constants.getString("jm.common.features.audit_feature_disable", origin, time);
            }
        }
        return policy.toString();
    }

    public void logDeltas(String header, DimensionPolicies oldPolicies, DimensionPolicies newPolicies) {
        boolean unchanged = true;
        StringBuilder sb = new StringBuilder(header);
        for (GameType gameType : VALID_GAME_TYPES) {
            boolean showType = true;
            for (Feature feature : PlayerFeatures.ALL_FEATURES) {
                boolean newAllowed;
                boolean oldAllowed = oldPolicies.isAllowed(gameType, feature);
                if (oldAllowed == (newAllowed = newPolicies.isAllowed(gameType, feature))) continue;
                unchanged = false;
                if (showType) {
                    sb.append("\n\t").append(gameType.name());
                    showType = false;
                }
                sb.append("\n\t\t").append(Constants.getString(feature.getFeatureCategoryKey()));
                sb.append(" ").append(Constants.getString(feature.getFeatureKey()));
                sb.append(" = ").append(newAllowed);
            }
        }
        if (unchanged) {
            sb.append(": No changes");
        }
        Journeymap.getLogger().info(sb.toString());
    }

    private static String getModName(String modId) {
        return modIdMap.computeIfAbsent(modId, id -> {
            try {
                ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modId);
                if (mod == null) {
                    for (Map.Entry modEntry : Loader.instance().getIndexedModList().entrySet()) {
                        if (!((ModContainer)modEntry.getValue()).getModId().toLowerCase().equals(modId)) continue;
                        mod = (ModContainer)modEntry.getValue();
                        break;
                    }
                }
                if (mod != null) {
                    return mod.getName();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error looking up mod " + id, (Throwable)e);
            }
            return id;
        });
    }
}

