/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.MapText;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.util.math.BlockPos;

public class DrawWayPointStep
implements DrawStep {
    public final Waypoint waypoint;
    final TextureImpl texture;
    final boolean isEdit;
    final MapImage icon;
    final MapText label;
    Point2D.Double lastPosition;
    boolean lastOnScreen;
    boolean showLabel;

    public DrawWayPointStep(Waypoint waypoint) {
        this(waypoint, false);
    }

    public DrawWayPointStep(Waypoint waypoint, boolean isEdit) {
        this.waypoint = waypoint;
        this.isEdit = isEdit;
        this.icon = WaypointStore.getWaypointIcon(waypoint);
        this.label = WaypointStore.getWaypointLabel(waypoint);
        this.texture = TextureCache.getTexture(this.icon.getImageLocation());
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    @Override
    public void draw(DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, gridRenderer, true);
        if (gridRenderer.isOnScreen(pixel)) {
            if (this.showLabel && pass == DrawStep.Pass.Text) {
                Point2D labelPoint = gridRenderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, rotation == 0.0 ? -this.texture.getHeight() : this.texture.getHeight());
                DrawUtil.drawLabel(this.waypoint.getName(), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, this.label.getBackgroundColor(), this.label.getBackgroundOpacity(), this.label.getColor(), this.label.getOpacity(), fontScale, this.label.hasFontShadow(), rotation);
            } else if (this.isEdit && pass == DrawStep.Pass.Object) {
                TextureImpl editTex = TextureCache.getTexture(TextureCache.WaypointEdit);
                DrawUtil.drawColoredImage(editTex, this.icon.getColor(), 1.0f, pixel.getX() - (double)(editTex.getWidth() / 2), pixel.getY() - (double)(editTex.getHeight() / 2), -rotation);
            }
            if (pass == DrawStep.Pass.Object) {
                DrawUtil.drawColoredImage(this.texture, this.icon.getColor(), 1.0f, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
            }
        } else if (!this.isEdit && pass == DrawStep.Pass.Object) {
            gridRenderer.ensureOnScreen(pixel);
            DrawUtil.drawColoredImage(this.texture, this.icon.getColor(), 1.0f, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
        }
    }

    public static void drawIcon(MapImage icon, Point2D.Double pixel) {
        TextureImpl texture = TextureCache.getTexture(icon.getImageLocation());
        double width = icon.getDisplayWidth();
        double height = icon.getDisplayHeight();
        DrawUtil.drawColoredSprite(texture, width, height, icon.getTextureX(), icon.getTextureY(), width, height, icon.getColor(), icon.getOpacity(), pixel.x - width / 2.0, pixel.y - height / 2.0, 1.0f, icon.getRotation());
    }

    public void drawOffscreen(DrawStep.Pass pass, Point2D pixel, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            DrawUtil.drawColoredImage(this.texture, this.icon.getColor(), 1.0f, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, GridRenderer gridRenderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        BlockPos pos = this.waypoint.getPosition(gridRenderer.getMapView().dimension);
        double x = pos.func_177958_n();
        double z = pos.func_177952_p();
        double halfBlock = Math.pow(2.0, gridRenderer.getZoom()) / 2.0;
        Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        this.lastPosition = pixel;
        return pixel;
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    @Override
    public String getModId() {
        return this.waypoint.getModId();
    }

    public static class SimpleCacheLoader
    extends CacheLoader<Waypoint, DrawWayPointStep> {
        public DrawWayPointStep load(Waypoint waypoint) throws Exception {
            return new DrawWayPointStep(waypoint);
        }
    }
}

