/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Mouse;

public class ScrollPane
extends GuiSlot {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Scrollable selected = null;
    private List<? extends Scrollable> items;
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    public int bgColor = 0;
    public float bgAlpha = 0.4f;
    public int frameColor = new Color(-6250336).getRGB();
    public float frameAlpha = 1.0f;

    public ScrollPane(Minecraft mc, int width, int height, List<? extends Scrollable> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, height, itemHeight + itemGap);
        this.items = items;
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int getX() {
        return (int)this.origin.getX();
    }

    public int getY() {
        return (int)this.origin.getY();
    }

    public int func_148146_j() {
        return this.field_148149_f;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.func_148122_a(width, height, marginTop, height - marginBottom);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    public int func_148127_b() {
        return this.items.size();
    }

    protected void func_148144_a(int i, boolean flag, int p1, int p2) {
        this.selected = this.items.get(i);
    }

    protected boolean func_148131_a(int i) {
        return this.items.get(i) == this.selected;
    }

    public boolean isSelected(Scrollable item) {
        return item == this.selected;
    }

    public void select(Scrollable item) {
        this.selected = item;
    }

    protected void func_148123_a() {
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            ArrayList<? extends Scrollable> itemsCopy = new ArrayList<Scrollable>(this.items);
            for (Scrollable scrollable : itemsCopy) {
                if (scrollable == null || !this.inFullView(scrollable)) continue;
                if (scrollable instanceof Button) {
                    Button button = (Button)scrollable;
                    if (!button.func_146116_c(this.mc, mouseX, mouseY)) continue;
                    this.func_148147_a(button);
                    return button;
                }
                if (mouseX < scrollable.getX() || mouseX > scrollable.getX() + scrollable.getWidth() || mouseY < scrollable.getY() || mouseY > scrollable.getY() + scrollable.getHeight()) continue;
                scrollable.clickScrollable(this.mc, mouseX, mouseY);
                return null;
            }
        }
        return null;
    }

    public void func_148128_a(int mX, int mY, float f) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        this._mouseX = mX;
        this._mouseY = mY;
        if (this.selected == null || Mouse.isButtonDown((int)0) || Mouse.getDWheel() != 0 || !Mouse.next() || Mouse.getEventButtonState()) {
            // empty if block
        }
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.func_148128_a(mX - this.getX(), mY - this.getY(), f);
        if (Mouse.isButtonDown((int)0) && this.getY() <= mY && mY <= this.getY() + this.field_148158_l && mX >= this.getX() + this.field_148155_a && mX <= this.getX() + this.field_148155_a + 6) {
            int slot = (int)(((double)mY - (double)this.getY() * 1.0) / (double)this.paneHeight * (double)this.func_148127_b());
            this.func_148145_f(-(this.func_148127_b() * this.func_148146_j()));
            this.func_148145_f(slot * this.func_148146_j());
        }
        GlStateManager.func_179121_F();
    }

    protected void func_192637_a(int index, int x, int yPosition, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.getX()), (float)(-this.getY()), (float)0.0f);
        int margin = 4;
        int itemX = this.getX() + 2;
        int itemY = yPosition + this.getY();
        Scrollable item = this.items.get(index);
        item.setPosition(itemX, itemY);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(this.mc, this._mouseX, this._mouseY);
            if (this.firstVisibleIndex == -1) {
                this.firstVisibleIndex = index;
            }
            this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        } else {
            int paneBottomY = this.getY() + this.paneHeight;
            int itemBottomY = itemY + item.getHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (itemY < this.getY() && itemBottomY > this.getY()) {
                drawY = this.getY();
                yDiff = drawY - itemY;
            } else if (itemY < paneBottomY && itemBottomY > paneBottomY) {
                drawY = itemY;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null) {
                item.drawPartialScrollable(this.mc, itemX, drawY, item.getWidth(), item.getHeight() - yDiff);
            }
        }
        GlStateManager.func_179121_F();
    }

    public boolean inFullView(Scrollable item) {
        return item.getY() >= this.getY() && item.getY() + item.getHeight() <= this.getY() + this.paneHeight;
    }

    public Scrollable getScrollableUnderMouse(int mouseX, int mouseY) {
        for (int i = this.firstVisibleIndex; i <= this.lastVisibleIndex; ++i) {
            Scrollable item;
            if (i < 0 || i >= this.items.size() || mouseX < (item = this.items.get(i)).getX() || mouseX > item.getX() + item.getWidth() || mouseY < item.getY() || mouseY > item.getY() + item.getHeight()) continue;
            return item;
        }
        return null;
    }

    protected int func_148137_d() {
        return this.paneWidth;
    }

    public int getWidth() {
        boolean scrollVisible = 0 < this.func_148148_g();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(FontRenderer fr) {
        int fit = 0;
        for (Scrollable scrollable : this.items) {
            fit = Math.max(fit, scrollable.getFitWidth(fr));
        }
        return fit;
    }

    public void setShowFrame(boolean showFrame) {
        this.showFrame = showFrame;
    }

    protected void drawContainerBackground(Tessellator tess) {
        DrawUtil.drawRectangle(this.field_148152_e, this.field_148153_b, this.paneWidth, this.paneHeight, this.bgColor, this.bgAlpha);
        if (this.func_148135_f() == 0) {
            DrawUtil.drawRectangle(this.paneWidth, this.field_148153_b, 6.0, this.paneHeight, 0, this.bgAlpha);
        }
        if (this.showFrame) {
            int x1 = -2;
            int y1 = this.field_148153_b - 1;
            int x2 = this.paneWidth + 8;
            int y2 = this.paneHeight + 3;
            DrawUtil.drawRectangle(x1, y1, x2, 1.0, this.frameColor, this.frameAlpha);
            DrawUtil.drawRectangle(x1, y2 - 3, x2 + 1, 1.0, this.frameColor, this.frameAlpha);
            DrawUtil.drawRectangle(x1, y1, 1.0, y2 - 2, this.frameColor, this.frameAlpha);
            DrawUtil.drawRectangle(x2 - 2, y1, 1.0, y2 - 2, this.frameColor, this.frameAlpha);
        }
    }

    public int getFirstVisibleIndex() {
        return this.firstVisibleIndex;
    }

    public int getLastVisibleIndex() {
        return this.lastVisibleIndex;
    }

    public static interface Scrollable {
        public void setPosition(int var1, int var2);

        public int getX();

        public int getY();

        public int getWidth();

        public void setScrollableWidth(int var1);

        public int getFitWidth(FontRenderer var1);

        public int getHeight();

        public void drawScrollable(Minecraft var1, int var2, int var3);

        public void drawPartialScrollable(Minecraft var1, int var2, int var3, int var4, int var5);

        public void clickScrollable(Minecraft var1, int var2, int var3);

        public List<String> getTooltip();
    }
}

