/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.action;

import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.network.model.Location;
import journeymap.server.JourneymapServer;
import journeymap.server.api.impl.ServerAPI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.server.FMLServerHandler;

public class JourneyMapTeleport {
    public static boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof EntityPlayerMP) {
            if (mcServer == null) {
                entity.func_145747_a((ITextComponent)new TextComponentString("Cannot Find World"));
                return false;
            }
            WorldServer destinationWorld = mcServer.func_71218_a(location.getDim());
            if (!entity.func_70089_S()) {
                entity.func_145747_a((ITextComponent)new TextComponentString("Cannot teleport when dead."));
                return false;
            }
            if (destinationWorld == null) {
                entity.func_145747_a((ITextComponent)new TextComponentString("Could not get world for Dimension " + location.getDim()));
                return false;
            }
            boolean isOp = JourneymapServer.isOp(entity.func_110124_au());
            int fromDim = entity.func_130014_f_().field_73011_w.getDimension();
            int toDim = location.getDim();
            GameType gameType = ((EntityPlayerMP)entity).field_71134_c.func_73081_b();
            DimensionPolicies fromDimPolicies = ServerAPI.INSTANCE.getFeatures(entity.func_110124_au()).get(fromDim);
            boolean fromTpAllowed = fromDimPolicies.isAllowed(gameType, Feature.Action.Teleport);
            DimensionPolicies toDimPolicies = ServerAPI.INSTANCE.getFeatures(entity.func_110124_au()).get(toDim);
            boolean toTpAllowed = toDimPolicies.isAllowed(gameType, Feature.Action.Teleport);
            if (!fromTpAllowed || !toTpAllowed) {
                String role;
                String origin = fromDimPolicies.getOrigin(gameType, Feature.Action.Teleport);
                String string = role = isOp ? "Ops" : "Players";
                if (fromDim == toDim) {
                    entity.func_145747_a((ITextComponent)new TextComponentString(String.format("%s has disabled JourneyMap teleporting by %s in this dimension in %s.", origin, role, gameType)));
                    return false;
                }
                if (!fromTpAllowed) {
                    entity.func_145747_a((ITextComponent)new TextComponentString(String.format("%s has disabled JourneyMap teleporting by %s from this dimension in %s.", origin, role, gameType)));
                    return false;
                }
                origin = toDimPolicies.getOrigin(gameType, Feature.Action.Teleport);
                entity.func_145747_a((ITextComponent)new TextComponentString(String.format("%s has disabled JourneyMap teleporting by %s to that dimension in %s.", origin, role, gameType)));
                return false;
            }
            JourneyMapTeleport.teleportEntity(mcServer, (World)destinationWorld, entity, location, entity.field_70177_z);
            return true;
        }
        return false;
    }

    private static boolean teleportEntity(MinecraftServer server, World destinationWorld, Entity entity, Location location, float yaw) {
        World startWorld = Journeymap.clientWorld();
        boolean changedWorld = startWorld != destinationWorld;
        PlayerList playerList = server.func_184103_al();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.func_184210_p();
            if (changedWorld) {
                player.field_71093_bK = location.getDim();
                player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), destinationWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                playerList.func_187243_f(player);
                startWorld.func_72973_f((Entity)player);
                player.field_70128_L = false;
                JourneyMapTeleport.transferPlayerToWorld((Entity)player, (WorldServer)destinationWorld);
                playerList.func_72375_a(player, (WorldServer)startWorld);
                player.field_71135_a.func_147364_a(location.getX() + 0.5, location.getY(), location.getZ() + 0.5, yaw, entity.field_70125_A);
                player.field_71134_c.func_73080_a((WorldServer)destinationWorld);
                player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                playerList.func_72354_b(player, (WorldServer)destinationWorld);
                playerList.func_72385_f(player);
                for (PotionEffect potioneffect : player.func_70651_bq()) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
                }
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, player.field_71093_bK, location.getDim());
                return true;
            }
            player.field_71135_a.func_147364_a(location.getX() + 0.5, location.getY(), location.getZ() + 0.5, yaw, entity.field_70125_A);
            ((WorldServer)destinationWorld).func_72863_F().func_186028_c((int)location.getX() >> 4, (int)location.getZ() >> 4);
            return true;
        }
        return false;
    }

    private static void transferPlayerToWorld(Entity entity, WorldServer toWorldIn) {
        entity.func_70012_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5, entity.field_70177_z, entity.field_70125_A);
        toWorldIn.func_72838_d(entity);
        toWorldIn.func_72866_a(entity, false);
        entity.func_70029_a((World)toWorldIn);
    }

    public static boolean isOp(EntityPlayerMP player) {
        return FMLServerHandler.instance().getServer().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }
}

