/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.common.base.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.api.feature.Feature;
import net.minecraft.world.GameType;

@ParametersAreNonnullByDefault
public class Policy {
    private final String origin;
    private final Event event;
    private final Feature feature;
    private final GameType gameType;
    private final boolean allowed;
    private final long timestamp;

    public static Policy update(Policy original) {
        return new Policy(original.origin, Event.Update, original.gameType, original.feature, original.allowed, original.timestamp);
    }

    public static Policy update(String origin, GameType gameType, Feature feature, boolean allowed) {
        return new Policy(origin, Event.Update, gameType, feature, allowed, System.currentTimeMillis());
    }

    static Policy initialize(boolean isOp, GameType gameType, Feature feature) {
        return new Policy("journeymap", Event.Initialize, gameType, feature, feature.getDefaultAllowed(isOp, gameType), System.currentTimeMillis());
    }

    static Policy reset(boolean isOp, GameType gameType, Feature feature) {
        return new Policy("journeymap", Event.Reset, gameType, feature, feature.getDefaultAllowed(isOp, gameType), System.currentTimeMillis());
    }

    private Policy(String origin, Event event, GameType gameType, Feature feature, boolean allowed, long timestamp) {
        if (!feature.getClass().getDeclaringClass().equals(Feature.class)) {
            throw new IllegalArgumentException("Unknown feature class: " + feature.getClass());
        }
        this.origin = origin;
        this.event = event;
        this.gameType = gameType;
        this.feature = feature;
        this.allowed = allowed;
        this.timestamp = timestamp;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Event getEvent() {
        return this.event;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Policy{origin='" + this.origin + '\'' + ", event=" + (Object)((Object)this.event) + ", feature=" + this.feature + ", timestamp=" + this.timestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return this.allowed == policy.allowed && Objects.equal((Object)this.origin, (Object)policy.origin) && this.event == policy.event && Objects.equal((Object)this.feature, (Object)policy.feature);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.feature, this.allowed});
    }

    public static enum Event {
        Initialize,
        Reset,
        Update;

    }
}

