/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.common.collect.HashBasedTable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.Policy;
import net.minecraft.world.GameType;

@ParametersAreNonnullByDefault
public class PolicyTable {
    protected final HashBasedTable<Feature, GameType, Policy> policies = PolicyTable.createTable();

    public static HashBasedTable<Feature, GameType, Policy> createTable() {
        return HashBasedTable.create((int)PlayerFeatures.ALL_FEATURES.size(), (int)GameType.values().length);
    }

    public HashBasedTable<Feature, GameType, Policy> getTable() {
        return this.policies;
    }

    public String getOrigin(GameType gameType, Feature feature) {
        return this.getPolicy(gameType, feature).getOrigin();
    }

    public boolean isAllowed(GameType gameType, Feature feature) {
        return this.getPolicy(gameType, feature).isAllowed();
    }

    public void setPolicies(GameType gameType, Map<Feature, Policy> policyMap) {
        policyMap.forEach((feature, policy) -> this.setPolicy(gameType, (Policy)policy));
    }

    public Policy setAllowed(GameType gameType, Feature feature, boolean allowed, String origin) {
        return this.setPolicy(gameType, Policy.update(origin, gameType, feature, allowed));
    }

    public void setAllowed(Set<GameType> gameTypes, Feature feature, boolean allowed, String origin) {
        for (GameType gameType : gameTypes) {
            this.setPolicy(gameType, Policy.update(origin, gameType, feature, allowed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Policy getPolicy(GameType gameType, Feature feature) {
        HashBasedTable<Feature, GameType, Policy> hashBasedTable = this.policies;
        synchronized (hashBasedTable) {
            return this.policies.row((Object)feature).computeIfAbsent(gameType, gt -> this.initPolicy(false, gameType, feature));
        }
    }

    protected Policy initPolicy(boolean isOp, GameType gameType, Feature feature) {
        return Policy.initialize(isOp, gameType, feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Policy setPolicy(GameType gameType, Policy policy) {
        HashBasedTable<Feature, GameType, Policy> hashBasedTable = this.policies;
        synchronized (hashBasedTable) {
            this.policies.put((Object)policy.getFeature(), (Object)gameType, (Object)policy);
        }
        return policy;
    }

    public void reset(boolean isOp) {
        PlayerFeatures.ALL_FEATURES.forEach(feature -> PlayerFeatures.VALID_GAME_TYPES.forEach(type -> this.setPolicy((GameType)type, Policy.reset(isOp, type, feature))));
    }

    public void update(PolicyTable other) {
        PlayerFeatures.ALL_FEATURES.forEach(feature -> PlayerFeatures.VALID_GAME_TYPES.forEach(type -> {
            if (other.policies.contains(feature, type)) {
                Policy change = other.getPolicy((GameType)type, (Feature)feature);
                this.setPolicy((GameType)type, Policy.update(change));
            }
        }));
    }

    public void update(GameType gameType, Map<Feature, Boolean> featureMap, String origin) {
        featureMap.forEach((feature, allowed) -> this.setAllowed(gameType, (Feature)feature, (boolean)allowed, origin));
    }

    public Map<Feature, Boolean> getPermissionMap(GameType gameType) {
        TreeMap<Feature, Boolean> map = new TreeMap<Feature, Boolean>();
        PlayerFeatures.ALL_FEATURES.forEach(feature -> map.put((Feature)feature, this.isAllowed(gameType, (Feature)feature)));
        return map;
    }

    public Map<Feature, Policy> getPolicyMap(GameType gameType) {
        IdentityHashMap<Feature, Policy> map = new IdentityHashMap<Feature, Policy>();
        PlayerFeatures.ALL_FEATURES.forEach(feature -> {
            if (this.policies.contains(feature, (Object)gameType)) {
                map.put((Feature)feature, this.getPolicy(gameType, (Feature)feature));
            }
        });
        return map;
    }

    public void inflate() {
        PlayerFeatures.ALL_FEATURES.forEach(feature -> PlayerFeatures.VALID_GAME_TYPES.forEach(type -> this.isAllowed((GameType)type, (Feature)feature)));
    }

    public String toString() {
        return this.policies.toString();
    }
}

