/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import journeymap.client.feature.ClientFeatures;
import journeymap.common.Journeymap;
import journeymap.common.feature.DimensionPolicies;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DimensionPoliciesPacket
implements IMessage {
    public static final String CHANNEL_NAME = "jm_dim_policy";
    private String json;

    public DimensionPoliciesPacket() {
    }

    public DimensionPoliciesPacket(DimensionPolicies dimPolicies, boolean compact) {
        int length;
        String string = this.json = compact ? dimPolicies.toCompactJson() : dimPolicies.toJson();
        if (!compact && ByteBufUtils.varIntByteCount((int)(length = this.json.getBytes(StandardCharsets.UTF_8).length)) > 2) {
            Journeymap.getLogger().warn("DimensionPoliciesPacket json too large for verbose format: " + length);
            this.json = dimPolicies.toCompactJson();
        }
    }

    public String getJson() {
        return this.json;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.json = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message: %s", t));
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.json != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.json);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes] Failed to read message: " + t);
        }
    }

    public static class Listener
    implements IMessageHandler<DimensionPoliciesPacket, IMessage> {
        public IMessage onMessage(DimensionPoliciesPacket message, MessageContext ctx) {
            try {
                if (message.getJson() == null) {
                    Journeymap.getLogger().error("DimensionPoliciesPacket had no contents");
                    return null;
                }
                Journeymap.getClient().setServerEnabled(true);
                GameProfile gameProfile = ctx.getClientHandler().func_175105_e();
                String name = gameProfile.getName();
                DimensionPolicies newPolicies = DimensionPolicies.fromJson(message.getJson());
                DimensionPolicies oldPolicies = ClientFeatures.instance().get(newPolicies.getDimension());
                String info = String.format("Server features set for %s in dimension %s", name, newPolicies.getDimension());
                ClientFeatures.instance().logDeltas(info, oldPolicies, newPolicies);
                oldPolicies.update(newPolicies);
                return null;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("[DimensionPoliciesPacket.Listener.onMessage] " + t, t);
                return null;
            }
        }
    }
}

