/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.events;

import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.server.api.impl.ServerAPI;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandGameMode;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.server.CommandDeOp;
import net.minecraft.command.server.CommandOp;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

public enum ForgeEvents {
    INSTANCE;

    private Logger logger = Journeymap.getLogger();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerJoinWorldStart(EntityJoinWorldEvent event) {
        EntityPlayerMP player = this.getForgePlayer(event.getEntity());
        if (player != null) {
            ServerAPI.INSTANCE.pauseClientPackets(player);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Player %s joining dimension %s...", player.getDisplayNameString(), player.field_71093_bK));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoinWorldEnd(EntityJoinWorldEvent event) {
        EntityPlayerMP player = this.getForgePlayer(event.getEntity());
        if (player != null) {
            try {
                int delay = 500;
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    ServerAPI.INSTANCE.sendDimensionPolicies(player, dim, delay += 100);
                }
            }
            finally {
                ServerAPI.INSTANCE.resumeClientPackets(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCommandEvent(CommandEvent event) {
        ICommand command = event.getCommand();
        try {
            EntityPlayerMP player = null;
            if (command instanceof CommandOp || command instanceof CommandDeOp) {
                String username = event.getParameters()[0];
                MinecraftServer server = event.getSender().func_184102_h();
                player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)event.getSender(), (String)username);
            } else if (command instanceof CommandGameMode) {
                String[] args = event.getParameters();
                if (args.length >= 2) {
                    String username = event.getParameters()[1];
                    MinecraftServer server = event.getSender().func_184102_h();
                    player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)event.getSender(), (String)username);
                } else {
                    Entity sender = event.getSender().func_174793_f();
                    if (sender instanceof EntityPlayerMP) {
                        player = (EntityPlayerMP)sender;
                    }
                }
            }
            if (player != null) {
                int delay = 500;
                Integer[] integerArray = DimensionManager.getIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int dim = integerArray[i];
                    ServerAPI.INSTANCE.sendDimensionPolicies(player, dim, delay += 100);
                }
            }
        }
        catch (PlayerNotFoundException player) {
        }
        catch (Exception e) {
            this.logger.error(String.format("Error handling CommandEvent %s: %s", command, LogFormatter.toPartialString(e)));
        }
    }

    private EntityPlayerMP getForgePlayer(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            boolean hasForge = (Boolean)player.field_71135_a.func_147362_b().channel().attr(NetworkRegistry.FML_MARKER).get();
            if (hasForge) {
                return player;
            }
            Journeymap.getLogger().debug(String.format("Player %s joining dimension %s doesn't have Forge.", player.getDisplayNameString(), player.field_71093_bK));
        }
        return null;
    }
}

