/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.asset;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import goblinbob.mobends.core.Core;
import goblinbob.mobends.core.asset.AssetDefinition;
import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.asset.AssetManifest;
import goblinbob.mobends.core.asset.MalformedAssetException;
import goblinbob.mobends.core.env.EnvironmentModule;
import goblinbob.mobends.core.module.IModule;
import goblinbob.mobends.core.util.ConnectionHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.http.conn.HttpHostConnectException;

public class AssetsModule {
    public static AssetsModule INSTANCE;
    private final String apiUrl = EnvironmentModule.getConfig().getApiUrl();
    private final File assetsDirectory;
    private final File localManifestFile;
    private AssetManifest localManifest;

    public AssetsModule(File configDirectory) {
        File modConfigDirectory = new File(configDirectory, "mobends");
        this.assetsDirectory = new File(modConfigDirectory, "assets");
        this.assetsDirectory.mkdirs();
        this.localManifestFile = new File(modConfigDirectory, "asset_manifest.json");
        this.updateAssets();
    }

    private void fetchLocalManifest() {
        this.localManifest = null;
        if (this.localManifestFile.isFile()) {
            Gson gson = ConnectionHelper.INSTANCE.getGson();
            try {
                this.localManifest = (AssetManifest)gson.fromJson((Reader)new BufferedReader(new FileReader(this.localManifestFile)), AssetManifest.class);
            }
            catch (JsonParseException | FileNotFoundException e) {
                Core.LOG.warning("Failed to get local asset manifest.");
                e.printStackTrace();
            }
        }
    }

    private AssetManifest fetchOnlineManifest() {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            return ConnectionHelper.sendGetRequest(new URL(this.apiUrl + "/api/asset/manifest"), params, AssetManifest.class);
        }
        catch (HttpHostConnectException httpHostConnectException) {
        }
        catch (JsonParseException e) {
            Core.LOG.warning("Failed to parse online asset manifest.");
            e.printStackTrace();
        }
        catch (IOException | URISyntaxException e) {
            Core.LOG.warning("Failed to get online asset manifest.");
            e.printStackTrace();
        }
        return null;
    }

    private void storeManifestLocally(AssetManifest manifest) {
        try (FileWriter writer = new FileWriter(this.localManifestFile);){
            Gson gson = ConnectionHelper.INSTANCE.getGson();
            gson.toJson((Object)manifest, (Appendable)writer);
        }
        catch (JsonParseException | IOException e) {
            Core.LOG.warning("Failed to save local asset manifest.");
            e.printStackTrace();
        }
        this.localManifest = manifest;
    }

    private void downloadAsset(AssetManifest manifest, AssetDefinition asset) throws MalformedAssetException {
        try {
            URL url = new URL(manifest.getBaseUrl() + asset.getPath().getAssetPath());
            URLConnection connection = url.openConnection();
            DataInputStream dis = new DataInputStream(connection.getInputStream());
            byte[] fileData = new byte[connection.getContentLength()];
            for (int q = 0; q < fileData.length; ++q) {
                fileData[q] = dis.readByte();
            }
            dis.close();
            File localAssetPath = this.getAssetFile(asset.getPath());
            localAssetPath.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(localAssetPath);
            fos.write(fileData);
            fos.close();
        }
        catch (IOException m) {
            throw new MalformedAssetException(String.format("Couldn't download asset: %s", new Object[]{asset.getPath()}), m);
        }
    }

    public void updateAssets() {
        this.fetchLocalManifest();
        AssetManifest onlineManifest = this.fetchOnlineManifest();
        if (onlineManifest == null) {
            return;
        }
        Core.LOG.info("New assets detected");
        Iterable<AssetDefinition> assetsToUpdate = AssetManifest.getAssetsToUpdate(this.localManifest, onlineManifest);
        try {
            for (AssetDefinition asset : assetsToUpdate) {
                this.downloadAsset(onlineManifest, asset);
            }
            this.storeManifestLocally(onlineManifest);
        }
        catch (MalformedAssetException e) {
            Core.LOG.warning(e.getMessage());
        }
    }

    public Collection<AssetDefinition> getAssets() {
        return this.localManifest != null ? this.localManifest.getAssets() : Collections.emptyList();
    }

    public File getAssetFile(AssetLocation location) {
        return new File(this.assetsDirectory, location.getAssetPath());
    }

    public static class Factory
    implements IModule {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            INSTANCE = new AssetsModule(event.getModConfigurationDirectory());
        }

        @Override
        public void onRefresh() {
            INSTANCE.updateAssets();
        }
    }
}

