/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.controller;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.core.math.SmoothOrientation;
import goblinbob.mobends.standard.animation.bit.spider.SpiderCrawlAnimationBit;
import goblinbob.mobends.standard.animation.bit.spider.SpiderDeathAnimationBit;
import goblinbob.mobends.standard.animation.bit.spider.SpiderIdleAnimationBit;
import goblinbob.mobends.standard.animation.bit.spider.SpiderJumpAnimationBit;
import goblinbob.mobends.standard.animation.bit.spider.SpiderMoveAnimationBit;
import goblinbob.mobends.standard.data.SpiderData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.monster.EntitySpider;

public class SpiderController
implements IAnimationController<SpiderData> {
    protected HardAnimationLayer<SpiderData> layerBase = new HardAnimationLayer();
    protected AnimationBit<SpiderData> bitIdle = new SpiderIdleAnimationBit();
    protected AnimationBit<SpiderData> bitMove = new SpiderMoveAnimationBit();
    protected AnimationBit<SpiderData> bitJump = new SpiderJumpAnimationBit();
    protected AnimationBit<SpiderData> bitDeath = new SpiderDeathAnimationBit();
    protected AnimationBit<SpiderData> bitClimb = new SpiderCrawlAnimationBit();
    protected boolean resetAfterJumped = false;

    @Override
    public Collection<String> perform(SpiderData spiderData) {
        EntitySpider spider = (EntitySpider)spiderData.getEntity();
        if (spider.func_110143_aJ() <= 0.0f) {
            this.layerBase.playOrContinueBit(this.bitDeath, spiderData);
        } else if (spider.func_70841_p()) {
            this.layerBase.playOrContinueBit(this.bitClimb, spiderData);
        } else if (!spiderData.isOnGround() || spiderData.getTicksAfterTouchdown() < 1.0f) {
            this.layerBase.playOrContinueBit(this.bitJump, spiderData);
            if (this.resetAfterJumped) {
                this.resetAfterJumped = false;
            }
        } else {
            if (!this.resetAfterJumped) {
                for (SpiderData.Limb limb : spiderData.limbs) {
                    limb.resetPosition();
                }
                this.resetAfterJumped = true;
            }
            if (spiderData.isStillHorizontally()) {
                this.layerBase.playOrContinueBit(this.bitIdle, spiderData);
            } else {
                this.layerBase.playOrContinueBit(this.bitMove, spiderData);
            }
        }
        ArrayList<String> actions = new ArrayList<String>();
        this.layerBase.perform(spiderData, actions);
        return actions;
    }

    public static void putLimbOnGround(SmoothOrientation upperLimb, SmoothOrientation lowerLimb, boolean odd, double stretchDistance, double groundLevel) {
        SpiderController.putLimbOnGround(upperLimb, lowerLimb, odd, stretchDistance, groundLevel, 1.0f);
        upperLimb.finish();
        lowerLimb.finish();
    }

    public static void putLimbOnGround(SmoothOrientation upperLimb, SmoothOrientation lowerLimb, boolean odd, double stretchDistance, double groundLevel, float smoothness) {
        double c;
        float limbSegmentLength = 12.0f;
        float maxStretch = 24.0f;
        double d = c = groundLevel == 0.0 ? stretchDistance : Math.sqrt(stretchDistance * stretchDistance + groundLevel * groundLevel);
        if (c > 24.0) {
            c = 24.0;
        }
        double alpha = c > 24.0 ? 0.0 : Math.acos(c / 2.0 / 12.0);
        double beta = Math.atan2(stretchDistance, -groundLevel);
        double lowerAngle = Math.max(-2.3, -2.0 * alpha);
        double upperAngle = Math.min(1.0, alpha + beta - 1.5707963267948966);
        upperLimb.setSmoothness(smoothness).localRotateZ((float)(upperAngle / Math.PI * 180.0) * (float)(odd ? -1 : 1));
        lowerLimb.setSmoothness(smoothness).orientZ((float)(lowerAngle / Math.PI * 180.0) * (float)(odd ? -1 : 1));
    }
}

