/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.mutators;

import goblinbob.mobends.core.client.model.IModelPart;
import goblinbob.mobends.core.client.model.ModelPart;
import goblinbob.mobends.core.data.IEntityDataFactory;
import goblinbob.mobends.core.mutators.Mutator;
import goblinbob.mobends.standard.data.SquidData;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.passive.EntitySquid;

public class SquidMutator
extends Mutator<SquidData, EntitySquid, ModelSquid> {
    public ModelPart squidBody;
    public ModelPart[][] squidTentacles = new ModelPart[8][9];

    public SquidMutator(IEntityDataFactory<EntitySquid> dataFactory) {
        super(dataFactory);
    }

    @Override
    public void storeVanillaModel(ModelSquid model) {
        this.vanillaModel = new ModelSquid();
        ((ModelSquid)this.vanillaModel).field_78202_a = model.field_78202_a;
        ((ModelSquid)this.vanillaModel).field_78201_b = model.field_78201_b;
    }

    @Override
    public void applyVanillaModel(ModelSquid model) {
        model.field_78202_a = ((ModelSquid)this.vanillaModel).field_78202_a;
        model.field_78201_b = ((ModelSquid)this.vanillaModel).field_78201_b;
    }

    @Override
    public void swapLayer(RenderLivingBase<? extends EntitySquid> renderer, int index, boolean isModelVanilla) {
    }

    @Override
    public void deswapLayer(RenderLivingBase<? extends EntitySquid> renderer, int index) {
    }

    @Override
    public boolean createParts(ModelSquid original, float scaleFactor) {
        float legLength = 12.0f;
        float foreLegLength = 15.0f;
        this.squidBody = new ModelPart((ModelBase)original, 0, 0);
        original.field_78202_a = this.squidBody;
        this.squidBody.setPosition(0.0f, 8.0f, 0.0f);
        this.squidBody.addBox(-6.0f, -8.0f, -6.0f, 12, 16, 12);
        original.field_78201_b = new ModelRenderer[8];
        for (int i = 0; i < this.squidTentacles.length; ++i) {
            ModelPart modelPart = new ModelPart((ModelBase)original, 48, 0);
            this.squidTentacles[i][0] = modelPart;
            original.field_78201_b[i] = modelPart;
            double d0 = (double)i * Math.PI * 2.0 / (double)this.squidTentacles.length;
            float f = (float)Math.cos(d0) * 4.0f;
            float f1 = (float)Math.sin(d0) * 4.0f;
            d0 = (double)i * -360.0 / (double)this.squidTentacles.length + 90.0;
            this.squidTentacles[i][0].setPosition(f, 16.0f, f1);
            this.squidTentacles[i][0].addBox(-1.0f, 0.0f, 0.0f, 2, 2, 2);
            this.squidTentacles[i][0].rotation.rotateY((float)d0);
            for (int j = 1; j < 9; ++j) {
                this.squidTentacles[i][j] = new ModelPart((ModelBase)original, 48, 0);
                this.squidTentacles[i][j].setPosition(0.0f, 2.0f, 0.0f);
                this.squidTentacles[i][j].addBox(-1.0f, 0.0f, -2.0f, 2, 2, 2);
                this.squidTentacles[i][j - 1].func_78792_a(this.squidTentacles[i][j]);
            }
        }
        return true;
    }

    @Override
    public void syncUpWithData(SquidData data) {
        this.squidBody.syncUp(data.squidBody);
        for (int i = 0; i < this.squidTentacles.length; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.squidTentacles[i][j].syncUp(data.squidTentacles[i][j]);
            }
        }
    }

    @Override
    public boolean isModelVanilla(ModelSquid model) {
        return !(model.field_78202_a instanceof IModelPart);
    }

    @Override
    public boolean shouldModelBeSkipped(ModelBase model) {
        return !(model instanceof ModelSquid);
    }
}

