/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.gen.generators.LargeStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class DungeonBase
extends LargeStructure {
    public DungeonBase(String name) {
        super(name);
    }

    @Override
    public BlockPos findStructurePos(World world, BlockPos initialPos) {
        BlockPos biomePos;
        this.readDungeonData(world);
        if (this.dungeonPos.equals((Object)BlockPos.field_177992_a) && !(biomePos = super.findBiomePos(world, initialPos)).equals((Object)BlockPos.field_177992_a)) {
            int x = biomePos.func_177958_n() + 8;
            int z = biomePos.func_177952_p() + 8;
            int y = this.getYStartBlockPos();
            this.dungeonPos = new BlockPos(x, y, z);
            this.writeDungeonData(world);
            int chunkX = this.dungeonPos.func_177958_n() >> 4;
            int chunkZ = this.dungeonPos.func_177952_p() >> 4;
            if (world.func_72863_F().func_191062_e(chunkX, chunkZ)) {
                this.generateStructure(world, world.field_73012_v, chunkX, chunkZ);
            }
        }
        return this.dungeonPos;
    }

    @Override
    public BlockPos shouldStartAt(World world, Random random, int chunkX, int chunkZ) {
        ChunkPos initialStructureChunkPos;
        this.readDungeonData(world);
        if (!this.dungeonPos.equals((Object)BlockPos.field_177992_a) && (initialStructureChunkPos = new ChunkPos(this.dungeonPos)).equals((Object)new ChunkPos(chunkX, chunkZ))) {
            int xCord = this.dungeonPos.func_177958_n();
            int zCord = this.dungeonPos.func_177952_p();
            int yCord = WorldGenCustomStructures.calculateGenerationHeight(world, xCord, zCord, new Block[]{Blocks.field_150355_j}) - 62 + this.getYStartBlockPos();
            BlockPos blockPos = new BlockPos(xCord, yCord, zCord);
            return blockPos;
        }
        return BlockPos.field_177992_a;
    }

    private boolean isChunkInsideStructureBB(int ChunkX, int ChunkZ) {
        if (settings.func_186213_g() != null) {
            int x = (ChunkX + 1 << 4) - 1;
            int z = (ChunkZ + 1 << 4) - 1;
            int y = DungeonBase.settings.func_186213_g().field_78895_b;
            return settings.func_186213_g().func_175898_b(new Vec3i(x, y, z));
        }
        return false;
    }

    public abstract ItemStack getDungeonBook();

    public abstract int getYStartBlockPos();
}

