/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.io.IOException;
import java.util.List;
import net.minecraftforge.fml.client.GuiErrorBase;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.lwjgl.input.Mouse;

public class GuiMultipleModsErrored
extends GuiErrorBase {
    private final List<WrongMinecraftVersionException> wrongMinecraftExceptions;
    private final List<MissingModsException> missingModsExceptions;
    private GuiList list;

    public GuiMultipleModsErrored(MultipleModsErrored exception) {
        this.wrongMinecraftExceptions = exception.wrongMinecraftExceptions;
        this.missingModsExceptions = exception.missingModsExceptions;
    }

    @Override
    public void b() {
        super.b();
        int additionalSize = this.missingModsExceptions.isEmpty() || this.wrongMinecraftExceptions.isEmpty() ? 20 : 55;
        for (MissingModsException exception : this.missingModsExceptions) {
            additionalSize += exception.getMissingModInfos().size() * 10;
        }
        this.list = new GuiList(this.wrongMinecraftExceptions.size() * 10 + this.missingModsExceptions.size() * 15 + additionalSize);
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        this.list.drawScreen(mouseX, mouseY, partialTicks);
        this.a(this.q, cey.a((String)"fml.messages.mod.missing.multiple", (Object[])new Object[]{this.missingModsExceptions.size() + this.wrongMinecraftExceptions.size()}), this.l / 2, 10, 0xFFFFFF);
        super.a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void a(bja button) {
        this.list.actionPerformed(button);
        super.a(button);
    }

    public void k() throws IOException {
        super.k();
        int mouseX = Mouse.getEventX() * this.l / this.j.d;
        int mouseY = this.m - Mouse.getEventY() * this.m / this.j.e - 1;
        this.list.handleMouseInput(mouseX, mouseY);
    }

    private class GuiList
    extends GuiScrollingList {
        public GuiList(int entryHeight) {
            super(GuiMultipleModsErrored.this.j, GuiMultipleModsErrored.this.l - 20, GuiMultipleModsErrored.this.m - 30, 30, GuiMultipleModsErrored.this.m - 50, 10, entryHeight, GuiMultipleModsErrored.this.l, GuiMultipleModsErrored.this.m);
        }

        @Override
        protected int getSize() {
            return 1;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
            GuiMultipleModsErrored.this.c();
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, bve tess) {
            int offset = slotTop;
            bip renderer = GuiMultipleModsErrored.this.q;
            if (!GuiMultipleModsErrored.this.wrongMinecraftExceptions.isEmpty()) {
                renderer.a(a.t + cey.a((String)"fml.messages.mod.wrongminecraft", (Object[])new Object[]{Loader.instance().getMinecraftModContainer().getVersion()}), this.left, offset, 0xFFFFFF);
                offset += 15;
                for (EnhancedRuntimeException exception : GuiMultipleModsErrored.this.wrongMinecraftExceptions) {
                    renderer.a(cey.a((String)"fml.messages.mod.wrongminecraft.requirement", (Object[])new Object[]{a.r + ((WrongMinecraftVersionException)exception).mod.getName() + a.v, ((WrongMinecraftVersionException)exception).mod.getModId(), ((WrongMinecraftVersionException)exception).mod.acceptableMinecraftVersionRange().toStringFriendly()}), this.left, offset, 0xFFFFFF);
                    offset += 10;
                }
                renderer.a(cey.a((String)"fml.messages.mod.wrongminecraft.fix.multiple", (Object[])new Object[0]), this.left, offset += 5, 0xFFFFFF);
                offset += 20;
            }
            if (!GuiMultipleModsErrored.this.missingModsExceptions.isEmpty()) {
                renderer.a(cey.a((String)"fml.messages.mod.missing.dependencies.multiple.issues", (Object[])new Object[0]), this.left, offset, 0xFFFFFF);
                offset += 15;
                for (EnhancedRuntimeException exception : GuiMultipleModsErrored.this.missingModsExceptions) {
                    renderer.a(((MissingModsException)exception).getModName() + ":", this.left, offset, 0xFFFFFF);
                    for (MissingModsException.MissingModInfo versionInfo : ((MissingModsException)exception).getMissingModInfos()) {
                        ModContainer acceptedMod;
                        DefaultArtifactVersion dav;
                        ArtifactVersion acceptedVersion = versionInfo.getAcceptedVersion();
                        String acceptedModId = acceptedVersion.getLabel();
                        ArtifactVersion currentVersion = versionInfo.getCurrentVersion();
                        String missingReason = currentVersion == null ? cey.a((String)"fml.messages.mod.missing.dependencies.missing", (Object[])new Object[0]) : cey.a((String)"fml.messages.mod.missing.dependencies.you.have", (Object[])new Object[]{currentVersion.getVersionString()});
                        String acceptedModVersionString = acceptedVersion.getRangeString();
                        if (acceptedVersion instanceof DefaultArtifactVersion && (dav = (DefaultArtifactVersion)acceptedVersion).getRange() != null) {
                            acceptedModVersionString = dav.getRange().toStringFriendly();
                        }
                        String acceptedModName = (acceptedMod = Loader.instance().getIndexedModList().get(acceptedModId)) != null ? acceptedMod.getName() : acceptedModId;
                        String versionInfoText = String.format(a.r + "%s " + a.v + "%s (%s)", acceptedModName, acceptedModVersionString, missingReason);
                        String message = versionInfo.isRequired() ? cey.a((String)"fml.messages.mod.missing.dependencies.requires", (Object[])new Object[]{versionInfoText}) : cey.a((String)"fml.messages.mod.missing.dependencies.compatible.with", (Object[])new Object[]{versionInfoText});
                        renderer.a(message, this.left, offset += 10, 0xEEEEEE);
                    }
                    offset += 15;
                }
            }
        }
    }
}

