/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.crafting;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPBlocks;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.AutoCraftingGui;
import logisticspipes.network.packets.block.CraftingSetType;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.IResource;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import network.rs485.logisticspipes.property.BitSetProperty;
import network.rs485.logisticspipes.property.IBitSet;
import network.rs485.logisticspipes.util.FuzzyUtil;
import network.rs485.logisticspipes.util.items.ItemStackLoader;

public class LogisticsCraftingTableTileEntity
extends LogisticsSolidTileEntity
implements IInventory,
IGuiTileEntity,
ISimpleInventoryEventHandler,
IGuiOpenControler {
    public final BitSetProperty fuzzyFlags = new BitSetProperty(new BitSet(40), "fuzzyBitSet");
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(18, "Crafting Resources", 64);
    public ItemIdentifierInventory matrix = new ItemIdentifierInventory(9, "Crafting Matrix", 1);
    public ItemIdentifierInventory resultInv = new ItemIdentifierInventory(1, "Crafting Result", 1);
    public ItemIdentifier targetType = null;
    private InventoryCraftResult vanillaResult = new InventoryCraftResult();
    private IRecipe cache;
    private EntityPlayerMP fake;
    private PlayerIdentifier placedBy = null;
    private InvWrapper invWrapper = new InvWrapper((IInventory)this);
    private PlayerCollectionList guiWatcher = new PlayerCollectionList();

    public LogisticsCraftingTableTileEntity() {
        this.matrix.addListener(this);
    }

    public void cacheRecipe() {
        ItemIdentifier oldTargetType = this.targetType;
        this.cache = null;
        this.resultInv.clearInventorySlotContents(0);
        AutoCraftingInventory craftInv = new AutoCraftingInventory(this.placedBy);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.func_145831_w())) continue;
            list.add(r);
        }
        if (list.size() == 1) {
            this.cache = (IRecipe)list.get(0);
            this.resultInv.func_70299_a(0, this.cache.func_77572_b((InventoryCrafting)craftInv));
            this.targetType = null;
        } else if (list.size() > 1) {
            ItemStack result2;
            if (this.targetType != null) {
                for (IRecipe recipe : list) {
                    craftInv = new AutoCraftingInventory(this.placedBy);
                    for (int i = 0; i < 9; ++i) {
                        craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                    }
                    result2 = recipe.func_77572_b((InventoryCrafting)craftInv);
                    if (result2.func_190926_b() || !this.targetType.equals(ItemIdentifier.get(result2))) continue;
                    this.resultInv.func_70299_a(0, result2);
                    this.cache = recipe;
                    break;
                }
            }
            if (this.cache == null) {
                for (IRecipe r : list) {
                    result2 = r.func_77572_b((InventoryCrafting)craftInv);
                    if (result2.func_190926_b()) continue;
                    this.cache = r;
                    this.resultInv.func_70299_a(0, result2);
                    this.targetType = ItemIdentifier.get(result2);
                    break;
                }
            }
        } else {
            this.targetType = null;
        }
        if ((this.targetType == null && oldTargetType != null || this.targetType != null && !this.targetType.equals(oldTargetType)) && !this.guiWatcher.isEmpty() && MainProxy.isServer((IBlockAccess)this.func_145831_w())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this), this.guiWatcher);
        }
    }

    public void cycleRecipe(boolean down) {
        this.cacheRecipe();
        if (this.targetType == null) {
            return;
        }
        this.cache = null;
        AutoCraftingInventory craftInv = new AutoCraftingInventory(this.placedBy);
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.func_145831_w())) continue;
            list.add(r);
        }
        if (list.size() > 1) {
            boolean found = false;
            IRecipe prev = null;
            for (IRecipe recipe : list) {
                if (found) {
                    this.cache = recipe;
                    break;
                }
                craftInv = new AutoCraftingInventory(this.placedBy);
                for (int i = 0; i < 9; ++i) {
                    craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
                }
                if (this.targetType != null && this.targetType.equals(ItemIdentifier.get(recipe.func_77572_b((InventoryCrafting)craftInv)))) {
                    if (down) {
                        found = true;
                    } else {
                        if (prev == null) {
                            this.cache = (IRecipe)list.get(list.size() - 1);
                            break;
                        }
                        this.cache = prev;
                        break;
                    }
                }
                prev = recipe;
            }
            if (this.cache == null) {
                this.cache = (IRecipe)list.get(0);
            }
            craftInv = new AutoCraftingInventory(this.placedBy);
            for (int i = 0; i < 9; ++i) {
                craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
            }
            this.targetType = ItemIdentifier.get(this.cache.func_77572_b((InventoryCrafting)craftInv));
        }
        if (!this.guiWatcher.isEmpty() && MainProxy.isServer((IBlockAccess)this.func_145831_w())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(CraftingSetType.class).setTargetType(this.targetType).setTilePos(this), this.guiWatcher);
        }
        this.cacheRecipe();
    }

    public IBitSet outputFuzzy() {
        int startIdx = 36;
        return this.fuzzyFlags.get(36, 39);
    }

    public IBitSet inputFuzzy(int slot) {
        int startIdx = 4 * slot;
        return this.fuzzyFlags.get(startIdx, startIdx + 3);
    }

    @Nonnull
    public ItemStack getOutput(IResource wanted, IRoutedPowerProvider power) {
        ItemStack left;
        int i;
        ItemStack result2;
        boolean isFuzzy = this.isFuzzy();
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return ItemStack.field_190927_a;
            }
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemIdentifierStack item = this.matrix.getIDStackInSlot(i2);
            if (item == null) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = item.getItem();
            for (int j = 0; j < this.inv.func_70302_i_(); ++j) {
                boolean doItemsEqual;
                item = this.inv.getIDStackInSlot(j);
                if (item == null) continue;
                boolean bl = doItemsEqual = isFuzzy ? FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.inputFuzzy(i2)), ident, item.getItem()) : ident.equalsForCrafting(item.getItem());
                if (!doItemsEqual || item.getStackSize() <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return ItemStack.field_190927_a;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory(this.placedBy);
        for (int i3 = 0; i3 < 9; ++i3) {
            int j = toUse[i3];
            if (j == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j));
        }
        IRecipe recipe = this.cache;
        ItemIdentifierStack outStack = Objects.requireNonNull(this.resultInv.getIDStackInSlot(0));
        if (!recipe.func_77569_a((InventoryCrafting)crafter, this.func_145831_w())) {
            if (isFuzzy && this.outputFuzzy().nextSetBit(0) != -1) {
                recipe = null;
                for (IRecipe r : CraftingUtil.getRecipeList()) {
                    if (!r.func_77569_a((InventoryCrafting)crafter, this.func_145831_w()) || !FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.outputFuzzy()), outStack.getItem(), ItemIdentifier.get(r.func_77571_b()))) continue;
                    recipe = r;
                    break;
                }
                if (recipe == null) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
        }
        if ((result2 = recipe.func_77572_b((InventoryCrafting)crafter)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (isFuzzy && this.outputFuzzy().nextSetBit(0) != -1) {
            if (!FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.outputFuzzy()), outStack.getItem(), ItemIdentifier.get(result2))) {
                return ItemStack.field_190927_a;
            }
            if (!FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.outputFuzzy()), wanted.getAsItem(), ItemIdentifier.get(result2))) {
                return ItemStack.field_190927_a;
            }
        } else {
            if (!outStack.getItem().equalsWithoutNBT(ItemIdentifier.get(result2))) {
                return ItemStack.field_190927_a;
            }
            if (!wanted.matches(outStack.getItem(), IResource.MatchSettings.WITHOUT_NBT)) {
                return ItemStack.field_190927_a;
            }
        }
        if (!power.useEnergy(Configs.LOGISTICS_CRAFTING_TABLE_POWER_USAGE)) {
            return ItemStack.field_190927_a;
        }
        crafter = new AutoCraftingInventory(this.placedBy);
        for (int i4 = 0; i4 < 9; ++i4) {
            int j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result2 = recipe.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer(this.field_145850_b);
        }
        result2 = result2.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting((EntityPlayer)this.fake, crafter, this.resultInv, 0, 0, 0){

            protected void func_75208_c(@Nonnull ItemStack stack) {
                IInventory tmp = this.field_75224_c;
                LogisticsCraftingTableTileEntity.this.vanillaResult.func_193056_a(LogisticsCraftingTableTileEntity.this.cache);
                this.field_75224_c = LogisticsCraftingTableTileEntity.this.vanillaResult;
                super.func_75208_c(stack);
                this.field_75224_c = tmp;
            }
        };
        result2 = craftingSlot.func_190901_a((EntityPlayer)this.fake, result2);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, ItemStack.field_190927_a);
            if (left.func_190926_b()) continue;
            left.func_190920_e(this.inv.addCompressed(left, false));
            if (left.func_190916_E() <= 0) continue;
            ItemIdentifierInventory.dropItems(this.field_145850_b, left, this.func_174877_v());
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            if (left.func_190926_b()) continue;
            left.func_190920_e(this.inv.addCompressed(left, false));
            if (left.func_190916_E() <= 0) continue;
            ItemIdentifierInventory.dropItems(this.field_145850_b, left, this.func_174877_v());
        }
        return result2;
    }

    @Override
    public void onBlockBreak() {
        this.inv.dropContents(this.field_145850_b, this.func_174877_v());
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(NonNullList<ItemStack> content) {
        if (this.matrix.func_70302_i_() != content.size()) {
            throw new IllegalStateException("Different sizes of matrix and inventory from packet");
        }
        for (int i = 0; i < content.size(); ++i) {
            this.matrix.func_70299_a(i, (ItemStack)content.get(i));
        }
        this.cacheRecipe();
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        if (par1nbtTagCompound.func_74764_b("placedBy")) {
            String name = par1nbtTagCompound.func_74779_i("placedBy");
            this.placedBy = PlayerIdentifier.convertFromUsername(name);
        } else {
            this.placedBy = PlayerIdentifier.readFromNBT(par1nbtTagCompound, "placedBy");
        }
        this.fuzzyFlags.readFromNBT(par1nbtTagCompound);
        if (par1nbtTagCompound.func_74764_b("fuzzyFlags")) {
            NBTTagList lst = par1nbtTagCompound.func_150295_c("fuzzyFlags", 10);
            for (int i = 0; i < 9; ++i) {
                FuzzyUtil.INSTANCE.readFromNBT(this.inputFuzzy(i), lst.func_150305_b(i));
            }
        }
        if (par1nbtTagCompound.func_74764_b("outputFuzzyFlags")) {
            FuzzyUtil.INSTANCE.readFromNBT(this.outputFuzzy(), par1nbtTagCompound.func_74775_l("outputFuzzyFlags"));
        }
        if (par1nbtTagCompound.func_74764_b("targetType")) {
            this.targetType = ItemIdentifier.get(ItemStackLoader.loadAndFixItemStackFromNBT(par1nbtTagCompound.func_74775_l("targetType")));
        }
        this.cacheRecipe();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound par1nbtTagCompound) {
        par1nbtTagCompound = super.func_189515_b(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
        if (this.placedBy != null) {
            this.placedBy.writeToNBT(par1nbtTagCompound, "placedBy");
        }
        this.fuzzyFlags.writeToNBT(par1nbtTagCompound);
        if (this.targetType != null) {
            NBTTagCompound type = new NBTTagCompound();
            this.targetType.makeNormalStack(1).func_77955_b(type);
            par1nbtTagCompound.func_74782_a("targetType", (NBTBase)type);
        } else {
            par1nbtTagCompound.func_82580_o("targetType");
        }
        return par1nbtTagCompound;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        ItemIdentifierStack stack;
        if (i < 9 && i >= 0 && (stack = this.matrix.getIDStackInSlot(i)) != null && !itemstack.func_190926_b()) {
            if (this.isFuzzy() && this.inputFuzzy(i).nextSetBit(0) != -1) {
                return FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.inputFuzzy(i)), stack.getItem(), ItemIdentifier.get(itemstack));
            }
            return stack.getItem().equalsWithoutNBT(ItemIdentifier.get(itemstack));
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void placedBy(EntityLivingBase par5EntityLivingBase) {
        if (par5EntityLivingBase instanceof EntityPlayer) {
            this.placedBy = PlayerIdentifier.get((EntityPlayer)par5EntityLivingBase);
        }
    }

    public boolean isFuzzy() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == LPBlocks.crafterFuzzy;
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(AutoCraftingGui.class).setCraftingTable(this);
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiWatcher.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiWatcher.remove(player);
    }

    @Nonnull
    public String func_70005_c_() {
        return "LogisticsCraftingTable";
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return null;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload worldEvent) {
        if (this.fake.field_70170_p == worldEvent.getWorld()) {
            this.fake = null;
        }
    }
}

