/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.stats;

import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.items.ItemStackLoader;

public class TrackingTask {
    public int everyNthTick = 1200;
    public ItemIdentifier item;
    public int arrayPos = 0;
    public long[] amountRecorded = new long[1440];

    public void tick(int tickCount, CoreRoutedPipe pipe) {
        if (tickCount % this.everyNthTick != 0) {
            return;
        }
        this.amountRecorded[this.arrayPos++] = SimpleServiceLocator.logisticsManager.getAmountFor(this.item, pipe.getRouter().getIRoutersByCost());
        if (this.arrayPos >= this.amountRecorded.length) {
            this.arrayPos = 0;
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        int[] amountRecorded_A = nbt.func_74759_k("amountRecorded_A");
        int[] amountRecorded_B = nbt.func_74759_k("amountRecorded_B");
        for (int i = 0; i < this.amountRecorded.length && i < amountRecorded_A.length && i < amountRecorded_B.length; ++i) {
            this.amountRecorded[i] = (long)amountRecorded_B[i] << 32 | (long)amountRecorded_A[i];
        }
        this.arrayPos = nbt.func_74762_e("arrayPos");
        this.item = ItemIdentifier.get(ItemStackLoader.loadAndFixItemStackFromNBT(nbt));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        int[] amountRecorded_A = new int[this.amountRecorded.length];
        int[] amountRecorded_B = new int[this.amountRecorded.length];
        for (int i = 0; i < this.amountRecorded.length; ++i) {
            amountRecorded_A[i] = (int)this.amountRecorded[i];
            amountRecorded_B[i] = (int)(this.amountRecorded[i] >> 32);
        }
        nbt.func_74783_a("amountRecorded_A", amountRecorded_A);
        nbt.func_74783_a("amountRecorded_B", amountRecorded_B);
        nbt.func_74768_a("arrayPos", this.arrayPos);
        this.item.makeNormalStack(1).func_77955_b(nbt);
    }

    public void writeToLPData(LPDataOutput output) {
        output.writeLongArray(this.amountRecorded);
        output.writeInt(this.arrayPos);
        output.writeItemIdentifier(this.item);
    }

    public void readFromLPData(LPDataInput input) {
        this.amountRecorded = input.readLongArray();
        this.arrayPos = input.readInt();
        this.item = input.readItemIdentifier();
    }
}

