/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.request.resources.IResource;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import network.rs485.logisticspipes.util.TextUtil;

public class GuiRequestPopup
extends SubGuiScreen {
    private String[] text;
    private int mWidth = 0;
    private EntityPlayer player;

    public GuiRequestPopup(EntityPlayer player, Object ... message) {
        super(200, message.length * 10 + 40, 0, 0);
        ArrayList<String> textArray = new ArrayList<String>();
        for (Object o : message) {
            if (o instanceof String) {
                textArray.add((String)o);
                continue;
            }
            if (o instanceof Collection) {
                for (Object oTwo : (Collection)o) {
                    if (oTwo instanceof ItemIdentifierStack) {
                        textArray.add(((ItemIdentifierStack)oTwo).getFriendlyName());
                    }
                    if (!(oTwo instanceof IResource)) continue;
                    textArray.add(((IResource)oTwo).getDisplayText(IResource.ColorCode.NONE));
                }
                continue;
            }
            textArray.add(o.toString());
        }
        this.text = textArray.toArray(new String[0]);
        this.ySize = this.text.length * 10 + 40;
        this.player = player;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.xCenter - 55, this.bottom - 25, 50, 20, "OK"));
        this.field_146292_n.add(new GuiButton(1, this.xCenter + 5, this.bottom - 25, 50, 20, "Log"));
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        if (this.mWidth == 0) {
            int lWidth = 0;
            for (String msg : this.text) {
                int tWidth = this.field_146297_k.field_71466_p.func_78256_a(msg);
                if (tWidth <= lWidth) continue;
                lWidth = tWidth;
            }
            this.xSize = this.mWidth = Math.max(Math.min(lWidth + 20, 400), 120);
            super.func_73866_w_();
        }
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        for (int i = 0; i < this.text.length; ++i) {
            if (this.text[i] == null) continue;
            String msg = TextUtil.getTrimmedString(this.text[i], this.mWidth - 10, this.field_146289_q, "...");
            int stringWidth = this.field_146297_k.field_71466_p.func_78256_a(msg);
            this.field_146297_k.field_71466_p.func_78276_b(msg, this.xCenter - stringWidth / 2, this.guiTop + 10 + i * 10, 0x404040);
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        switch (guibutton.field_146127_k) {
            case 0: {
                super.exitGui();
                break;
            }
            case 1: {
                for (String msg : this.text) {
                    this.player.func_145747_a((ITextComponent)new TextComponentString(msg));
                }
                ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
            }
        }
    }
}

