/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.json.internal;

import java.util.Map;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.NoWhenBranchMatchedException;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlinx.serialization.json.Json;
import logisticspipes.kotlinx.serialization.json.JsonArray;
import logisticspipes.kotlinx.serialization.json.JsonArraySerializer;
import logisticspipes.kotlinx.serialization.json.JsonElement;
import logisticspipes.kotlinx.serialization.json.JsonObject;
import logisticspipes.kotlinx.serialization.json.JsonObjectSerializer;
import logisticspipes.kotlinx.serialization.json.JsonPrimitive;
import logisticspipes.kotlinx.serialization.json.internal.JsonExceptionsKt;
import logisticspipes.kotlinx.serialization.json.internal.JsonTreeEncoder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llogisticspipes/kotlinx/serialization/json/internal/JsonTreeMapEncoder;", "Llogisticspipes/kotlinx/serialization/json/internal/JsonTreeEncoder;", "json", "Llogisticspipes/kotlinx/serialization/json/Json;", "nodeConsumer", "Llogisticspipes/kotlin/Function1;", "Llogisticspipes/kotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "isKey", "", "tag", "", "getCurrent", "putElement", "key", "element", "logisticspipes.kotlinx-serialization-json"})
final class JsonTreeMapEncoder
extends JsonTreeEncoder {
    private String tag;
    private boolean isKey;

    @Override
    public void putElement(@NotNull String key, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.isKey) {
            JsonElement jsonElement = element;
            if (!(jsonElement instanceof JsonPrimitive)) {
                if (jsonElement instanceof JsonObject) {
                    throw (Throwable)JsonExceptionsKt.InvalidKeyKindException(JsonObjectSerializer.INSTANCE.getDescriptor());
                }
                if (jsonElement instanceof JsonArray) {
                    throw (Throwable)JsonExceptionsKt.InvalidKeyKindException(JsonArraySerializer.INSTANCE.getDescriptor());
                }
                throw new NoWhenBranchMatchedException();
            }
            this.tag = ((JsonPrimitive)element).getContent();
            this.isKey = false;
        } else {
            Map<String, JsonElement> map2 = this.getContent();
            String string = this.tag;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("tag");
            }
            map2.put(string, element);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    public JsonElement getCurrent() {
        return new JsonObject(this.getContent());
    }

    public JsonTreeMapEncoder(@NotNull Json json, @NotNull Function1<? super JsonElement, Unit> nodeConsumer) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(nodeConsumer, "nodeConsumer");
        super(json, nodeConsumer);
        this.isKey = true;
    }
}

