/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.module.inpipe.FluidSupplierSlot;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.InventoryProperty;
import network.rs485.logisticspipes.property.Property;

public class ModuleFluidSupplier
extends LogisticsModule
implements IClientInformationProvider,
Gui {
    private final InventoryProperty filterInventory = new InventoryProperty(new ItemIdentifierInventory(9, "Requested liquids", 1), "");
    private SinkReply _sinkReply;

    @Override
    @Nonnull
    public String getLPName() {
        throw new RuntimeException("Cannot get LP name for " + this);
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return Collections.singletonList(this.filterInventory);
    }

    @Nonnull
    public IInventory getFilterInventory() {
        return this.filterInventory;
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 0, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        if (this.filterInventory.containsItem(item)) {
            service.spawnParticle(Particles.VioletParticle, 2);
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(FluidSupplierSlot.class);
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        throw new UnsupportedOperationException("Fluid Supplier GUI cannot be opened in hand");
    }
}

